/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.input;

import de.kosit.validationtool.api.Input;
import de.kosit.validationtool.impl.input.LazyReadInput;
import de.kosit.validationtool.impl.input.StreamHelper;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInput
implements Input,
LazyReadInput {
    private static final Logger log = LoggerFactory.getLogger(AbstractInput.class);
    private byte[] hashCode;
    private long length;

    @Override
    public byte[] getHashCode() {
        if (this.hashCode == null) {
            log.warn("Extra calculating hashcode. This is in-efficient in most cases");
            this.computeHashcode();
        }
        return this.hashCode;
    }

    protected void computeHashcode() {
        try {
            StreamHelper.drain(this);
        }
        catch (IOException e) {
            log.error("Error extra computing hashcode", (Throwable)e);
        }
    }

    protected InputStream wrap(InputStream stream) {
        InputStream result = stream;
        if (!this.isHashcodeComputed()) {
            result = StreamHelper.wrapDigesting(this, result, this.getDigestAlgorithm());
        }
        if (this.getLength() == 0L) {
            result = StreamHelper.wrapCount(this, result);
        }
        return result;
    }

    @Override
    public boolean isHashcodeComputed() {
        return this.hashCode != null;
    }

    @Override
    public void setHashCode(byte[] digest) {
        this.hashCode = digest;
    }

    public boolean supportsMultipleReads() {
        return true;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public void setLength(long length) {
        this.length = length;
    }
}

