/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.input;

import de.kosit.validationtool.impl.input.AbstractInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.om.TreeInfo;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceInput
extends AbstractInput {
    private static final Logger log = LoggerFactory.getLogger(SourceInput.class);
    private final Source source;
    private final String name;
    private final String digestAlgorithm;

    public SourceInput(StreamSource source, String name, String digestAlgorithm) {
        this(source, name, digestAlgorithm, null);
    }

    public SourceInput(Source source, String name, String digestAlgorithm, byte[] hashCode) {
        this.source = source;
        this.name = name;
        this.digestAlgorithm = digestAlgorithm;
        this.setHashCode(hashCode);
        this.validate();
    }

    @Override
    public String getName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.name, (CharSequence)this.source.getClass().getSimpleName());
    }

    private void validate() {
        if (!this.isHashcodeComputed() && !this.isHashcodeComputationSupported()) {
            throw new IllegalStateException("Unsupported source. Only StreamSource supported yet");
        }
        if (!this.isHashcodeComputed() && ((StreamSource)this.source).getInputStream() == null) {
            log.warn("No hashcode supplied, will wrap the reader using system default charset");
        }
        if (!(this.isTreeInfo() || this.isDomSource() || this.isStreamSource() || this.isJaxbSource())) {
            log.warn("No known to be working Source implementation provided.");
        }
    }

    @Override
    public Source getSource() throws IOException {
        if (this.isConsumed()) {
            throw new IllegalStateException("A SourceInput can only read once");
        }
        return this.isHashcodeComputed() ? this.source : this.wrappedSource();
    }

    private boolean isHashcodeComputationSupported() {
        return this.isStreamSource();
    }

    private boolean isConsumed() throws IOException {
        if (this.isStreamSource()) {
            StreamSource ss = (StreamSource)this.source;
            try {
                return ss.getInputStream() != null && ss.getInputStream().available() == 0 || ss.getReader() != null && !ss.getReader().ready();
            }
            catch (IOException e) {
                log.error("Error checking consumed state", (Throwable)e);
                return true;
            }
        }
        return false;
    }

    private boolean isStreamSource() {
        return this.source instanceof StreamSource;
    }

    private boolean isDomSource() {
        return this.source instanceof DOMSource;
    }

    public boolean isTreeInfo() {
        return this.source instanceof TreeInfo;
    }

    private boolean isJaxbSource() {
        return this.source instanceof JAXBSource;
    }

    private Source wrappedSource() {
        Source result = this.source;
        if (this.isStreamSource()) {
            StreamSource ss = (StreamSource)this.source;
            if (ss.getInputStream() != null) {
                result = new StreamSource(this.wrap(ss.getInputStream()), this.source.getSystemId());
            } else if (ss.getReader() != null) {
                result = new StreamSource(this.wrap((InputStream)new ReaderInputStream(ss.getReader(), Charset.defaultCharset())), this.source.getSystemId());
            }
        }
        return result;
    }

    @Override
    public boolean supportsMultipleReads() {
        return this.isDomSource() || this.isTreeInfo();
    }

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }
}

