/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.tasks;

import de.kosit.validationtool.impl.CollectingErrorEventHandler;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.EngineInformation;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.tasks.CheckAction;
import de.kosit.validationtool.model.reportInput.XMLSyntaxError;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.s9api.BuildingContentHandler;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class CreateReportAction
implements CheckAction {
    private static final Logger log = LoggerFactory.getLogger(CreateReportAction.class);
    private static final String ERROR_MESSAGE_ELEMENT = "error-message";
    private final Processor processor;
    private final ConversionService conversionService;
    private final URIResolver resolver;
    private final UnparsedTextURIResolver unparsedTextURIResolver;

    private static XsltExecutable loadFromScenario(Scenario object) {
        return object.getReportTransformation().getExecutable();
    }

    @Override
    public void check(CheckAction.Bag results) {
        DocumentBuilder documentBuilder = this.processor.newDocumentBuilder();
        try {
            XdmNode parsedDocument = results.getParserResult().isValid() ? results.getParserResult().getObject() : this.createErrorInformation(results.getParserResult().getErrors());
            Marshaller marshaller = this.conversionService.getJaxbContext().createMarshaller();
            JAXBSource source = new JAXBSource(marshaller, (Object)results.getReportInput());
            source.setXMLReader((XMLReader)new ReaderWrapper(source.getXMLReader()));
            XdmNode root = documentBuilder.build((Source)source);
            XsltTransformer transformer = CreateReportAction.getTransformation(results).load();
            transformer.setInitialContextNode(root);
            CollectingErrorEventHandler e = new CollectingErrorEventHandler();
            transformer.setMessageListener((MessageListener)e);
            transformer.setURIResolver(this.resolver);
            if (this.unparsedTextURIResolver != null) {
                transformer.getUnderlyingController().setUnparsedTextURIResolver(this.unparsedTextURIResolver);
            }
            if (parsedDocument != null) {
                transformer.setParameter(new QName("input-document"), (XdmValue)parsedDocument);
            }
            XdmDestination destination = new XdmDestination();
            transformer.setDestination((Destination)destination);
            transformer.transform();
            results.setReport(destination.getXdmNode());
        }
        catch (JAXBException | SaxonApiException | SAXException e) {
            log.error("Error creating final report", e);
            results.stopProcessing("Can not create final report: " + e.getMessage());
        }
    }

    private XdmNode createErrorInformation(Collection<XMLSyntaxError> errors) throws SaxonApiException, SAXException {
        BuildingContentHandler contentHandler = this.processor.newDocumentBuilder().newBuildingContentHandler();
        contentHandler.startDocument();
        contentHandler.startElement(EngineInformation.getFrameworkNamespace(), ERROR_MESSAGE_ELEMENT, ERROR_MESSAGE_ELEMENT, (Attributes)new AttributesImpl());
        String message = errors.stream().map(XMLSyntaxError::getMessage).collect(Collectors.joining());
        contentHandler.characters(message.toCharArray(), 0, message.length());
        contentHandler.endElement(EngineInformation.getFrameworkNamespace(), ERROR_MESSAGE_ELEMENT, ERROR_MESSAGE_ELEMENT);
        return contentHandler.getDocumentNode();
    }

    private static XsltExecutable getTransformation(CheckAction.Bag results) {
        return CreateReportAction.loadFromScenario(results.getScenarioSelectionResult().getObject());
    }

    public CreateReportAction(Processor processor, ConversionService conversionService, URIResolver resolver, UnparsedTextURIResolver unparsedTextURIResolver) {
        this.processor = processor;
        this.conversionService = conversionService;
        this.resolver = resolver;
        this.unparsedTextURIResolver = unparsedTextURIResolver;
    }

    private static class ReaderWrapper
    implements XMLReader {
        private static final String SAX_FEATURES_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
        private static final String SAX_FEATURES_NAMESPACES = "http://xml.org/sax/features/namespaces";
        private final XMLReader delegate;

        public ReaderWrapper(XMLReader xmlReader) {
            this.delegate = xmlReader;
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (SAX_FEATURES_NAMESPACES.equals(name)) {
                return true;
            }
            if (SAX_FEATURES_NAMESPACE_PREFIXES.equals(name)) {
                return false;
            }
            return false;
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (name.equals(SAX_FEATURES_NAMESPACES) && !value) {
                throw new SAXNotRecognizedException(name);
            }
            if (name.equals(SAX_FEATURES_NAMESPACE_PREFIXES) && value) {
                throw new SAXNotRecognizedException(name);
            }
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.delegate.getProperty(name);
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.delegate.setProperty(name, value);
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            this.delegate.setEntityResolver(resolver);
        }

        @Override
        public EntityResolver getEntityResolver() {
            return this.delegate.getEntityResolver();
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
            this.delegate.setDTDHandler(handler);
        }

        @Override
        public DTDHandler getDTDHandler() {
            return this.delegate.getDTDHandler();
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.delegate.setContentHandler(handler);
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.delegate.getContentHandler();
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
            this.delegate.setErrorHandler(handler);
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.delegate.getErrorHandler();
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            this.delegate.parse(input);
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
            this.delegate.parse(systemId);
        }
    }
}

