/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.tasks;

import de.kosit.validationtool.api.Input;
import de.kosit.validationtool.impl.input.XdmNodeInput;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.impl.tasks.CheckAction;
import de.kosit.validationtool.model.reportInput.ValidationResultsWellformedness;
import de.kosit.validationtool.model.reportInput.XMLSyntaxError;
import de.kosit.validationtool.model.reportInput.XMLSyntaxErrorSeverity;
import java.io.IOException;
import java.util.Collections;
import java.util.stream.Collectors;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentParseAction
implements CheckAction {
    private static final Logger log = LoggerFactory.getLogger(DocumentParseAction.class);
    private final Processor processor;

    public Result<XdmNode, XMLSyntaxError> parseDocument(Input content) {
        Result<Object, XMLSyntaxError> result;
        if (content == null) {
            throw new IllegalArgumentException("Input may not be null");
        }
        try {
            if (content instanceof XdmNodeInput && this.hasCompatibleConfiguration((XdmNodeInput)content)) {
                result = new Result<XdmNode, XMLSyntaxError>(((XdmNodeInput)content).getNode());
            } else {
                DocumentBuilder builder = this.processor.newDocumentBuilder();
                builder.setLineNumbering(true);
                XdmNode doc = builder.build(content.getSource());
                result = new Result(doc, Collections.emptyList());
            }
        }
        catch (IOException | SaxonApiException e) {
            log.debug("Exception while parsing {}", (Object)content.getName(), (Object)e);
            XMLSyntaxError error = new XMLSyntaxError();
            error.setSeverityCode(XMLSyntaxErrorSeverity.SEVERITY_FATAL_ERROR);
            error.setMessage(String.format("IOException while reading resource %s: %s", content.getName(), e.getMessage()));
            result = new Result(Collections.singleton(error));
        }
        return result;
    }

    private boolean hasCompatibleConfiguration(XdmNodeInput content) {
        return content.getNode().getProcessor().getUnderlyingConfiguration().isCompatible(this.processor.getUnderlyingConfiguration());
    }

    @Override
    public void check(CheckAction.Bag results) {
        Result<XdmNode, XMLSyntaxError> parserResult = this.parseDocument(results.getInput());
        ValidationResultsWellformedness v = new ValidationResultsWellformedness();
        results.setParserResult(parserResult);
        v.getXmlSyntaxError().addAll(parserResult.getErrors());
        results.getReportInput().setValidationResultsWellformedness(v);
        if (parserResult.isInvalid()) {
            results.stopProcessing(parserResult.getErrors().stream().map(XMLSyntaxError::getMessage).collect(Collectors.toList()));
        }
    }

    public DocumentParseAction(Processor processor) {
        this.processor = processor;
    }
}

