/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.xml;

import de.kosit.validationtool.api.ResolvingConfigurationStrategy;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.saxon.s9api.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class BaseResolvingStrategy
implements ResolvingConfigurationStrategy {
    private static final Logger log = LoggerFactory.getLogger(BaseResolvingStrategy.class);
    protected static final String DISSALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";
    private static final String ORACLE_XERCES_CLASS = "com.sun.org.apache.xerces.internal.impl.Constants";
    private Processor processor;

    @Override
    public Processor getProcessor() {
        if (this.processor == null) {
            this.processor = this.createProcessor();
        }
        return this.processor;
    }

    protected abstract Processor createProcessor();

    public static void forceOpenJdkXmlImplementation() {
        if (!BaseResolvingStrategy.isOpenJdkXmlImplementationAvailable()) {
            throw new IllegalStateException("No OpenJDK version of XERCES found");
        }
    }

    public static boolean isOpenJdkXmlImplementationAvailable() {
        try {
            Class.forName(ORACLE_XERCES_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            log.warn("No oracle JDK version of XERCES found. Configured security features may not have any effect.");
            log.warn("Please take care of XML security while checking your xml contents");
            return false;
        }
    }

    private void setProperty(PropertySetter setter, boolean lenient, String errorMessage) {
        try {
            setter.apply();
        }
        catch (SAXException e) {
            if (lenient) {
                log.warn(errorMessage);
                log.debug(e.getMessage(), (Throwable)e);
            }
            throw new IllegalStateException(errorMessage);
        }
    }

    protected void allowExternalSchema(Validator validator, String ... scheme) {
        this.allowExternalSchema(validator, false, scheme);
    }

    protected void allowExternalSchema(SchemaFactory schemaFactory, String ... scheme) {
        this.allowExternalSchema(schemaFactory, false, scheme);
    }

    protected void allowExternalSchema(Validator validator, boolean lenient, String ... schemes) {
        String schemeString = String.join((CharSequence)",", schemes);
        this.setProperty(() -> validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", schemeString), lenient, String.format("Can set  external schema  access to schemes (%s). Maybe an unsupported JAXP implementation is used.", schemeString));
    }

    protected void allowExternalSchema(SchemaFactory schemaFactory, boolean lenient, String ... schemes) {
        String schemeString = String.join((CharSequence)",", schemes);
        this.setProperty(() -> schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", schemeString), lenient, String.format("Can set  external schema  access to schemes (%s). Maybe an unsupported JAXP implementation is used.", schemeString));
    }

    protected void disableExternalEntities(Validator validator) {
        this.disableExternalEntities(validator, false);
    }

    protected void disableExternalEntities(SchemaFactory schemaFactory) {
        this.disableExternalEntities(schemaFactory, false);
    }

    protected void disableExternalEntities(Validator validator, boolean lenient) {
        log.debug("Try to disable extern DTD access");
        this.setProperty(() -> validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", ""), lenient, "Can not disable external DTD access. Maybe an unsupported JAXP implementation is used.");
    }

    protected void disableExternalEntities(SchemaFactory schemaFactory, boolean lenient) {
        log.debug("Try to disable extern DTD access");
        this.setProperty(() -> schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", ""), lenient, "Can not disable external DTD access. Maybe an unsupported JAXP implementation is used.");
    }

    @FunctionalInterface
    private static interface PropertySetter {
        public void apply() throws SAXException;
    }
}

