/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl.xml;

import de.kosit.validationtool.impl.xml.BaseResolvingStrategy;
import de.kosit.validationtool.impl.xml.RelativeUriResolver;
import java.io.Reader;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.trans.XPathException;

public class StrictRelativeResolvingStrategy
extends BaseResolvingStrategy {
    private static final String EMPTY_SCHEME = "";

    @Override
    public SchemaFactory createSchemaFactory() {
        StrictRelativeResolvingStrategy.forceOpenJdkXmlImplementation();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.disableExternalEntities(sf);
        this.allowExternalSchema(sf, "file");
        return sf;
    }

    @Override
    protected Processor createProcessor() {
        Processor processor = new Processor(false);
        SecureUriResolver resolver = new SecureUriResolver();
        processor.getUnderlyingConfiguration().setCollectionFinder((CollectionFinder)resolver);
        processor.getUnderlyingConfiguration().setOutputURIResolver((OutputURIResolver)resolver);
        processor.getUnderlyingConfiguration().setUnparsedTextURIResolver((UnparsedTextURIResolver)resolver);
        processor.setConfigurationProperty(Feature.DTD_VALIDATION, (Object)false);
        processor.setConfigurationProperty(Feature.ENTITY_RESOLVER_CLASS, (Object)EMPTY_SCHEME);
        processor.setConfigurationProperty(Feature.XINCLUDE, (Object)false);
        processor.setConfigurationProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS, (Object)false);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/parserFeature?uri=" + StrictRelativeResolvingStrategy.encode("http://javax.xml.XMLConstants/feature/secure-processing"), (Object)true);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/parserFeature?uri=" + StrictRelativeResolvingStrategy.encode("http://apache.org/xml/features/disallow-doctype-decl"), (Object)true);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/parserFeature?uri=" + StrictRelativeResolvingStrategy.encode("http://apache.org/xml/features/nonvalidating/load-external-dtd"), (Object)false);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/parserFeature?uri=" + StrictRelativeResolvingStrategy.encode("http://javax.xml.XMLConstants/property/accessExternalDTD"), (Object)false);
        return processor;
    }

    private static String encode(String input) {
        return URLEncoder.encode(input, StandardCharsets.UTF_8.name());
    }

    @Override
    public URIResolver createResolver(URI repositoryURI) {
        return new RelativeUriResolver(repositoryURI);
    }

    @Override
    public UnparsedTextURIResolver createUnparsedTextURIResolver(URI scenarioRepository) {
        return new RelativeUriResolver(scenarioRepository);
    }

    @Override
    public Validator createValidator(Schema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("No schema supplied. Can not create validator");
        }
        StrictRelativeResolvingStrategy.forceOpenJdkXmlImplementation();
        Validator validator = schema.newValidator();
        this.disableExternalEntities(validator);
        this.allowExternalSchema(validator, "file");
        return validator;
    }

    private static class SecureUriResolver
    implements CollectionFinder,
    OutputURIResolver,
    UnparsedTextURIResolver {
        public static final String MESSAGE = "Configuration error. Resolving ist not allowed";

        private SecureUriResolver() {
        }

        public OutputURIResolver newInstance() {
            return this;
        }

        public Result resolve(String href, String base) throws TransformerException {
            throw new IllegalStateException(MESSAGE);
        }

        public void close(Result result) throws TransformerException {
            throw new IllegalStateException(MESSAGE);
        }

        public Reader resolve(URI absoluteURI, String encoding, Configuration config) throws XPathException {
            throw new IllegalStateException(MESSAGE);
        }

        public ResourceCollection findCollection(XPathContext context, String collectionURI) throws XPathException {
            throw new IllegalStateException(MESSAGE);
        }
    }
}

