/*
 * Decompiled with CFR 0.152.
 */
package javatools.administrative;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.administrative.Announce;
import javatools.administrative.D;
import javatools.database.Database;
import javatools.database.MySQLDatabase;
import javatools.database.OracleDatabase;
import javatools.database.PostgresDatabase;
import javatools.datatypes.FinalSet;
import javatools.filehandlers.FileLines;

public class NonsharedParameters
implements Cloneable {
    public File iniFile = null;
    public String basePath = null;
    public Map<String, String> values = null;
    public static Pattern INIPATTERN = Pattern.compile(" *(\\w+) *= *(.*) *");
    public static Pattern READTIMEVARIABLEPATTERN = Pattern.compile("(.*)\\$\\{(\\w+)\\}(.*)");
    public static Pattern RUNTIMVARIABLEPATTERN = Pattern.compile("(.*)\\$\\[(\\w+)\\](.*)");
    public static FinalSet<String> no = new FinalSet((Comparable[])new String[]{"inactive", "off", "false", "no", "none"});

    public NonsharedParameters() {
    }

    public NonsharedParameters(File iniFile) throws ParameterFileException {
        this.init(iniFile);
    }

    public NonsharedParameters(String iniFile) throws ParameterFileException {
        this.init(iniFile);
    }

    public NonsharedParameters(File iniFile, String localPath) throws ParameterFileException {
        if (localPath != null) {
            this.basePath = localPath.endsWith("/") ? localPath : localPath + "/";
        }
        this.init(iniFile);
    }

    public NonsharedParameters(String iniFile, String localPath) throws ParameterFileException {
        if (localPath != null) {
            this.basePath = localPath.endsWith("/") ? localPath : localPath + "/";
        }
        this.init(iniFile);
    }

    public NonsharedParameters(NonsharedParameters other) {
        this.basePath = other.basePath;
        this.iniFile = other.iniFile;
        for (Map.Entry<String, String> entry : other.values.entrySet()) {
            this.values.put(entry.getKey(), entry.getValue());
        }
    }

    public NonsharedParameters clone() {
        try {
            NonsharedParameters other = (NonsharedParameters)super.clone();
            other.values = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                other.values.put(entry.getKey(), entry.getValue());
            }
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Is too", e);
        }
    }

    public Timestamp getTimestamp(String s) throws UndefinedParameterException {
        return Timestamp.valueOf(this.get(s));
    }

    public Timestamp getTimestamp(String s, Timestamp defaultValue) throws UndefinedParameterException {
        return this.isDefined(s) ? this.getTimestamp(s) : defaultValue;
    }

    public String getPath(String s) throws UndefinedParameterException {
        if (this.basePath == null) {
            return this.get(s);
        }
        String path = this.get(s);
        if (path.startsWith("[CONFDIR]")) {
            return this.basePath + path.substring(9);
        }
        return path;
    }

    public String getPath(String s, String defaultValue) throws UndefinedParameterException {
        return this.isDefined(s) ? this.getPath(s) : defaultValue;
    }

    public File getFile(String s) throws UndefinedParameterException {
        return new File(this.getPath(s));
    }

    public File getFile(String s, File defaultValue) throws UndefinedParameterException {
        return this.isDefined(s) ? new File(this.getPath(s)) : defaultValue;
    }

    public URI getURI(String s) throws UndefinedParameterException, URISyntaxException {
        return new URI(this.get(s));
    }

    public URI getURI(String s, URI defaultValue) throws UndefinedParameterException, URISyntaxException {
        return this.isDefined(s) ? new URI(this.get(s)) : defaultValue;
    }

    public URL getURL(String s) throws UndefinedParameterException, MalformedURLException {
        return new URL(this.get(s));
    }

    public URL getURL(String s, URL defaultValue) throws UndefinedParameterException, MalformedURLException {
        return this.isDefined(s) ? new URL(this.get(s)) : defaultValue;
    }

    public Integer getInteger(String s) throws UndefinedParameterException {
        return Integer.parseInt(this.get(s));
    }

    public Integer getInteger(String s, Integer defaultValue) throws UndefinedParameterException {
        if (this.isDefined(s)) {
            return Integer.parseInt(this.get(s));
        }
        return defaultValue;
    }

    public int getInt(String s) throws UndefinedParameterException {
        return Integer.parseInt(this.get(s));
    }

    public int getInt(String s, int defaultValue) throws UndefinedParameterException {
        return this.isDefined(s) ? Integer.parseInt(this.get(s)) : defaultValue;
    }

    public Float getFloatObject(String s) throws UndefinedParameterException {
        return Float.valueOf(Float.parseFloat(this.get(s)));
    }

    public Float getFloatObject(String s, Float defaultValue) throws UndefinedParameterException {
        return Float.valueOf(this.isDefined(s) ? Float.parseFloat(this.get(s)) : defaultValue.floatValue());
    }

    public float getFloat(String s) throws UndefinedParameterException {
        return Float.parseFloat(this.get(s));
    }

    public float getFloat(String s, float defaultValue) throws UndefinedParameterException {
        return this.isDefined(s) ? Float.parseFloat(this.get(s)) : defaultValue;
    }

    public double getDouble(String s) throws UndefinedParameterException {
        return Double.parseDouble(this.get(s));
    }

    public Double getDouble(String s, Double defaultValue) throws UndefinedParameterException {
        return this.isDefined(s) ? Double.parseDouble(this.get(s)) : defaultValue;
    }

    public Boolean getBooleanObject(String s) throws UndefinedParameterException {
        String v = this.get(s);
        return !no.contains(v.toLowerCase());
    }

    public Boolean getBooleanObject(String s, Boolean defaultValue) {
        String v = this.get(s, defaultValue != false ? "yes" : "no");
        return !no.contains(v.toLowerCase());
    }

    public boolean getBoolean(String s) throws UndefinedParameterException {
        String v = this.get(s);
        return !no.contains(v.toLowerCase());
    }

    public boolean getBoolean(String s, boolean defaultValue) {
        String v = this.get(s, defaultValue ? "yes" : "no");
        return !no.contains(v.toLowerCase());
    }

    public List<String> getList(String s) throws UndefinedParameterException {
        if (!this.isDefined(s)) {
            return null;
        }
        return Arrays.asList(this.get(s).split("\\s*,\\s*"));
    }

    public Map<String, String> getMap(String s) throws UndefinedParameterException {
        if (!this.isDefined(s)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : this.get(s).split("\\s*,\\s*")) {
            String[] entrypair = entry.split("\\s*-->\\s*");
            if (entrypair.length < 2) {
                return null;
            }
            map.put(entrypair[0].toLowerCase(), entrypair[1]);
        }
        return map;
    }

    public String getMapEntry(String s, String key) throws UndefinedParameterException {
        if (!this.isDefined(s)) {
            return null;
        }
        for (String entry : this.get(s).split("\\s*,\\s*")) {
            String[] entrypair = entry.split("\\s*-->\\s*");
            if (entrypair.length < 2) {
                return null;
            }
            if (!entrypair[0].toLowerCase().equals(key.toLowerCase())) continue;
            return entrypair[1];
        }
        return null;
    }

    public String get(String s) throws UndefinedParameterException {
        if (this.values == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        String pname = s.indexOf(32) == -1 ? s : s.substring(0, s.indexOf(32));
        String v = this.values.get(pname.toLowerCase());
        if (v == null) {
            throw new UndefinedParameterException(s, this.iniFile);
        }
        Matcher m = RUNTIMVARIABLEPATTERN.matcher(v);
        if (m.matches()) {
            v = m.group(1) + this.get(m.group(2)) + m.group(3);
        }
        return v;
    }

    public String get(String s, String defaultValue) {
        if (this.values == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        String pname = s.indexOf(32) == -1 ? s : s.substring(0, s.indexOf(32));
        String v = this.values.get(pname.toLowerCase());
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public String getOrRequest(String s, String description) {
        if (this.values == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        String v = this.values.get(s.toLowerCase());
        if (v == null) {
            D.println(description);
            v = D.read();
        }
        return v;
    }

    public String getOrRequestAndAdd(String s, String description) throws IOException {
        String v = this.getOrRequest(s, description);
        this.add(s, v);
        return v;
    }

    public boolean getOrRequestAndAddBoolean(String s, String description) throws IOException {
        boolean v = this.getOrRequestBoolean(s, description);
        this.add(s, v ? "yes" : "no");
        return v;
    }

    public File getOrRequestFileParameter(String s, String description) {
        String fn;
        File f;
        while (!(f = new File(fn = this.getOrRequest(s, description))).exists()) {
            D.println("File not found", fn);
            this.remove(s);
        }
        return f;
    }

    public boolean getOrRequestBoolean(String s, String description) {
        String fn;
        do {
            if (!(fn = this.getOrRequest(s, description).toLowerCase()).equals("true") && !fn.equals("yes")) continue;
            return true;
        } while (!fn.equals("false") && !fn.equals("no"));
        return false;
    }

    public int getOrRequestInteger(String s, String description) {
        while (true) {
            String fn = this.getOrRequest(s, description);
            try {
                return Integer.parseInt(fn);
            }
            catch (Exception exception) {
                this.remove(s);
                continue;
            }
            break;
        }
    }

    public void add(String key, String value) throws IOException {
        if (this.values == null || this.iniFile == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        if (this.values.containsKey(key.toLowerCase())) {
            return;
        }
        this.values.put(key.toLowerCase(), value);
        FileWriter w = new FileWriter(this.iniFile, true);
        w.write(key + " = " + value + "\n");
        ((Writer)w).close();
    }

    public String remove(String parameter) {
        return this.values.remove(parameter.toLowerCase());
    }

    public void set(String param, String value) {
        if (this.values == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        this.values.put(param.toLowerCase(), value);
    }

    public void init(File f) throws ParameterFileException {
        this.init(f, true);
    }

    public void init(File f, boolean mainIni) throws ParameterFileException {
        if (f.equals(this.iniFile)) {
            return;
        }
        if (mainIni) {
            this.values = new TreeMap<String, String>();
            this.iniFile = f;
            if (this.basePath == null) {
                this.basePath = f.getParent() != null ? f.getParent() + "/" : "";
            }
        }
        try {
            if (!this.iniFile.exists()) {
                Announce.error("The initialisation file", this.iniFile.getCanonicalPath(), "was not found.");
            }
            String lastAttrib = null;
            for (String l : new FileLines(f)) {
                Matcher m = READTIMEVARIABLEPATTERN.matcher(l);
                if (m.matches()) {
                    l = m.group(1) + this.values.get(m.group(2)) + m.group(3);
                }
                if (!(m = INIPATTERN.matcher(l)).matches()) {
                    if (lastAttrib == null) continue;
                    this.values.put(lastAttrib, this.values.get(lastAttrib) + l);
                    if (l.trim().endsWith(",")) continue;
                    lastAttrib = null;
                    continue;
                }
                String s = m.group(2).trim();
                if (s.startsWith("\"")) {
                    s = s.substring(1);
                }
                if (s.endsWith("\"")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (m.group(1).toLowerCase().equals("include")) {
                    if (s.startsWith("/")) {
                        this.init(s, false);
                        continue;
                    }
                    this.init((f.getParent() != null ? f.getParent() + "/" : "") + s, false);
                    continue;
                }
                this.values.put(m.group(1).toLowerCase(), s);
                if (s.trim().endsWith(",")) {
                    lastAttrib = m.group(1).toLowerCase();
                    continue;
                }
                lastAttrib = null;
            }
        }
        catch (IOException ex) {
            throw new ParameterFileException("Problem when reading '" + this.iniFile.getPath() + "'", ex);
        }
    }

    public void init(String filename, File ... folders) throws ParameterFileException {
        boolean found = false;
        for (File folder : folders) {
            if (!new File(folder, filename).exists()) continue;
            if (found) {
                throw new ParameterFileException("INI-file " + filename + "occurs twice in given folders");
            }
            this.init(new File(folder, filename));
            found = true;
        }
    }

    public void init(String filename) throws ParameterFileException {
        this.init(filename, true);
    }

    public void init(String file, boolean mainIni) throws ParameterFileException {
        Announce.message("Loading ini file '" + file + "'");
        this.init(new File(file), mainIni);
    }

    public boolean isDefined(String s) {
        if (this.values == null) {
            throw new RuntimeException("Call init() before get()!");
        }
        String pname = s.indexOf(32) == -1 ? s : s.substring(0, s.indexOf(32));
        return this.values.containsKey(pname.toLowerCase());
    }

    public void ensureParameters(String ... p) {
        if (this.values == null) {
            throw new RuntimeException("Call init() before ensureParameters()!");
        }
        boolean OK = true;
        StringBuilder b = new StringBuilder("The following parameters are undefined in ").append(this.iniFile);
        for (String s : p) {
            if (this.isDefined(s)) continue;
            b.append("\n       ").append(s);
            OK = false;
        }
        if (OK) {
            return;
        }
        Announce.error(b.toString());
    }

    public boolean getBooleanArgument(String[] args, String ... argnames) {
        Matcher m;
        String arg = " ";
        for (String s : args) {
            arg = arg + s + ' ';
        }
        String p = "\\W(";
        for (String s : argnames) {
            p = p + s + '|';
        }
        if (p.endsWith("|")) {
            p = p.substring(0, p.length() - 1);
        }
        if (!(m = Pattern.compile(p = p + ")\\W").matcher(arg)).find()) {
            return false;
        }
        String next = arg.substring(m.end()).toLowerCase();
        if (next.indexOf(32) != -1) {
            next = next.substring(0, next.indexOf(32));
        }
        if (next.equals("off")) {
            return false;
        }
        if (next.equals("0")) {
            return false;
        }
        if (next.equals("false")) {
            return false;
        }
        String previous = arg.substring(0, m.start()).toLowerCase();
        if (previous.indexOf(32) != -1) {
            previous = previous.substring(previous.lastIndexOf(32) + 1);
        }
        return !previous.equals("no");
    }

    public void reset() {
        this.iniFile = null;
        this.values = null;
    }

    public Database getDatabase() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.ensureParameters("databaseSystem - either Oracle, Postgres or MySQL", "databaseUser - the user name for the database (also: databaseDatabase, databaseInst,databasePort,databaseHost,databaseSchema)", "databasePassword - the password for the database");
        String system = this.get("databaseSystem").toUpperCase();
        String user = this.get("databaseUser");
        String password = this.get("databasePassword");
        String host = null;
        String schema = null;
        String inst = null;
        String port = null;
        String database = null;
        Integer fetchsize = this.getInteger("databaseFetchSize", null);
        try {
            host = this.get("databaseHost");
        }
        catch (Exception e) {
            Announce.debug("Warning: " + e);
        }
        try {
            schema = this.get("databaseSchema");
        }
        catch (Exception e) {
            Announce.debug("Warning: " + e);
        }
        try {
            port = this.get("databasePort");
        }
        catch (Exception e) {
            Announce.debug("Warning: " + e);
        }
        if (system.equals("ORACLE")) {
            try {
                inst = this.get("databaseSID");
            }
            catch (UndefinedParameterException e) {
                Announce.debug("Warning: " + e);
            }
        }
        try {
            database = this.get("databaseDatabase");
        }
        catch (UndefinedParameterException e) {
            Announce.debug("Warning: " + e);
        }
        Database db = null;
        if (system.equals("ORACLE")) {
            db = new OracleDatabase(user, password, host, port, inst);
        }
        if (system.equals("MYSQL")) {
            db = new MySQLDatabase(user, password, database, host, port);
        }
        if (system.equals("POSTGRES")) {
            db = new PostgresDatabase(user, password, database, host, port, schema);
        }
        if (db == null) {
            throw new RuntimeException("Unsupported database system " + system);
        }
        if (fetchsize != null) {
            db.setFetchsize(fetchsize);
        }
        return db;
    }

    @Deprecated
    public Object matchObjectAttribut(Field field) throws IllegalAccessException {
        String parameterName;
        String string = parameterName = field.getName().startsWith("cp_") ? field.getName().substring(2) : field.getName();
        if ((parameterName.equals(parameterName.toUpperCase()) || field.getName().startsWith("cp_")) && this.isDefined(parameterName)) {
            if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                return this.getInteger(parameterName);
            }
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                return new Boolean(this.getBoolean(parameterName));
            }
            if (field.getType() == Float.class || field.getType() == Float.TYPE) {
                return new Float(this.getFloat(parameterName));
            }
            if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                return new Double(this.getDouble(parameterName));
            }
            if (D.indexOf(List.class, field.getType().getInterfaces()) != -1) {
                return this.getList(parameterName);
            }
            if (D.indexOf(List.class, field.getType()) != -1) {
                return this.getList(parameterName);
            }
            return this.get(parameterName);
        }
        return null;
    }

    public void initiateClassAttributes(String className, Object object) {
        try {
            Class<?> cl = Class.forName(className);
            for (Field field : cl.getDeclaredFields()) {
                field.setAccessible(true);
                Object value = this.matchObjectAttribut(field);
                if (value != null) {
                    field.set(this, value);
                }
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void initiateAllClassAttributes(Object object) {
        try {
            for (Class<?> cl = object.getClass(); cl != null; cl = cl.getSuperclass()) {
                for (Field field : cl.getDeclaredFields()) {
                    field.setAccessible(true);
                    Object value = this.matchObjectAttribut(field);
                    if (value != null) {
                        field.set(object, value);
                    }
                    field.setAccessible(false);
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void initiateClassAttributes(Object object) {
        try {
            Class<?> cl = object.getClass();
            for (Field field : cl.getDeclaredFields()) {
                field.setAccessible(true);
                Object value = this.matchObjectAttribut(field);
                if (value != null) {
                    field.set(object, value);
                }
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Set<String> parameters() {
        return this.values.keySet();
    }

    public void saveAs(String file) throws ParameterFileException {
        try {
            FileWriter w = new FileWriter(file, false);
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                w.write(entry.getKey() + " = " + entry.getValue() + "\n");
            }
            ((Writer)w).close();
        }
        catch (IOException ex) {
            throw new ParameterFileException("Problem when writing to '" + this.iniFile.getPath() + "'", ex);
        }
    }

    public static void main(String[] args) throws Exception {
        NonsharedParameters params = new NonsharedParameters();
        params.init("testdata/testconfig.ini");
        D.p(params.values);
        params.set("someSetting", "1");
        NonsharedParameters params2 = params.clone();
        params2.set("someSetting", "2");
        D.p(params.values);
        D.p(params2.values);
    }

    public static class ParameterFileException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ParameterFileException() {
        }

        public ParameterFileException(String message) {
            super(message);
        }

        public ParameterFileException(Throwable cause) {
            super(cause);
        }

        public ParameterFileException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class UndefinedParameterException
    extends RuntimeException {
        private static final long serialVersionUID = -7648653481162390257L;

        public UndefinedParameterException(String s, File f) {
            super("The parameter " + s + " is undefined in " + f);
        }
    }
}

