/*
 * Decompiled with CFR 0.152.
 */
package javatools.database;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.administrative.Announce;
import javatools.database.Database;
import javatools.database.OracleDatabase;
import javatools.database.ResultIterator;
import javatools.database.SQLType;
import javatools.filehandlers.FileLines;

public class DBWordNet {
    protected Database database;

    public DBWordNet(Database db) {
        this.database = db;
    }

    public static void construct(Database db, File wordNetFolder) throws SQLException, IOException {
        for (Table t : Table.values()) {
            t.load(db, wordNetFolder);
        }
    }

    public List<Integer> targetSynsets(Table relation, int source) throws SQLException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer i : this.database.query("SELECT to_ss FROM wn_" + (Object)((Object)relation) + " WHERE from_ss=" + this.database.getSQLType(Integer.class).format(source), ResultIterator.IntegerWrapper)) {
            result.add(i);
        }
        return result;
    }

    public List<Integer> synsetsFor(String word) throws SQLException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer i : this.database.query("SELECT synset_id FROM wn_synsets WHERE word=" + this.database.getSQLType(String.class).format(word), ResultIterator.IntegerWrapper)) {
            result.add(i);
        }
        return result;
    }

    public List<String> wordsFor(int synset) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.database.query("SELECT word FROM wn_synsets WHERE synset_id=" + this.database.getSQLType(String.class).format(synset), ResultIterator.StringWrapper)) {
            result.add(s);
        }
        return result;
    }

    public String glossFor(int synset) throws SQLException {
        return this.database.queryValue("SELECT gloss FROM wn_glosses WHERE synset_id=" + this.database.getSQLType(Integer.class).format(synset), ResultIterator.StringWrapper);
    }

    public static void main(String[] args) throws Exception {
        Table.VERBROUP.load(new OracleDatabase("yago", "yago"), new File("C:\\program files\\wordnet\\2.1\\prolog"));
    }

    public Database getDatabase() {
        return this.database;
    }

    public static enum Table {
        SYNSETS("wn_s.pl", "synset_id", 4, "w_num", 4, "word", 12, "ss_type", 1, "sense_number", 4, "tag_count", 4),
        GLOSSES("wn_g.pl", "synset_id", 4, "gloss", 12),
        HYPONYMY("wn_hyp.pl", "from_ss", 4, "to_ss", 4),
        ENTAILMENT("wn_ent.pl", "from_ss", 4, "to_ss", 4),
        SIMILARITY("wn_sim.pl", "from_ss", 4, "to_ss", 4),
        MEREONYMY_M("wn_mm.pl", "from_ss", 4, "to_ss", 4),
        MEREONYMY_S("wn_ms.pl", "from_ss", 4, "to_ss", 4),
        MEREONYMY_P("wn_mp.pl", "from_ss", 4, "to_ss", 4),
        MORPH("wn_der.pl", "from_ss", 4, "to_ss", 4),
        CLASS("wn_cls.pl", "from_ss", 4, "to_ss", 4, "class_type", 1),
        ANTONYMY("wn_ant.pl", "from_synset", 4, "from_wnum", 4, "to_synset", 4, "to_wnum", 4),
        SEEALSO("wn_sa.pl", "from_synset", 4, "from_wnum", 4, "to_synset", 4, "to_wnum", 4),
        PARTICIPLE("wn_ppl.pl", "from_synset", 4, "from_wnum", 4, "to_synset", 4, "to_wnum", 4),
        PERTAIN("wn_per.pl", "from_synset", 4, "from_wnum", 4, "to_synset", 4, "to_wnum", 4),
        CAUSE("wn_cs.pl", "from_ss", 4, "to_ss", 4),
        VERBROUP("wn_vgp.pl", "from_ss", 4, "null1", 4, "to_ss", 4, "null2", 4),
        ATTRIBUTE("wn_at.pl", "from_ss", 4, "to_ss", 4),
        FRAME("wn_fr.pl", "synset", 4, "frame", 4, "wnum", 4);

        protected String file;
        protected Object[] attributes;

        private Table(String file, Object ... attributes) {
            this.file = file;
            this.attributes = attributes;
        }

        public Object[] getAttributes() {
            return this.attributes;
        }

        public String getFile() {
            return this.file;
        }

        public void load(Database db, File wordNetFolder) throws IOException, SQLException {
            String relation = "WN_" + this.name();
            db.createTable(relation, this.attributes);
            StringBuilder b = new StringBuilder("\\w*\\(");
            SQLType[] types = new SQLType[this.attributes.length / 2];
            block5: for (int i = 0; i < types.length; ++i) {
                int type = (Integer)this.attributes[i * 2 + 1];
                types[i] = db.getSQLType(type);
                switch (type) {
                    case 4: {
                        b.append("(\\d+),");
                        continue block5;
                    }
                    case 12: {
                        b.append("'([^']*)',");
                        continue block5;
                    }
                    case 1: {
                        b.append("(.),");
                        continue block5;
                    }
                    default: {
                        b.append("([^,]*),");
                    }
                }
            }
            b.setLength(b.length() - 1);
            b.append("\\).");
            Pattern pattern = Pattern.compile(b.toString());
            b = new StringBuilder("INSERT INTO " + relation + " VALUES (");
            int chopoff = b.length();
            for (String l : new FileLines(new File(wordNetFolder, this.file), "Loading " + relation)) {
                Matcher m = pattern.matcher(l.replace("''", "`"));
                if (!m.matches()) {
                    Announce.warning("No match for", l);
                    continue;
                }
                b.setLength(chopoff);
                for (int i = 0; i < types.length; ++i) {
                    b.append(types[i].format(m.group(i + 1))).append(", ");
                }
                b.setLength(b.length() - 2);
                b.append(")");
                db.query(b.toString());
            }
        }
    }
}

