/*
 * Decompiled with CFR 0.152.
 */
package javatools.database;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import javatools.database.Database;
import javatools.database.SQLType;

public class MySQLDatabase
extends Database {
    private String user = null;
    private String password = null;
    private String database = null;
    private String host = null;
    private String port = null;
    public static MysqlVarchar mysqlvarchar = new MysqlVarchar();
    public static Blob blob = new Blob();
    public static ANSIvarcharBin ansivarcharbin = new ANSIvarcharBin();

    public MySQLDatabase(String user, String password, String database, String host, String port) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Driver driver = (Driver)Class.forName("com.mysql.jdbc.Driver").newInstance();
        DriverManager.registerDriver(driver);
        if (host == null || host.length() == 0) {
            host = "localhost";
        }
        if (database == null) {
            database = "";
        }
        port = port == null ? "" : ":" + port;
        this.user = user;
        this.password = password;
        this.database = database;
        this.host = host;
        this.port = port;
        this.connect();
        this.type2SQL.put(7, SQLType.ansifloat);
        this.type2SQL.put(2004, blob);
        this.type2SQL.put(-4, blob);
        this.enforceCaseSensitivity(false);
    }

    public MySQLDatabase() {
    }

    public void enforceCaseSensitivity(boolean enable) {
        if (enable) {
            this.java2SQL.put(String.class, ansivarcharbin);
            this.type2SQL.put(12, ansivarcharbin);
        } else {
            this.java2SQL.put(String.class, mysqlvarchar);
            this.type2SQL.put(12, mysqlvarchar);
        }
    }

    @Override
    public void connect() throws SQLException {
        this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + this.port + "/" + this.database + "?user=" + this.user + "&password=" + this.password);
        this.connection.setAutoCommit(true);
        this.description = "MySQL database for " + this.user + " at " + this.host + ":" + this.port + ", database " + this.database;
    }

    @Override
    public boolean jarAvailable() {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void lockTableWriteAccess(Map<String, String> tablesAndAliases) throws SQLException {
        StringBuilder sql = new StringBuilder("LOCK TABLES ");
        Iterator<String> it = tablesAndAliases.keySet().iterator();
        while (it.hasNext()) {
            String table = it.next();
            sql.append(table).append(" ");
            if (tablesAndAliases.get(table) != null) {
                sql.append("AS ").append(tablesAndAliases.get(table));
            }
            sql.append(" WRITE");
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        this.connection.createStatement().executeUpdate(sql.toString());
    }

    @Override
    public void lockTableReadAccess(Map<String, String> tablesAndAliases) throws SQLException {
        StringBuilder sql = new StringBuilder("LOCK TABLES ");
        Iterator<String> it = tablesAndAliases.keySet().iterator();
        while (it.hasNext()) {
            String table = it.next();
            sql.append(table).append(" ");
            if (tablesAndAliases.get(table) != null) {
                sql.append("AS ").append(tablesAndAliases.get(table));
            }
            sql.append(" WRITE");
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        this.connection.createStatement().executeUpdate(sql.toString());
    }

    @Override
    public void releaseLocksAndEndTransaction() throws SQLException {
        this.connection.createStatement().executeUpdate("UNLOCK TABLES");
        this.endTransaction(true);
    }

    @Override
    public String getSQLStmntIFNULL(String a, String b) {
        return "IFNULL(" + a + "," + b + ")";
    }

    @Override
    public String cast(String value, String type) {
        if (type.equals("INTEGER")) {
            type = "UNSIGNED";
        } else if (type.equals("VARCHAR")) {
            type = "CHAR";
        }
        StringBuilder sql = new StringBuilder("CAST(");
        sql.append(value).append(" AS ").append(type).append(")");
        return sql.toString();
    }

    @Override
    public String autoincrementColumn() {
        return "int AUTO_INCREMENT";
    }

    public static void main(String[] args) throws Exception {
    }

    public static class ANSIvarcharBin
    extends SQLType {
        public ANSIvarcharBin(int size) {
            this.typeCode = 12;
            this.scale = size;
        }

        public ANSIvarcharBin() {
            this(255);
        }

        @Override
        public String format(Object o) {
            String s = o.toString().replace("'", "\\'");
            if (s.length() > this.scale) {
                s = s.substring(0, this.scale);
            }
            return "BINARY '" + s + "'";
        }

        public String toString() {
            return "VARCHAR(" + this.scale + ") BINARY";
        }
    }

    public static class Blob
    extends SQLType.ANSIblob {
        public Blob(int size) {
            super(size);
        }

        public Blob() {
        }

        @Override
        public String toString() {
            return "BLOB";
        }

        @Override
        public String format(Object o) {
            String s = o.toString().replace("\\", "\\\\").replace("'", "\\'");
            return "'" + s + "'";
        }
    }

    public static class MysqlVarchar
    extends SQLType.ANSIvarchar {
        public MysqlVarchar(int size) {
            super(size);
        }

        public MysqlVarchar() {
            this(255);
        }

        @Override
        public String format(Object o) {
            String s = o.toString().replace("\\", "\\\\").replace("'", "''");
            if (s.length() > this.scale && (s = s.substring(0, this.scale)).endsWith("'") && !s.endsWith("''")) {
                s = s.substring(0, s.length() - 1);
            }
            return "'" + s + "'";
        }
    }
}

