/*
 * Decompiled with CFR 0.152.
 */
package javatools.database;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.database.Database;
import javatools.database.SQLType;

public class OracleDatabase
extends Database {
    protected String connectionString;
    public static Varchar varchar = new Varchar();
    public static Bool bool = new Bool();
    public static Bigint bigint = new Bigint();

    @Override
    protected String prepareQuery(String sql) {
        if (sql.endsWith(";")) {
            return sql.substring(0, sql.length() - 1);
        }
        return sql;
    }

    public OracleDatabase() {
        this.java2SQL.put(Boolean.class, bool);
        this.java2SQL.put(Boolean.TYPE, bool);
        this.java2SQL.put(String.class, varchar);
        this.java2SQL.put(Long.class, bigint);
        this.java2SQL.put(Long.TYPE, bigint);
        this.type2SQL.put(12, varchar);
        this.type2SQL.put(16, bool);
        this.type2SQL.put(-5, bigint);
    }

    public OracleDatabase(String user, String password, String host) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this(user, password, host, null);
    }

    public OracleDatabase(String user, String password, String host, String port) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this(user, password, host, null, null);
    }

    public OracleDatabase(String user, String password, String host, String port, String inst) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this();
        if (password == null) {
            password = "";
        }
        if (host == null || host.length() == 0) {
            host = "localhost";
        }
        if (port == null || port.length() == 0) {
            port = "1521";
        }
        if (inst == null || inst.length() == 0) {
            inst = "oracle";
        }
        this.connectionString = "jdbc:oracle:thin:" + user + "/" + password + "@" + host + ":" + port + ":" + inst;
        Driver driver = (Driver)Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
        DriverManager.registerDriver(driver);
        this.connect();
        this.description = "ORACLE database " + user + "/" + password + " at " + host + ":" + port + " instance " + inst;
    }

    public OracleDatabase(String user, String password) throws Exception {
        this(user, password, "localhost");
    }

    @Deprecated
    public void resetConnection() throws SQLException {
        OracleDatabase.close(this.connection);
        this.connect();
    }

    @Override
    public void connect() throws SQLException {
        this.connection = DriverManager.getConnection(this.connectionString);
        this.connection.setAutoCommit(true);
    }

    @Override
    public String limit(String sql, int n) {
        ++n;
        Matcher m = Pattern.compile(" where", 2).matcher(sql);
        if (!m.find()) {
            return sql + " WHERE ROWNUM<" + n;
        }
        return sql.substring(0, m.end()) + " ROWNUM<" + n + " AND " + sql.substring(m.end());
    }

    @Override
    public boolean jarAvailable() {
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean connected() {
        try {
            return !this.connection.isClosed() && this.connection.isValid(this.validityCheckTimeout);
        }
        catch (SQLFeatureNotSupportedException nosupport) {
            try {
                ResultSet rs = this.query("SELECT 1 FROM DUAL", this.resultSetType, this.resultSetConcurrency, null);
                OracleDatabase.close(rs);
                return true;
            }
            catch (SQLException ex) {
                return false;
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("This is very unexpected and actually should never happen.", ex);
        }
    }

    public static void main(String[] args) {
        OracleDatabase database = new OracleDatabase();
        String sql = "SELECT arg2 FROM facts WHERE relation=something AND arg1= something";
        System.out.println(database.limit(sql, 7));
    }

    public static class Bigint
    extends SQLType.ANSIBigint {
        @Override
        public String toString() {
            return "NUMBER(37)";
        }
    }

    public static class Bool
    extends SQLType.ANSIboolean {
        public Bool() {
            this.typeCode = 4;
        }

        @Override
        public String format(Object o) {
            if (super.format(o).equals("true")) {
                return "1";
            }
            return "0";
        }

        @Override
        public String toString() {
            return "NUMBER(1)";
        }
    }

    public static class Varchar
    extends SQLType.ANSIvarchar {
        public Varchar(int size) {
            super(size);
        }

        public Varchar() {
        }

        @Override
        public String toString() {
            return "VARCHAR2(" + this.scale + ")";
        }

        @Override
        public String format(Object o) {
            String s = o.toString().replace("'", "''");
            if (s.length() > this.scale) {
                s = s.substring(0, this.scale);
            }
            return "'" + s + "'";
        }
    }
}

