/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.Arrays;
import java.util.WeakHashMap;
import javatools.administrative.D;

public class ByteString
implements CharSequence {
    protected static WeakHashMap<ByteString, ByteString> values = new WeakHashMap();
    public byte[] data;
    protected int hashCode;
    public boolean isInterned = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteString of(CharSequence s) {
        ByteString newOne = new ByteString(s);
        WeakHashMap<ByteString, ByteString> weakHashMap = values;
        synchronized (weakHashMap) {
            ByteString canonic = values.get(newOne);
            if (canonic != null) {
                return canonic;
            }
            values.put(newOne, newOne);
            newOne.isInterned = true;
        }
        return newOne;
    }

    protected ByteString(ByteString s, int start, int end) {
        this.data = Arrays.copyOfRange(s.data, start, end);
        this.hashCode = Arrays.hashCode(this.data);
    }

    protected ByteString(CharSequence s) {
        this.data = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            this.data[i] = (byte)(s.charAt(i) - 128);
        }
        this.hashCode = Arrays.hashCode(this.data);
    }

    @Override
    public char charAt(int arg0) {
        return (char)(this.data[arg0] + 128);
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public CharSequence subSequence(int arg0, int arg1) {
        return new ByteString(this, arg0, arg1);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteString)) {
            return false;
        }
        ByteString other = (ByteString)obj;
        if (this.isInterned && other.isInterned) {
            return this == other;
        }
        return Arrays.equals(other.data, this.data);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            b.append(this.charAt(i));
        }
        return b.toString();
    }

    public static void main(String[] args) throws Exception {
        D.p(new ByteString("Hallo d\ufffd!"));
    }
}

