/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import javatools.datatypes.CombinedIterator;

public class CombinedIterable<T>
implements Iterable<T>,
Closeable {
    private Queue<Iterable<? extends T>> iterables = new LinkedList<Iterable<? extends T>>();

    public CombinedIterable() {
    }

    public CombinedIterable(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        this.iterables.offer(i1);
        this.iterables.offer(i2);
    }

    public CombinedIterable(Iterable<? extends T> i1) {
        this.iterables.offer(i1);
    }

    public CombinedIterable(Iterable<? extends T> i1, Iterable<? extends T> i2, Iterable<? extends T> i3) {
        this.iterables.offer(i1);
        this.iterables.offer(i2);
        this.iterables.offer(i3);
    }

    public CombinedIterable(T i) {
        this(Arrays.asList(i));
    }

    public CombinedIterable(Iterable<? extends T> ... its) {
        for (Iterable<? extends T> i : its) {
            this.iterables.offer(i);
        }
    }

    public CombinedIterable<T> add(Iterable<? extends T> i) {
        this.iterables.offer(i);
        return this;
    }

    public CombinedIterable<T> add(T i) {
        return this.add((T)Arrays.asList(i));
    }

    @Override
    public Iterator<T> iterator() {
        return new CombinedIterator<T>(this.iterables);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[");
        for (T t : this) {
            b.append(t).append(", ");
        }
        if (b.length() > 2) {
            b.setLength(b.length() - 2);
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public void close() throws IOException {
        for (Iterable iterable : this.iterables) {
            if (!(iterable instanceof Closeable)) continue;
            ((Closeable)((Object)iterable)).close();
        }
        this.iterables.clear();
    }
}

