/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class CombinedIterator<T>
implements Iterator<T>,
Iterable<T>,
Closeable {
    private Queue<Iterator<? extends T>> iterators = new LinkedList<Iterator<? extends T>>();

    public CombinedIterator() {
    }

    public CombinedIterator(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        this.iterators.offer(i1);
        this.iterators.offer(i2);
    }

    public CombinedIterator(Iterator<? extends T> i1) {
        this.iterators.offer(i1);
    }

    public CombinedIterator(Iterator<? extends T> i1, Iterator<? extends T> i2, Iterator<? extends T> i3) {
        this.iterators.offer(i1);
        this.iterators.offer(i2);
        this.iterators.offer(i3);
    }

    public CombinedIterator(Iterable<? extends T> i) {
        this(i.iterator());
    }

    public CombinedIterator(T i) {
        this(Arrays.asList(i));
    }

    public CombinedIterator(Iterator<? extends T> ... its) {
        for (Iterator<? extends T> i : its) {
            this.iterators.offer(i);
        }
    }

    public CombinedIterator(Collection<Iterable<? extends T>> its) {
        for (Iterable<T> i : its) {
            this.iterators.offer(i.iterator());
        }
    }

    public CombinedIterator<T> add(Iterator<? extends T> i) {
        this.iterators.offer(i);
        return this;
    }

    public CombinedIterator<T> add(T i) {
        return this.add((Iterable<? extends T>)Arrays.asList(i));
    }

    public CombinedIterator<T> add(Iterable<? extends T> i) {
        this.iterators.offer(i.iterator());
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.iterators.peek() == null) {
            return false;
        }
        if (this.iterators.peek().hasNext()) {
            return true;
        }
        if (this.iterators.peek() instanceof Closeable) {
            try {
                ((Closeable)((Object)this.iterators.peek())).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.iterators.remove();
        return this.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            return null;
        }
        return this.iterators.peek().next();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public void remove() {
        this.iterators.peek().remove();
    }

    @Override
    public void close() {
        while (!this.iterators.isEmpty()) {
            Iterator<? extends T> i = this.iterators.poll();
            if (!(i instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)i)).close();
            }
            catch (Exception exception) {}
        }
    }
}

