/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.filehandlers.FileLines;

public class DirectedGraph<E extends Comparable<E>> {
    protected Map<E, Node<E>> nodes = new TreeMap<E, Node<E>>();

    public void addLink(E parent, E child) {
        this.getOrMake(parent).addChild(this.getOrMake(child));
    }

    public Node<E> getOrMake(E label) {
        if (!this.nodes.containsKey(label)) {
            this.nodes.put(label, new Node<E>(label, true));
        }
        return this.nodes.get(label);
    }

    public static DirectedGraph<String> create(File file, Pattern pattern) throws IOException {
        DirectedGraph<String> result = new DirectedGraph<String>();
        for (String line : new FileLines(file, "Loading graph")) {
            Matcher m = pattern.matcher(line);
            if (!m.find()) continue;
            result.addLink(m.group(2), m.group(1));
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Node<E> n : this.nodes()) {
            result.append(n.label).append(" -> ").append(n.children).append('\n');
        }
        return result.toString();
    }

    public SortedSet<Node<E>> roots() {
        TreeSet<Node<Node<E>>> result = new TreeSet<Node<Node<E>>>();
        for (Node<E> n : this.nodes.values()) {
            if (n.parents.size() != 0) continue;
            result.add(n);
        }
        return result;
    }

    public SortedSet<Node<E>> leaves() {
        TreeSet<Node<Node<E>>> result = new TreeSet<Node<Node<E>>>();
        for (Node<E> n : this.nodes.values()) {
            if (n.children.size() != 0) continue;
            result.add(n);
        }
        return result;
    }

    public Collection<Node<E>> nodes() {
        return this.nodes.values();
    }

    public int numNodes() {
        return this.nodes.size();
    }

    public Collection<E> labels() {
        TreeSet result = new TreeSet();
        for (Node<E> n : this.nodes()) {
            result.add(n.label);
        }
        return result;
    }

    public Node<E> get(E label) {
        return this.nodes.get(label);
    }

    public boolean contains(E label) {
        return this.nodes.get(label) != null;
    }

    public void makeClosure() {
        for (Node node : this.roots()) {
            node.closure(new TreeSet());
        }
    }

    public static class Node<E extends Comparable<E>>
    implements Comparable<Node<E>> {
        protected SortedSet<Node<E>> parents = new TreeSet<Node<E>>();
        protected SortedSet<Node<E>> children = new TreeSet<Node<E>>();
        protected E label;

        public boolean equals(Object o) {
            return o != null && o instanceof Node && ((Node)o).label.equals(this.label);
        }

        protected Node(E l, boolean directed) {
            this.label = l;
            if (!directed) {
                this.children = this.parents;
            }
        }

        public void addChild(Node<E> child) {
            this.children.add(child);
            child.parents.add(this);
        }

        public void addParent(Node<E> parent) {
            this.parents.add(parent);
            parent.children.add(this);
        }

        public void addLink(Node<E> node) {
            this.children.add(node);
            node.parents.add(this);
        }

        public Set<Node<E>> links() {
            return this.parents;
        }

        public Set<Node<E>> children() {
            return this.children;
        }

        public Set<Node<E>> parents() {
            return this.parents;
        }

        public int hashCode() {
            return this.label.hashCode();
        }

        public String toString() {
            return this.label.toString();
        }

        protected void closure(Set<Node<E>> ancestors) {
            for (Node<Node> node : ancestors) {
                node.addChild(this);
            }
            ancestors.add(this);
            ArrayList<Node<E>> realchildren = new ArrayList<Node<E>>(this.children);
            for (Node node : realchildren) {
                node.closure(ancestors);
            }
            ancestors.remove(this);
        }

        public SortedSet<Node<E>> ancestors() {
            TreeSet<Node<E>> result = new TreeSet<Node<E>>();
            this.ancestors(result);
            return result;
        }

        protected void ancestors(Set<Node<E>> ancestors) {
            for (Node node : this.parents) {
                if (ancestors.contains(node)) continue;
                ancestors.add(node);
                node.ancestors(ancestors);
            }
        }

        public Set<Node<E>> descendants() {
            TreeSet<Node<E>> result = new TreeSet<Node<E>>();
            this.descendants(result);
            return result;
        }

        protected void descendants(Set<Node<E>> descendants) {
            for (Node node : this.children) {
                if (descendants.contains(node)) continue;
                descendants.add(node);
                node.descendants(descendants);
            }
        }

        @Override
        public int compareTo(Node<E> arg0) {
            return this.label.compareTo(arg0.label);
        }

        public E label() {
            return this.label;
        }
    }
}

