/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javatools.administrative.D;
import javatools.datatypes.FinalMap;

public class FrequencyVector<T, V extends Number> {
    protected double norm = 0.0;
    protected double sum = 0.0;
    protected double max = Double.MIN_VALUE;
    protected Map<T, V> data;
    protected List<T> sortedTerms;

    public FrequencyVector(Map<T, V> applications) {
        this.data = applications;
        Iterator<Map.Entry<T, V>> entries = applications.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<T, V> term = entries.next();
            double d = ((Number)term.getValue()).doubleValue();
            if (d <= 0.0) {
                entries.remove();
                continue;
            }
            this.sum += d;
            this.norm += d * d;
            if (!(d > this.max)) continue;
            this.max = d;
        }
        this.sortedTerms = FrequencyVector.sortedTerms(applications);
        this.norm = Math.sqrt(this.norm);
    }

    public int firstTiePos() {
        for (int i = 1; i < this.numTerms(); ++i) {
            if (this.doubleValueFor(this.termAtRank(i)) != this.doubleValueFor(this.termAtRank(i - 1))) continue;
            return i - 1;
        }
        return -1;
    }

    public double sum() {
        return this.sum;
    }

    public double norm() {
        return this.norm;
    }

    public double max() {
        return this.max;
    }

    public T termAtRank(int i) {
        if (i < this.sortedTerms().size()) {
            return this.sortedTerms().get(i);
        }
        return null;
    }

    public int numTerms() {
        return this.data.size();
    }

    public V valueFor(T term) {
        return (V)((Number)this.data.get(term));
    }

    public double doubleValueFor(T term) {
        Number value = (Number)this.data.get(term);
        if (value == null) {
            return 0.0;
        }
        return value.doubleValue();
    }

    public double normalizedValueFor(T term) {
        return this.doubleValueFor(term) / this.sum();
    }

    public double maxNormalizedValueFor(T term) {
        return this.doubleValueFor(term) / this.max();
    }

    public double smoothedValueFor(T term) {
        return (this.doubleValueFor(term) + 1.0) / (this.sum() + 2.0);
    }

    public List<T> sortedTerms() {
        return this.sortedTerms;
    }

    public Collection<T> terms() {
        return this.data.keySet();
    }

    protected static <C, V extends Comparable<V>> List<C> sortedTerms(final Map<C, V> applications) {
        ArrayList<C> sorted = new ArrayList<C>(applications.keySet());
        Collections.sort(sorted, new Comparator<C>(){

            @Override
            public int compare(C o1, C o2) {
                return ((Comparable)applications.get(o2)).compareTo(applications.get(o1));
            }
        });
        return sorted;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        for (T term : this.sortedTerms()) {
            result.append(term).append(" (").append(this.valueFor(term)).append("), ");
        }
        if (result.length() > 2) {
            result.setLength(result.length() - 2);
        }
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof FrequencyVector && ((FrequencyVector)obj).data.equals(this.data);
    }

    public FrequencyVector<T, Double> normalized() {
        Map result = null;
        try {
            result = (Map)this.data.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Map.Entry<T, V> entry : this.data.entrySet()) {
            result.put(entry.getKey(), ((Number)entry.getValue()).doubleValue() / this.norm());
        }
        return new FrequencyVector<T, V>(result);
    }

    public FrequencyVector<T, Double> maxNormalized() {
        Map result = null;
        try {
            result = (Map)this.data.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Map.Entry<T, V> entry : this.data.entrySet()) {
            result.put(entry.getKey(), ((Number)entry.getValue()).doubleValue() / this.max());
        }
        return new FrequencyVector<T, V>(result);
    }

    public Set<T> intersection(FrequencyVector<T, ?> other) {
        TreeSet<T> intersection = new TreeSet<T>(this.data.keySet());
        intersection.retainAll(other.data.keySet());
        return intersection;
    }

    public Set<T> topKIntersection(FrequencyVector<T, V> trueFrequencies, int k) {
        TreeSet<T> result = new TreeSet<T>(this.sortedTerms().subList(0, Math.min(k, this.numTerms())));
        result.retainAll(trueFrequencies.sortedTerms().subList(0, Math.min(k, trueFrequencies.numTerms())));
        return result;
    }

    public double cosine(FrequencyVector<T, ?> other, Collection<T> intersection) {
        if (this.norm() == 0.0 || other.norm() == 0.0) {
            return 0.0;
        }
        double cosine = 0.0;
        for (T term : intersection) {
            cosine += ((Number)this.data.get(term)).doubleValue() * ((Number)other.data.get(term)).doubleValue();
        }
        return cosine / this.norm() / other.norm();
    }

    public double cosine(FrequencyVector<T, ?> other) {
        if (this.norm() == 0.0 || other.norm() == 0.0) {
            return 0.0;
        }
        double cosine = 0.0;
        for (T term : this.terms()) {
            cosine += this.doubleValueFor(term) * other.doubleValueFor(term);
        }
        return cosine / this.norm() / other.norm();
    }

    public double precisionAtKWithRespectTo(Collection<T> groundTruth, int k) {
        if (k > this.numTerms()) {
            k = this.numTerms();
        }
        if (k == 0) {
            return 1.0;
        }
        int counter = 0;
        for (int i = 0; i < k; ++i) {
            if (!groundTruth.contains(this.termAtRank(i))) continue;
            ++counter;
        }
        return (double)counter / (double)k;
    }

    public double weightedPrecisionAtKWithRespectTo(Collection<T> groundTruth, int k) {
        if (k > this.numTerms()) {
            k = this.numTerms();
        }
        if (k == 0) {
            return 1.0;
        }
        double counter = 0.0;
        double total = 0.0;
        for (int i = 0; i < k; ++i) {
            double val = this.doubleValueFor(this.termAtRank(i));
            if (groundTruth.contains(this.termAtRank(i))) {
                counter += val;
            }
            total += val;
        }
        return counter / total;
    }

    public double precisionWithRespectTo(Collection<T> groundTruth) {
        return this.precisionAtKWithRespectTo(groundTruth, this.numTerms());
    }

    public double precisionWithRespectTo(FrequencyVector<T, ?> trueFrequencies) {
        return this.precisionWithRespectTo(trueFrequencies.terms());
    }

    public double precisionWithRespectToIntersection(Collection<T> intersection) {
        return this.numTerms() == 0 ? 1.0 : (double)intersection.size() / (double)this.numTerms();
    }

    public double weightedPrecisionWithRespectTo(Collection<T> groundTruth) {
        return this.weightedPrecisionAtKWithRespectTo(groundTruth, this.numTerms());
    }

    public double weightedPrecisionWithRespectTo(FrequencyVector<T, ?> trueFrequencies) {
        return this.precisionWithRespectTo(trueFrequencies.terms());
    }

    public double precisionAtKWithRespectTo(FrequencyVector<T, ?> groundTruth, int k) {
        return this.precisionAtKWithRespectTo(groundTruth.terms(), k);
    }

    public double weightedPrecisionAtKWithRespectTo(FrequencyVector<T, ?> groundTruth, int k) {
        return this.weightedPrecisionAtKWithRespectTo(groundTruth.terms(), k);
    }

    public double averagePrecision(Collection<T> groundTruth) {
        if (groundTruth.size() == 0) {
            return 1.0;
        }
        double avep = 0.0;
        int intersectionSoFar = 0;
        for (int i = 0; i < this.sortedTerms.size(); ++i) {
            if (!groundTruth.contains(this.termAtRank(i))) continue;
            avep += (double)(++intersectionSoFar / (i + 1));
        }
        return avep / (double)groundTruth.size();
    }

    public double optimalAveragePrecision(FrequencyVector<T, ?> trueFrequencies) {
        double bestAP = 0.0;
        for (int i = 1; i < trueFrequencies.sortedTerms.size(); ++i) {
            double ap = this.averagePrecision(trueFrequencies.sortedTerms().subList(0, i));
            if (!(ap > bestAP)) continue;
            bestAP = ap;
        }
        return bestAP;
    }

    public double recallAtKWithRespectTo(Collection<T> groundTruth, int k) {
        if (groundTruth.size() == 0) {
            return 1.0;
        }
        if (k > this.numTerms()) {
            k = this.numTerms();
        }
        int counter = 0;
        for (int i = 0; i < k; ++i) {
            if (!groundTruth.contains(this.termAtRank(i))) continue;
            ++counter;
        }
        return (double)counter / (double)groundTruth.size();
    }

    public double recallWithRespectTo(Collection<T> groundTruth) {
        if (groundTruth.size() == 0) {
            return 1.0;
        }
        int counter = 0;
        for (T term : groundTruth) {
            if (this.doubleValueFor(term) == 0.0) continue;
            ++counter;
        }
        return (double)counter / (double)groundTruth.size();
    }

    public double weightedRecallWithRespectTo(FrequencyVector<T, V> trueFrequencies) {
        return this.weightedRecallAtKWithRespectTo(trueFrequencies, this.numTerms());
    }

    public double weightedRecallAtKWithRespectTo(FrequencyVector<T, V> trueFrequencies, int k) {
        if (trueFrequencies.numTerms() == 0) {
            return 1.0;
        }
        double nominator = 0.0;
        for (int i = 0; i < this.numTerms() && i < k; ++i) {
            nominator += trueFrequencies.doubleValueFor(this.termAtRank(i));
        }
        return nominator / trueFrequencies.sum();
    }

    public double recallWithRespectTo(FrequencyVector<T, ?> trueFrequencies) {
        return this.recallWithRespectTo(trueFrequencies.terms());
    }

    public double recallWithRespectTo(Collection<T> trueSet, Collection<T> intersection) {
        return trueSet.size() == 0 ? 1.0 : (double)intersection.size() / (double)trueSet.size();
    }

    public double recallWithRespectTo(FrequencyVector<T, ?> trueFrequencies, Collection<T> intersection) {
        return this.recallWithRespectTo(trueFrequencies.terms(), intersection);
    }

    public double recallAtKWithRespectTo(FrequencyVector<T, V> trueFrequencies, int k) {
        return this.recallAtKWithRespectTo(trueFrequencies.terms(), k);
    }

    public double ndcgWithRespectToGain(FrequencyVector<T, ?> trueFrequencies) {
        double dcg = 0.0;
        for (int i = 0; i < this.numTerms(); ++i) {
            dcg += trueFrequencies.maxNormalizedValueFor(this.termAtRank(i)) / Math.log(i + 2);
        }
        double truedcg = 0.0;
        for (int i = 0; i < trueFrequencies.numTerms(); ++i) {
            truedcg += trueFrequencies.maxNormalizedValueFor(trueFrequencies.termAtRank(i)) / Math.log(i + 2);
        }
        if (truedcg == 0.0) {
            return 0.0;
        }
        return dcg / truedcg;
    }

    public double ndcg2WithRespectToGain(FrequencyVector<T, ?> trueFrequencies) {
        double dcg = 0.0;
        for (int i = 0; i < this.numTerms(); ++i) {
            dcg += (Math.pow(2.0, trueFrequencies.maxNormalizedValueFor(this.termAtRank(i))) - 1.0) / Math.log(i + 2);
        }
        double truedcg = 0.0;
        for (int i = 0; i < trueFrequencies.numTerms(); ++i) {
            truedcg += (Math.pow(2.0, trueFrequencies.maxNormalizedValueFor(trueFrequencies.termAtRank(i))) - 1.0) / Math.log(i + 2);
        }
        if (truedcg == 0.0) {
            return 0.0;
        }
        return dcg / truedcg;
    }

    public FrequencyVector<T, Double> normalizedMeanWith(FrequencyVector<T, V> other) {
        Map mean = null;
        try {
            mean = (Map)this.data.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (T term : this.sortedTerms()) {
            mean.put(term, this.doubleValueFor(term) / 2.0);
        }
        for (T term : other.sortedTerms()) {
            Double d = (Double)mean.get(term);
            if (d == null) {
                mean.put(term, other.doubleValueFor(term) / 2.0);
                continue;
            }
            mean.put(term, other.doubleValueFor(term) / 2.0 + d);
        }
        return new FrequencyVector<T, V>(mean);
    }

    public double fuzzyRecallWithRespectTo(FrequencyVector<T, V> trueFrequencies) {
        if (trueFrequencies.sum() == 0.0) {
            return 1.0;
        }
        double fuzzyRecall = 0.0;
        for (T trueTerm : trueFrequencies.sortedTerms()) {
            double guessedValue;
            double trueValue = trueFrequencies.maxNormalizedValueFor(trueTerm);
            if (!(trueValue > (guessedValue = this.maxNormalizedValueFor(trueTerm)))) continue;
            fuzzyRecall += trueValue - guessedValue;
        }
        if ((fuzzyRecall = 1.0 - fuzzyRecall / trueFrequencies.sum() * trueFrequencies.max()) < 0.0) {
            fuzzyRecall = 0.0;
        }
        return fuzzyRecall;
    }

    public double fuzzyPrecisionWithRespectTo(FrequencyVector<T, V> trueFrequencies) {
        return trueFrequencies.fuzzyRecallWithRespectTo(this);
    }

    public static double[] wilson(int total, int correct) {
        double z = 1.96;
        double p = (double)correct / (double)total;
        double center = (p + 0.5 / (double)total * z * z) / (1.0 + 1.0 / (double)total * z * z);
        double d = z * Math.sqrt((p * (1.0 - p) + 0.25 / (double)total * z * z) / (double)total) / (1.0 + 1.0 / (double)total * z * z);
        return new double[]{center, d};
    }

    public static void main(String[] args) {
        D.p(FrequencyVector.wilson(120, 93));
        D.p(FrequencyVector.wilson(120, 76));
        FrequencyVector groundTruth = new FrequencyVector(new FinalMap("A", 3, "B", 1, "C", 2));
        FrequencyVector guessed = new FrequencyVector(new FinalMap("A", 3, "C", 1, "D", 1, "E", 1));
        D.p("Comparing");
        D.p("  Ground truth:", groundTruth);
        D.p("  Guessed     :", guessed);
        D.p(new Object[0]);
        D.p("Precision:", guessed.precisionWithRespectTo(groundTruth));
        D.p("Weighted precision:", guessed.weightedPrecisionWithRespectTo(groundTruth));
        D.p("Fuzzy precision:", guessed.fuzzyPrecisionWithRespectTo(groundTruth));
        D.p("Precision at 2:", guessed.precisionAtKWithRespectTo(groundTruth, 2));
        D.p("Weighted precision at 2:", guessed.weightedPrecisionAtKWithRespectTo(groundTruth, 2));
        D.p("Recall:", guessed.recallWithRespectTo(groundTruth));
        D.p("Weighted recall:", guessed.weightedRecallWithRespectTo(groundTruth));
        D.p("Fuzzy recall:", guessed.fuzzyRecallWithRespectTo(groundTruth));
        D.p("Recall at 2:", guessed.recallAtKWithRespectTo(groundTruth, 2));
        D.p("Weighted recall at 2:", guessed.weightedRecallAtKWithRespectTo(groundTruth, 2));
        D.p("\nCosine:", guessed.cosine(groundTruth));
        D.p("Intersection:", guessed.intersection(groundTruth));
        D.p("NDCG:", guessed.ndcgWithRespectToGain(groundTruth));
    }
}

