/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.Arrays;
import java.util.NoSuchElementException;
import javatools.administrative.D;
import javatools.datatypes.IntSet;

public class IdPriorityQueue
extends IntSet {
    protected double[] priorities;
    protected int highestIndex = -1;

    public IdPriorityQueue(int capacity) {
        super(capacity);
        this.priorities = new double[capacity];
    }

    public IdPriorityQueue() {
        this(10);
    }

    public void add(int i, double priority) {
        int pos = this.indexOf(i);
        if (pos != -1) {
            if (this.highestIndex == pos && this.priorities[pos] < priority) {
                this.highestIndex = -1;
            }
            if (this.highestIndex != -1 && this.priorities[this.highestIndex] < priority) {
                this.highestIndex = pos;
            }
            this.priorities[pos] = priority;
            return;
        }
        if (this.numElements == this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length + 100);
            this.priorities = Arrays.copyOf(this.priorities, this.data.length + 100);
        }
        this.data[this.addIndex] = i;
        this.isThere.set(this.addIndex);
        this.priorities[this.addIndex] = priority;
        if (this.addIndex > this.lastIndex) {
            this.lastIndex = this.addIndex;
        }
        ++this.numElements;
        if (this.highestIndex != -1 && this.priorities[this.highestIndex] < this.priorities[this.addIndex]) {
            this.highestIndex = this.addIndex;
        }
    }

    public void put(long id, double priority) {
        this.add((int)id, priority);
    }

    protected int highestIndex() {
        if (this.numElements == 0) {
            throw new NoSuchElementException();
        }
        if (this.highestIndex != -1) {
            return this.highestIndex;
        }
        int max = -1;
        for (int i = 0; i <= this.lastIndex; ++i) {
            if (!this.isThere.get(i) || max != -1 && !(this.priorities[i] > this.priorities[max])) continue;
            max = i;
        }
        this.highestIndex = max;
        return this.highestIndex;
    }

    @Override
    public int poll() {
        int pos = this.highestIndex();
        this.isThere.set(pos, false);
        --this.numElements;
        this.highestIndex = -1;
        int toReturn = this.data[pos];
        this.shrink();
        return toReturn;
    }

    @Override
    protected void shrink() {
        if (this.numElements < this.data.length / 2 && this.data.length > 300) {
            IdPriorityQueue result = new IdPriorityQueue(this.numElements + 100);
            result.addAll(this);
            this.data = result.data;
            this.isThere = result.isThere;
            this.priorities = result.priorities;
            this.lastIndex = result.lastIndex;
            this.numElements = result.numElements;
            this.highestIndex = -1;
        }
    }

    public double highestPriority() {
        return this.priorities[this.highestIndex()];
    }

    public int peek() {
        return this.data[this.highestIndex()];
    }

    @Override
    public boolean remove(int i) {
        int pos = this.indexOf(i);
        if (pos == -1) {
            return false;
        }
        if (pos == this.highestIndex) {
            this.highestIndex = -1;
        }
        this.removeIndex(pos);
        this.shrink();
        return true;
    }

    @Override
    public void clear(int capacity) {
        super.clear(capacity);
        this.priorities = new double[capacity];
        this.highestIndex = -1;
    }

    public void addAll(IdPriorityQueue s) {
        for (int i = 0; i <= s.lastIndex; ++i) {
            if (!s.isThere.get(i)) continue;
            this.add(s.data[i], s.priorities[i]);
        }
    }

    @Override
    public boolean add(int v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i <= this.lastIndex; ++i) {
            if (!this.isThere.get(i)) continue;
            result.append(this.data[i]).append(" (").append(this.priorities[i]).append("), ");
        }
        if (result.length() > 2) {
            result.setLength(result.length() - 2);
        }
        return result.append(']').toString();
    }

    public static void main(String[] args) {
        IdPriorityQueue q = new IdPriorityQueue();
        for (int i = 1; i < 10; ++i) {
            q.add(i, 1000 - i * 10);
        }
        D.p(q);
        q.add(2, 100.0);
        D.p(q);
        q.remove(2);
        q.remove(3);
        q.add(3, 40.0);
        D.p(q);
        while (!q.isEmpty()) {
            D.p(q);
            D.p(q.poll());
        }
    }
}

