/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import javatools.administrative.D;
import javatools.datatypes.PeekIterator;

public class IntSet
implements Set<Integer> {
    protected int[] data;
    protected BitSet isThere;
    protected int numElements = 0;
    protected int pollIndex = 0;
    protected int addIndex = 0;
    protected int lastIndex = -1;

    @Override
    public PeekIterator<Integer> iterator() {
        return new PeekIterator<Integer>(){
            int pos = 0;

            @Override
            protected Integer internalNext() throws Exception {
                while (this.pos <= IntSet.this.lastIndex) {
                    if (IntSet.this.isThere.get(this.pos)) {
                        return IntSet.this.data[this.pos];
                    }
                    ++this.pos;
                }
                return null;
            }
        };
    }

    @Override
    public boolean add(int v) {
        if (this.contains(v)) {
            return false;
        }
        if (this.numElements == this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length + 100);
        }
        this.data[this.addIndex] = v;
        this.isThere.set(this.addIndex, true);
        ++this.numElements;
        if (this.addIndex > this.lastIndex) {
            this.lastIndex = this.addIndex;
        }
        return true;
    }

    public void clear(int capacity) {
        this.numElements = 0;
        this.data = new int[capacity];
        this.isThere = new BitSet(capacity);
        this.lastIndex = -1;
    }

    public int poll() {
        if (this.numElements == 0) {
            throw new NoSuchElementException();
        }
        this.shrink();
        while (true) {
            if (this.pollIndex > this.lastIndex) {
                this.pollIndex = 0;
            }
            if (this.isThere.get(this.pollIndex)) {
                return this.removeIndex(this.pollIndex);
            }
            ++this.pollIndex;
        }
    }

    protected int indexOf(int v) {
        this.addIndex = this.lastIndex + 1;
        for (int i = 0; i <= this.lastIndex; ++i) {
            if (!this.isThere.get(i)) {
                this.addIndex = i;
            }
            if (this.data[i] != v || !this.isThere.get(i)) continue;
            return i;
        }
        return -1;
    }

    protected void shrink() {
        if (this.numElements < this.data.length / 2 && this.data.length > 300) {
            IntSet result = new IntSet(this.numElements + 100);
            result.addAll(this);
            this.data = result.data;
            this.isThere = result.isThere;
            this.lastIndex = result.lastIndex;
            this.numElements = result.numElements;
        }
    }

    protected int removeIndex(int index) {
        this.isThere.set(index, false);
        --this.numElements;
        return this.data[index];
    }

    public static IntSet of(int ... initial) {
        IntSet result = new IntSet();
        for (int i : initial) {
            result.add(i);
        }
        return result;
    }

    public IntSet(IntSet copy) {
        this.setTo(copy);
    }

    public IntSet(BitSet copy) {
        this.clear(copy.cardinality());
        this.addAll(copy);
    }

    public IntSet() {
        this.clear();
    }

    public IntSet(int capacity) {
        this.clear(capacity);
    }

    public void setTo(IntSet copy) {
        if (copy == this) {
            return;
        }
        this.clear(copy.size());
        this.addAll(copy);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        for (int i = 0; i <= this.lastIndex; ++i) {
            if (!this.isThere.get(i) || c.contains(this.data[i])) continue;
            this.removeIndex(i);
            result = true;
        }
        this.shrink();
        return result;
    }

    public boolean remove(int i) {
        int pos = this.indexOf(i);
        if (pos == -1) {
            return false;
        }
        this.removeIndex(pos);
        this.shrink();
        return true;
    }

    public boolean remove(long i) {
        return this.remove((int)i);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Number)) {
            return false;
        }
        return this.remove(((Number)o).intValue());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    public boolean removeAll(IntSet c) {
        boolean result = false;
        for (int i = 0; i <= c.lastIndex; ++i) {
            if (!c.isThere.get(i)) continue;
            result |= this.remove(c.data[i]);
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.numElements];
        int j = 0;
        for (int i = 0; i <= this.lastIndex; ++i) {
            if (!this.isThere.get(i)) continue;
            result[j++] = new Integer(this.data[i]);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("IntSet.toArray(T[])");
    }

    public String toString() {
        StringBuilder res = new StringBuilder("[");
        for (int i = 0; i <= this.lastIndex; ++i) {
            if (!this.isThere.get(i)) continue;
            res.append(this.data[i]).append(", ");
        }
        if (this.numElements > 0) {
            res.setLength(res.length() - 2);
        }
        return res.append("]").toString();
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public boolean add(long i) {
        return this.add((int)i);
    }

    @Override
    public boolean add(Number e) {
        return this.add(e.intValue());
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        boolean returnValue = false;
        for (Integer n : c) {
            returnValue |= this.add(n);
        }
        return returnValue;
    }

    public boolean addAll(IntSet s) {
        boolean returnValue = false;
        for (int index = 0; index <= s.lastIndex; ++index) {
            if (!s.isThere.get(index)) continue;
            returnValue |= this.add(s.data[index]);
        }
        return returnValue;
    }

    public boolean addAll(BitSet s) {
        boolean returnValue = false;
        int i = s.nextSetBit(0);
        while (i >= 0) {
            returnValue |= this.add(i);
            i = s.nextSetBit(i + 1);
        }
        return returnValue;
    }

    public boolean removeAll(BitSet s) {
        boolean returnValue = false;
        int i = s.nextSetBit(0);
        while (i >= 0) {
            returnValue |= this.remove(i);
            i = s.nextSetBit(i + 1);
        }
        return returnValue;
    }

    public void addTo(BitSet s) {
        for (int i = 0; i <= this.lastIndex; ++i) {
            if (!this.isThere.get(i)) continue;
            s.set(this.data[i]);
        }
    }

    public IntSet enhancedBy(IntSet addMe) {
        this.addAll(addMe);
        return this;
    }

    public IntSet enhancedBy(int addMe) {
        this.add(addMe);
        return this;
    }

    public IntSet shrunkBy(IntSet addMe) {
        this.removeAll(addMe);
        return this;
    }

    public IntSet shrunkBy(int addMe) {
        this.remove(addMe);
        return this;
    }

    public boolean contains(int i) {
        return this.indexOf(i) != -1;
    }

    public boolean contains(long i) {
        return this.contains((int)i);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Number)) {
            return false;
        }
        return this.contains(((Number)o).intValue());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.numElements == 0;
    }

    @Override
    public void clear() {
        this.clear(10);
    }

    @Override
    public boolean add(Integer e) {
        return this.add((Number)e);
    }

    public static void main(String[] args) {
        int i;
        IntSet s = new IntSet();
        for (i = 0; i < 500; ++i) {
            s.add(i);
        }
        D.p(s);
        for (i = 0; i < 500; i += 2) {
            s.remove(i);
        }
        D.p(s);
        while (!s.isEmpty()) {
            D.p(s.poll());
        }
    }
}

