/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javatools.administrative.D;

public class SparseVector
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected double label;
    protected double[] val;
    protected int[] dim;
    protected static int[] STANDARDDIM = new int[]{0, 1, 2, 3, 4, 5};
    protected static double[] BINARY = new double[]{1.0, 1.0, 1.0};
    protected int size;
    protected double twonorm_sq = -1.0;
    public static final Distance eucledianDistance = new Distance(){

        @Override
        public double distance(SparseVector v1, SparseVector v2) {
            return v1.eucledianDistance(v2);
        }
    };
    public static final Distance cosineDistance = new Distance(){

        @Override
        public double distance(SparseVector v1, SparseVector v2) {
            return 1.0 - v1.cosine(v2);
        }
    };

    public SparseVector(SparseVector v) {
        this.label = v.label;
        this.dim = v.dim;
        this.size = v.size;
        this.val = v.val == BINARY ? BINARY : (double[])v.val.clone();
    }

    protected static void updateBINARY(int num) {
        if (BINARY.length >= num) {
            return;
        }
        BINARY = new double[num];
        Arrays.fill(BINARY, 1.0);
    }

    public SparseVector(double l, List<Integer> dimensions) {
        this.label = l;
        this.dim = new int[dimensions.size()];
        this.size = dimensions.size();
        int i = 0;
        for (int d : dimensions) {
            this.dim[i++] = d;
        }
        Arrays.sort(this.dim);
        SparseVector.updateBINARY(this.size);
        this.val = BINARY;
    }

    public SparseVector(double l, int[] d) {
        Arrays.sort(d);
        int zeroes = 0;
        while (d[zeroes] == 0) {
            ++zeroes;
        }
        for (int i = zeroes; i < d.length - 1; ++i) {
            if (d[i] != d[i + 1]) continue;
            d[i] = 0;
            ++zeroes;
        }
        this.dim = new int[d.length - zeroes];
        int j = 0;
        for (int i = 0; i < d.length; ++i) {
            if (d[i] == 0) continue;
            this.dim[j++] = d[i];
        }
        this.size = this.dim.length;
        SparseVector.updateBINARY(this.size);
        this.val = BINARY;
        this.label = l;
    }

    public SparseVector(double[] v, int[] d) {
        this(0.0, d, v);
    }

    public SparseVector(double l, int[] d, double[] v) {
        this.val = v;
        this.dim = d;
        this.label = l;
        this.size = this.dim.length;
    }

    public SparseVector(double label, double ... values) {
        this.label = label;
        this.val = values;
        if (STANDARDDIM.length < values.length) {
            STANDARDDIM = new int[values.length];
            for (int i = 0; i < STANDARDDIM.length; ++i) {
                SparseVector.STANDARDDIM[i] = i;
            }
        }
        this.dim = STANDARDDIM;
        this.size = values.length;
    }

    public SparseVector(String s) {
        s = s + ' ';
        this.size = 0;
        boolean isBinary = true;
        for (int i = 0; i < s.length() && s.charAt(i) != '#'; ++i) {
            if (s.charAt(i) != ':') continue;
            double v = Double.parseDouble(s.substring(i + 1, s.indexOf(32, i)));
            if (v != 0.0) {
                ++this.size;
            }
            if (v == 0.0 || v == 1.0) continue;
            isBinary = false;
        }
        this.label = Double.parseDouble(s.substring(0, s.indexOf(32)));
        this.dim = new int[this.size];
        if (isBinary) {
            SparseVector.updateBINARY(this.size);
            this.val = BINARY;
        } else {
            this.val = new double[this.size];
        }
        int stringIndex = s.indexOf(32);
        int n = 0;
        while (n < this.size) {
            while (s.charAt(stringIndex) == ' ') {
                ++stringIndex;
            }
            int j = s.indexOf(58, stringIndex);
            this.dim[n] = Integer.parseInt(s.substring(stringIndex, j));
            stringIndex = s.indexOf(32, stringIndex);
            double v = Double.parseDouble(s.substring(j + 1, stringIndex));
            if (!isBinary) {
                this.val[n] = v;
            }
            if (v == 0.0) continue;
            ++n;
        }
    }

    public SparseVector compress() {
        if (this.val == BINARY) {
            return this;
        }
        int numNonZeros = 0;
        boolean isBinary = true;
        for (int i = 0; i < this.val.length; ++i) {
            if (this.val[i] != 0.0) {
                ++numNonZeros;
            }
            if (this.val[i] == 0.0 || this.val[i] == 1.0) continue;
            isBinary = false;
        }
        if (isBinary) {
            SparseVector.updateBINARY(numNonZeros);
            this.val = BINARY;
        }
        if (numNonZeros == this.size) {
            return this;
        }
        double[] oldval = this.val;
        int[] olddim = this.dim;
        this.val = new double[numNonZeros];
        if (!isBinary) {
            this.dim = new int[numNonZeros];
        }
        int index = 0;
        for (int i = 0; i < oldval.length; ++i) {
            if (oldval[i] == 0.0) continue;
            if (!isBinary) {
                this.val[index] = oldval[i];
            }
            this.dim[index] = olddim[i];
            ++index;
        }
        return this;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append(this.label);
        for (int i = 0; i < this.size; ++i) {
            r.append(' ').append(this.dim[i]).append(':').append(this.val[i]);
        }
        return r.toString();
    }

    public double sprod(SparseVector v) {
        int i = -1;
        int j = -1;
        double r = 0.0;
        while (++i < this.size()) {
            if (++j >= v.size()) {
                return r;
            }
            while (this.dim[i] < v.dim[j]) {
                if (++i < this.size()) continue;
                return r;
            }
            while (this.dim[i] > v.dim[j]) {
                if (++j < v.size()) continue;
                return r;
            }
            r += this.val[i] * v.val[j];
        }
        return r;
    }

    public boolean isBinary() {
        return this.val == BINARY;
    }

    public int size() {
        return this.size;
    }

    public double squaredl2norm() {
        if (this.twonorm_sq == -1.0) {
            this.twonorm_sq = this.sprod(this);
        }
        return this.twonorm_sq;
    }

    public double l2norm() {
        return Math.sqrt(this.squaredl2norm());
    }

    public double cosine(SparseVector v) {
        return this.sprod(v) / this.l2norm() / v.l2norm();
    }

    public double get(int i) {
        int index = this.index(i);
        if (index == -1) {
            return 0.0;
        }
        return this.val[index];
    }

    public static String visualize(SparseVector ... vectors) {
        return SparseVector.visualize(Arrays.asList(vectors));
    }

    public static String visualize(List<SparseVector> vectors1, List<SparseVector> vectors2) {
        ArrayList<SparseVector> l = new ArrayList<SparseVector>();
        l.addAll(vectors1);
        l.addAll(vectors2);
        return SparseVector.visualize(l);
    }

    public static String visualize(SparseVector[] vectors1, SparseVector[] vectors2) {
        ArrayList<SparseVector> l = new ArrayList<SparseVector>();
        l.addAll(Arrays.asList(vectors1));
        l.addAll(Arrays.asList(vectors2));
        return SparseVector.visualize(l);
    }

    public static String visualize(List<SparseVector> vectors) {
        int i;
        double xmax = 0.0;
        double xmin = 0.0;
        double ymax = 0.0;
        double ymin = 0.0;
        for (SparseVector v : vectors) {
            if (v.get(0) > xmax) {
                xmax = v.get(0);
            }
            if (v.get(0) < xmin) {
                xmin = v.get(0);
            }
            if (v.get(1) > ymax) {
                ymax = v.get(1);
            }
            if (!(v.get(1) < ymin)) continue;
            ymin = v.get(1);
        }
        if (xmax == xmin) {
            xmax = xmin + 10.0;
        }
        if (ymax == ymin) {
            ymax = ymin + 10.0;
        }
        int screenx = 80;
        int screeny = 24;
        StringBuilder result = new StringBuilder(1930);
        for (i = 0; i < 79; ++i) {
            result.append('-');
        }
        result.append('\n');
        for (int lines = 0; lines < 22; ++lines) {
            for (int col = 0; col < 78; ++col) {
                result.append(' ');
            }
            result.append("|\n");
        }
        for (i = 0; i < 79; ++i) {
            result.append('-');
        }
        result.setCharAt((int)((0.0 - xmin) / (xmax - xmin) * 78.0 + 80.0 + 80.0 * (0.0 - ymin) / (ymax - ymin) * 22.0), 'X');
        for (SparseVector v : vectors) {
            result.setCharAt((int)((v.get(0) - xmin) / (xmax - xmin) * 78.0 + 80.0 + (double)(80 * (int)((v.get(1) - ymin) / (ymax - ymin) * 22.0))), v.charLabel());
        }
        return result.toString();
    }

    public char charLabel() {
        if (this.label >= 1.0 && this.label < 10.0) {
            return (char)(this.label + 48.0);
        }
        if (this.label > 0.0) {
            return '+';
        }
        if (this.label < 0.0) {
            return '-';
        }
        return '0';
    }

    public static void kMeans(SparseVector[] dots, SparseVector[] centers) {
        SparseVector.kMeans(dots, centers, eucledianDistance, 0.1, 10);
    }

    public static void kMeans(SparseVector[] dots, SparseVector[] centers, Distance distanceFunction, double epsilon, int iterations) {
        while (iterations-- > 0) {
            int[] dot2center = new int[dots.length];
            for (int dot = 0; dot < dots.length; ++dot) {
                double bestDist = Double.MAX_VALUE;
                for (int center = 0; center < centers.length; ++center) {
                    double dist = distanceFunction.distance(dots[dot], centers[center]);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                    dot2center[dot] = center;
                }
            }
            SparseVector[] oldCenters = new SparseVector[centers.length];
            for (int center = 0; center < centers.length; ++center) {
                oldCenters[center] = centers[center];
                centers[center] = new SparseVector(centers[center].label, 0.0);
            }
            int[] numCenterMembers = new int[centers.length];
            for (int dot = 0; dot < dots.length; ++dot) {
                centers[dot2center[dot]].add(dots[dot]);
                int n = dot2center[dot];
                numCenterMembers[n] = numCenterMembers[n] + 1;
            }
            double maxEpsilon = 0.0;
            for (int center = 0; center < centers.length; ++center) {
                if (numCenterMembers[center] == 0) continue;
                centers[center].multiply(1.0 / (double)numCenterMembers[center]);
                double d = oldCenters[center].eucledianDistance(centers[center]);
                if (!(d > maxEpsilon)) continue;
                maxEpsilon = d;
            }
            if (!(maxEpsilon < epsilon)) continue;
            break;
        }
    }

    public double eucledianDistance(SparseVector v) {
        int myIndex = 0;
        int vIndex = 0;
        double result = 0.0;
        while (vIndex < v.size || myIndex < this.size) {
            if (vIndex >= v.size || myIndex < this.size && this.dim[myIndex] < v.dim[vIndex]) {
                result += this.val[myIndex] * this.val[myIndex];
                ++myIndex;
                continue;
            }
            if (myIndex >= this.size || vIndex < v.size && this.dim[myIndex] > v.dim[vIndex]) {
                result += v.val[vIndex] * v.val[vIndex];
                ++vIndex;
                continue;
            }
            double d = v.val[vIndex] - this.val[myIndex];
            result += d * d;
            ++myIndex;
            ++vIndex;
        }
        return Math.sqrt(result);
    }

    public int index(int dimension) {
        int pos = Arrays.binarySearch(this.dim, dimension);
        if (pos < 0 || this.size <= pos) {
            return -1;
        }
        return pos;
    }

    public SparseVector add(SparseVector v) {
        int addedDimensions = 0;
        for (int i = 0; i < v.size; ++i) {
            if (this.index(v.dim[i]) != -1) continue;
            ++addedDimensions;
        }
        int[] newDim = addedDimensions == 0 ? this.dim : new int[this.size() + addedDimensions];
        double[] newVal = addedDimensions == 0 && !this.isBinary() ? this.val : new double[this.size() + addedDimensions];
        int myIndex = 0;
        int vIndex = 0;
        for (int i = 0; i < this.size + addedDimensions; ++i) {
            if (vIndex >= v.size || myIndex < this.size && this.dim[myIndex] < v.dim[vIndex]) {
                newDim[i] = this.dim[myIndex];
                newVal[i] = this.val[myIndex];
                ++myIndex;
                continue;
            }
            if (myIndex >= this.size || vIndex < v.size && this.dim[myIndex] > v.dim[vIndex]) {
                newDim[i] = v.dim[vIndex];
                newVal[i] = v.val[vIndex];
                ++vIndex;
                continue;
            }
            newDim[i] = this.dim[myIndex];
            newVal[i] = this.val[myIndex] + v.val[vIndex];
            ++myIndex;
            ++vIndex;
        }
        this.val = newVal;
        this.dim = newDim;
        this.size += addedDimensions;
        return this;
    }

    public SparseVector multiply(double r) {
        if (this.isBinary()) {
            this.val = new double[this.size()];
            for (int i = 0; i < this.size; ++i) {
                this.val[i] = r;
            }
            return this;
        }
        for (int i = 0; i < this.val.length; ++i) {
            this.val[i] = this.val[i] * r;
        }
        return this;
    }

    public Iterator<Integer> nonZeroIndices() {
        return new Iterator<Integer>(){
            int currentPos = 0;

            @Override
            public boolean hasNext() {
                return this.currentPos < SparseVector.this.size();
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Index " + this.currentPos);
                }
                return SparseVector.this.dim[this.currentPos++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public SparseVector clone() {
        return new SparseVector(this);
    }

    public static void main(String[] argv) throws Exception {
        SparseVector v1a = new SparseVector(2.0, 10.0, 14.0);
        SparseVector v1b = new SparseVector(3.0, 10.0, 18.0);
        SparseVector v2a = new SparseVector(4.0, 20.0, 30.0);
        SparseVector v2b = new SparseVector(5.0, 25.0, 32.0);
        SparseVector v3a = new SparseVector(6.0, 20.0, 10.0);
        SparseVector v3b = new SparseVector(7.0, 23.0, 12.0);
        SparseVector c1 = new SparseVector(8.0, 15.0, 13.0);
        SparseVector c2 = new SparseVector(9.0, 15.0, 14.0);
        SparseVector[] centers = new SparseVector[]{c1, c2};
        SparseVector[] dots = new SparseVector[]{v1a, v1b, v2a, v2b, v3a, v3b};
        D.p(SparseVector.visualize(dots, centers));
        D.p("Press a key to move the centroids (the 8 and 9) according to k-means.");
        D.r();
        SparseVector.kMeans(dots, centers, eucledianDistance, 0.1, 10);
        D.p(SparseVector.visualize(dots, centers));
    }

    public static interface Distance {
        public double distance(SparseVector var1, SparseVector var2);
    }
}

