/*
 * Decompiled with CFR 0.152.
 */
package javatools.datatypes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import javatools.administrative.D;
import javatools.datatypes.Pair;
import javatools.datatypes.Visitable;
import javatools.datatypes.Visitor;

public class Tree<T>
implements Iterable<T>,
Visitable<Tree<T>> {
    protected List<Tree<T>> children = new ArrayList<Tree<T>>();
    protected T element;
    protected Tree<T> parent;

    public Tree() {
        this(null);
    }

    public Tree(T element) {
        this(null, element);
    }

    public Tree(Tree<T> parent, T element) {
        this(parent, element, new ArrayList<Tree<T>>(0));
    }

    public Tree(T element, List<Tree<T>> children) {
        this(null, element, children);
    }

    public Tree(Tree<T> parent, T element, List<Tree<T>> children) {
        this.setParent(parent);
        this.setElement(element);
        this.setChildren(children);
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public void setParent(Tree<T> parent) {
        this.parent = parent;
    }

    public List<Tree<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<Tree<T>> children) {
        children = new ArrayList<Tree<T>>();
        for (Tree<T> child : children) {
            this.addChild(child);
        }
    }

    public void addChild(Tree<T> child) {
        this.children.add(child);
        child.parent = this;
    }

    public T getElement() {
        return this.element;
    }

    public void setElement(T element) {
        this.element = element;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Stack<Pair<Tree<T>, Integer>> dfs = new Stack();
            {
                this.dfs.push(new Pair<Tree, Integer>(Tree.this, -1));
            }

            protected void prepare() {
                if (this.dfs.size() == 0) {
                    return;
                }
                if (this.dfs.peek().first().children.size() > this.dfs.peek().second()) {
                    return;
                }
                this.dfs.pop();
                this.prepare();
            }

            @Override
            public boolean hasNext() {
                this.prepare();
                return this.dfs.size() != 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int childNum = this.dfs.peek().second();
                this.dfs.peek().setSecond(childNum + 1);
                if (childNum == -1) {
                    return this.dfs.peek().first().getElement();
                }
                this.dfs.push(new Pair(this.dfs.peek().first().getChildren().get(childNum), -1));
                return this.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean receive(Visitor<Tree<T>> visitor) throws Exception {
        if (!visitor.visit(this)) {
            return false;
        }
        for (Tree<Tree<Tree>> tree : this.children) {
            if (tree.receive(visitor)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.children.size() == 0) {
            return this.element.toString();
        }
        return this.element.toString() + this.children;
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        this.prettyPrint(sb, null, false);
        return sb.toString();
    }

    private void prettyPrint(StringBuilder stringBuilder, String prefix, boolean parentIsLastChild) {
        stringBuilder.append(prefix == null ? "" : prefix + "+-");
        stringBuilder.append(this.getElement());
        stringBuilder.append("\n");
        List<Tree<T>> list = this.getChildren();
        int i = 0;
        for (Tree<T> child : list) {
            String addToPrefix = parentIsLastChild ? "  " : "| ";
            super.prettyPrint(stringBuilder, prefix == null ? "" : prefix + addToPrefix, i == list.size() - 1);
            ++i;
        }
    }

    public static void main(String[] args) {
        Tree<Integer> t1 = new Tree<Integer>(1);
        Tree<Integer> t2 = new Tree<Integer>(2);
        Tree<Integer> t3 = new Tree<Integer>(3);
        Tree<Integer> a1 = new Tree<Integer>(-1);
        Tree<Integer> t0 = new Tree<Integer>(0);
        t0.addChild(a1);
        t0.addChild(t1);
        t1.addChild(t2);
        t2.addChild(t3);
        for (Integer i : t0) {
            D.p(i);
        }
        D.p(t0);
    }
}

