/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javatools.filehandlers.UTF8Writer;

public class CSVFile
implements Closeable {
    protected Writer out;
    protected String separator = ", ";
    protected boolean quoteAll = false;
    protected boolean quoteNever = false;

    public CSVFile(File f, boolean append, String separator, List<String> columns) throws IOException {
        this.separator = separator;
        if (append && !f.exists()) {
            append = false;
        }
        this.out = new UTF8Writer(f, append);
        if (!append && columns != null && columns.size() > 0) {
            this.out.write("# ");
            this.write(columns);
        }
    }

    public CSVFile(File f, boolean append, List<String> columns) throws IOException {
        this(f, append, ", ", columns);
    }

    public CSVFile(File f, boolean append, String ... columns) throws IOException {
        this(f, append, Arrays.asList(columns));
    }

    public CSVFile(File f, boolean append) throws IOException {
        this(f, append, (List<String>)null);
    }

    public CSVFile(String f, boolean append) throws IOException {
        this(new File(f), append);
    }

    public CSVFile(File f) throws IOException {
        this(f, false);
    }

    public CSVFile(String f) throws IOException {
        this(new File(f));
    }

    public CSVFile(String f, boolean append, List<String> columns) throws IOException {
        this(new File(f), append, columns);
    }

    public CSVFile(String f, boolean append, String ... columns) throws IOException {
        this(f, append, Arrays.asList(columns));
    }

    public CSVFile(String f, List<String> columns) throws IOException {
        this(new File(f), false, columns);
    }

    public CSVFile(String f, String ... columns) throws IOException {
        this(f, Arrays.asList(columns));
    }

    public CSVFile(File f, List<String> columns) throws IOException {
        this(f, false, columns);
    }

    public CSVFile(File f, String ... columns) throws IOException {
        this(f, Arrays.asList(columns));
    }

    public void setQuoting(boolean q) {
        this.quoteAll = q;
    }

    public void neverQuote(boolean q) {
        this.quoteNever = q;
    }

    public void write(List<? extends Object> columns) throws IOException {
        for (int i = 0; i < columns.size(); ++i) {
            this.out.write(this.column(columns.get(i)));
            if (i == columns.size() - 1) continue;
            this.out.write(this.separator);
        }
        this.out.write("\n");
    }

    public void write(Object ... columns) throws IOException {
        this.write(Arrays.asList(columns));
    }

    protected String column(Object c) {
        String col = c.toString();
        if (this.quoteNever) {
            return col;
        }
        if (col.indexOf(34) != -1) {
            return '\"' + col.replaceAll("\"", "\"\"") + '\"';
        }
        if (this.quoteAll || col.matches(".*\\s.*")) {
            return '\"' + col + '\"';
        }
        return col.trim();
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        CSVFile out = new CSVFile("t.csv", "blah", "blub");
        out.write(1, 2, " blah ", "\"blub\"");
        out.close();
    }
}

