/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javatools.administrative.Announce;
import javatools.administrative.D;
import javatools.filehandlers.FileLines;
import javatools.parsers.Char17;

public class HTMLReader
extends Reader {
    protected Reader in;
    protected long announceChars = -1L;
    public boolean skipSTYLE = true;
    protected String tagContent = null;
    protected String tag = null;

    public HTMLReader(Reader s) {
        this.in = s;
    }

    public HTMLReader(URL url) throws IOException {
        this(new InputStreamReader(url.openStream()));
    }

    public HTMLReader(File f) throws FileNotFoundException {
        this(new BufferedReader(new FileReader(f)));
    }

    public HTMLReader(File f, String message) throws FileNotFoundException {
        this(f);
        this.announceChars = 0L;
        Announce.progressStart(message, f.length());
    }

    public String readTextLine(int n) throws IOException {
        int c;
        StringBuilder l = new StringBuilder();
        while ((c = this.read()) != -1 && (c != 32 || l.length() < n)) {
            if (c == -2) continue;
            l.append((char)c);
        }
        if (c == -1 && l.length() == 0) {
            return null;
        }
        return l.toString();
    }

    public String getTagContent() {
        return this.tagContent;
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (this.announceChars != -1L) {
            Announce.progressAt(this.announceChars++);
        }
        switch (c) {
            case -1: {
                return -1;
            }
            case 60: {
                StringBuilder t = new StringBuilder();
                while ((c = this.in.read()) == 47 || c == 33 || c == 45 || Character.isLetterOrDigit(c)) {
                    t.append((char)c);
                }
                if (this.announceChars != -1L) {
                    Announce.progressAt(this.announceChars += (long)t.length());
                }
                if (t.length() > 0 && t.charAt(t.length() - 1) == '/') {
                    t.setLength(t.length() - 1);
                }
                this.tag = t.toString().toUpperCase();
                if (this.tag.equals("!--")) {
                    this.scrollTo("-->");
                    return this.read();
                }
                t.setLength(0);
                while (c != -1 && c != 62) {
                    c = this.in.read();
                    t.append((char)c);
                }
                if (this.announceChars != -1L) {
                    Announce.progressAt(this.announceChars += (long)t.length());
                }
                if (t.length() > 0) {
                    t.setLength(t.length() - 1);
                }
                this.tagContent = Char17.decodePercentage(Char17.decodeAmpersand(t.toString()));
                if (this.tag.equals("SCRIPT")) {
                    this.scrollToTag("/SCRIPT");
                    return this.read();
                }
                if (this.skipSTYLE && this.tag.equals("STYLE")) {
                    this.scrollToTag("/STYLE");
                    return this.read();
                }
                return -2;
            }
            case 38: {
                String a = "&";
                while (!Character.isWhitespace((char)(c = this.in.read())) && c != 59 && c != -1) {
                    a = a + (char)c;
                }
                c = Char17.decodeAmpersandChar(a);
                if (c == -1) {
                    c = 0;
                }
                if (this.announceChars != -1L) {
                    Announce.progressAt(this.announceChars += (long)a.length());
                }
                return c;
            }
        }
        return c;
    }

    public String readTaggedText(String t) throws IOException {
        int c;
        if (!this.scrollToTag(t)) {
            return null;
        }
        t = '/' + t.toUpperCase();
        StringBuilder result = new StringBuilder();
        while ((c = this.read()) != -1) {
            if (c == -2) {
                if (!t.equals(this.getTag())) continue;
                break;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    public StringBuilder text(String forTag) throws IOException {
        int c;
        StringBuilder result = new StringBuilder();
        while ((c = this.read()) != -1) {
            if (c == -2) {
                result.append(forTag);
                continue;
            }
            result.append((char)c);
        }
        return result;
    }

    public boolean scrollTo(String s) throws IOException {
        return FileLines.find(this.in, s) != -1;
    }

    public boolean scrollToTag(String s) throws IOException {
        int c;
        s = s.toUpperCase();
        do {
            if ((c = this.read()) != -1) continue;
            return false;
        } while (c != -2 || !s.equals(this.getTag()));
        return true;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        if (this.announceChars != -1L) {
            Announce.progressDone();
        }
        this.announceChars = -1L;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int numRead = 0;
        while (numRead < len) {
            int c = this.read();
            if (c == -1) {
                if (numRead > 0) {
                    return numRead;
                }
                return -1;
            }
            if (c == -2) continue;
            cbuf[off++] = (char)c;
            ++numRead;
        }
        return numRead;
    }

    public static void main(String[] argv) throws Exception {
        int c;
        D.p("Enter the name of an HTML-file and hit ENTER");
        HTMLReader r = new HTMLReader(new File(D.r()));
        while ((c = r.read()) != -1) {
            if (c == -2) {
                System.out.print(" TAG:" + r.getTag());
                continue;
            }
            System.out.print((char)c);
        }
        r.close();
    }
}

