/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;

public class MultiWriter
extends Writer {
    protected Collection<Writer> writers;

    public MultiWriter(Collection<Writer> writers) {
        this.writers = writers;
    }

    public MultiWriter(Writer ... writers) {
        this(Arrays.asList(writers));
    }

    @Override
    public void close() throws IOException {
        for (Writer w : this.writers) {
            w.close();
        }
    }

    @Override
    public void flush() throws IOException {
        for (Writer w : this.writers) {
            w.flush();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (Writer w : this.writers) {
            w.write(cbuf, off, len);
        }
    }

    @Override
    public void write(int c) throws IOException {
        for (Writer w : this.writers) {
            w.write(c);
        }
    }

    @Override
    public void write(String str) throws IOException {
        for (Writer w : this.writers) {
            w.write(str);
        }
    }
}

