/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javatools.filehandlers.UTF8Writer;

public class TSVWriter {
    private UTF8Writer writer = null;

    public TSVWriter(String path) throws IOException {
        this(new File(path));
    }

    public TSVWriter(File file) throws IOException {
        this.writer = new UTF8Writer(file);
    }

    public void write(String arg1, String relation, String arg2) throws IOException {
        this.writer.writeln(arg1 + "\t" + relation + "\t" + arg2);
    }

    public void write(String pattern, String method, String[] factResults) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < factResults.length; ++i) {
            sb.append(factResults[i]);
            if (i + 1 == factResults.length) continue;
            sb.append(";\t");
        }
        this.writer.writeln(pattern + "\t" + method + "\t" + sb.toString());
    }

    public void write(String ... values) throws IOException {
        this.write(Arrays.asList(values));
    }

    public void write(Collection<String> values) throws IOException {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (String value : values) {
            if (i == values.size()) {
                sb.append(value);
            } else {
                sb.append(value).append("\t");
            }
            ++i;
        }
        this.writer.writeln(sb.toString());
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

