/*
 * Decompiled with CFR 0.152.
 */
package javatools.filehandlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javatools.administrative.Announce;
import javatools.parsers.Char17;

public class UTF8Reader
extends Reader {
    protected InputStream in;
    protected long numBytesRead = 0L;
    protected boolean progressBar = false;

    public UTF8Reader(InputStream s) {
        this.in = s;
    }

    public UTF8Reader(URL url) throws IOException {
        this(url.openStream());
    }

    public UTF8Reader(File f) throws FileNotFoundException {
        this(new FileInputStream(f));
    }

    public UTF8Reader(File f, String message) throws FileNotFoundException {
        this(new FileInputStream(f));
        this.progressBar = true;
        Announce.progressStart(message, f.length());
    }

    public UTF8Reader(String f) throws FileNotFoundException {
        this(new File(f));
    }

    public UTF8Reader(String f, String message) throws FileNotFoundException {
        this(new File(f), message);
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        if (this.progressBar) {
            Announce.progressDone();
        }
        this.progressBar = false;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int numRead;
        if (this.in == null) {
            return -1;
        }
        for (numRead = 0; numRead < len; ++numRead) {
            int c = this.read();
            if (c == -1) {
                this.close();
                if (numRead > 0) {
                    return numRead;
                }
                return -1;
            }
            cbuf[off++] = (char)c;
        }
        return numRead;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        int c = this.in.read();
        if (c == -1) {
            this.close();
            return -1;
        }
        int len = Char17.Utf8Length((char)c);
        this.numBytesRead += (long)len;
        if (this.progressBar) {
            Announce.progressAt(this.numBytesRead);
        }
        if (len == 1) {
            return c;
        }
        String seq = "" + c;
        while (--len > 0) {
            seq = seq + (char)this.in.read();
        }
        return Char17.decodeUtf8(seq).charAt(0);
    }

    public long numBytesRead() {
        return this.numBytesRead;
    }

    public String readLine() throws IOException {
        if (this.in == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        block5: while (true) {
            int c = this.read();
            switch (c) {
                case -1: {
                    this.close();
                    break block5;
                }
                case 13: {
                    continue block5;
                }
                case 10: 
                case 12: 
                case 133: 
                case 8232: 
                case 8233: {
                    break block5;
                }
                default: {
                    result.append((char)c);
                    continue block5;
                }
            }
            break;
        }
        return result.toString();
    }

    public static void main(String[] args) throws IOException {
        int c;
        UTF8Reader f = new UTF8Reader(new File("blah.blb"));
        while ((c = ((Reader)f).read()) != -1) {
            System.out.print(Char17.normalize(c));
        }
        ((Reader)f).close();
    }
}

