/*
 * Decompiled with CFR 0.152.
 */
package javatools.parsers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javatools.datatypes.FinalMap;
import javatools.parsers.PositionTracker;

@Deprecated
public class Char {
    public static Char2StringFn defaultNormalizer = new Char2StringFn(){

        @Override
        public String apply(char c) {
            return UNKNOWN;
        }
    };
    public static String UNKNOWN = "[?]";
    public static Map<Character, String> charToAmpersand = new FinalMap<Character, String>(Character.valueOf('&'), "&amp;", Character.valueOf('\''), "&apos;", Character.valueOf('<'), "&lt;", Character.valueOf('>'), "&gt;", Character.valueOf('\"'), "&quot;");
    public static Map<Character, String> charToBackslash = new FinalMap<Character, String>(Character.valueOf('\\'), "\\\\", Character.valueOf('\n'), "\\n");
    public static Map<String, Character> ampersandMap = new FinalMap<String, Character>("nbsp", Character.valueOf('\u00a0'), "iexcl", Character.valueOf('\u00a1'), "cent", Character.valueOf('\u00a2'), "pound", Character.valueOf('\u00a3'), "curren", Character.valueOf('\u00a4'), "yen", Character.valueOf('\u00a5'), "brvbar", Character.valueOf('\u00a6'), "sect", Character.valueOf('\u00a7'), "uml", Character.valueOf('\u00a8'), "copy", Character.valueOf('\u00a9'), "ordf", Character.valueOf('\u00aa'), "laquo", Character.valueOf('\u00ab'), "not", Character.valueOf('\u00ac'), "shy", Character.valueOf('\u00ad'), "reg", Character.valueOf('\u00ae'), "macr", Character.valueOf('\u00af'), "deg", Character.valueOf('\u00b0'), "plusmn", Character.valueOf('\u00b1'), "sup2", Character.valueOf('\u00b2'), "sup3", Character.valueOf('\u00b3'), "acute", Character.valueOf('\u00b4'), "micro", Character.valueOf('\u00b5'), "para", Character.valueOf('\u00b6'), "middot", Character.valueOf('\u00b7'), "cedil", Character.valueOf('\u00b8'), "sup1", Character.valueOf('\u00b9'), "ordm", Character.valueOf('\u00ba'), "raquo", Character.valueOf('\u00bb'), "frac14", Character.valueOf('\u00bc'), "frac12", Character.valueOf('\u00bd'), "frac34", Character.valueOf('\u00be'), "iquest", Character.valueOf('\u00bf'), "Agrave", Character.valueOf('\u00c0'), "Aacute", Character.valueOf('\u00c1'), "Acirc", Character.valueOf('\u00c2'), "Atilde", Character.valueOf('\u00c3'), "Auml", Character.valueOf('\u00c4'), "Aring", Character.valueOf('\u00c5'), "AElig", Character.valueOf('\u00c6'), "Ccedil", Character.valueOf('\u00c7'), "Egrave", Character.valueOf('\u00c8'), "Eacute", Character.valueOf('\u00c9'), "Ecirc", Character.valueOf('\u00ca'), "Euml", Character.valueOf('\u00cb'), "Igrave", Character.valueOf('\u00cc'), "Iacute", Character.valueOf('\u00cd'), "Icirc", Character.valueOf('\u00ce'), "Iuml", Character.valueOf('\u00cf'), "ETH", Character.valueOf('\u00d0'), "Ntilde", Character.valueOf('\u00d1'), "Ograve", Character.valueOf('\u00d2'), "Oacute", Character.valueOf('\u00d3'), "Ocirc", Character.valueOf('\u00d4'), "Otilde", Character.valueOf('\u00d5'), "Ouml", Character.valueOf('\u00d6'), "times", Character.valueOf('\u00d7'), "Oslash", Character.valueOf('\u00d8'), "Ugrave", Character.valueOf('\u00d9'), "Uacute", Character.valueOf('\u00da'), "Ucirc", Character.valueOf('\u00db'), "Uuml", Character.valueOf('\u00dc'), "Yacute", Character.valueOf('\u00dd'), "THORN", Character.valueOf('\u00de'), "szlig", Character.valueOf('\u00df'), "agrave", Character.valueOf('\u00e0'), "aacute", Character.valueOf('\u00e1'), "acirc", Character.valueOf('\u00e2'), "atilde", Character.valueOf('\u00e3'), "auml", Character.valueOf('\u00e4'), "aring", Character.valueOf('\u00e5'), "aelig", Character.valueOf('\u00e6'), "ccedil", Character.valueOf('\u00e7'), "egrave", Character.valueOf('\u00e8'), "eacute", Character.valueOf('\u00e9'), "ecirc", Character.valueOf('\u00ea'), "euml", Character.valueOf('\u00eb'), "igrave", Character.valueOf('\u00ec'), "iacute", Character.valueOf('\u00ed'), "icirc", Character.valueOf('\u00ee'), "iuml", Character.valueOf('\u00ef'), "eth", Character.valueOf('\u00f0'), "ntilde", Character.valueOf('\u00f1'), "ograve", Character.valueOf('\u00f2'), "oacute", Character.valueOf('\u00f3'), "ocirc", Character.valueOf('\u00f4'), "otilde", Character.valueOf('\u00f5'), "ouml", Character.valueOf('\u00f6'), "divide", Character.valueOf('\u00f7'), "oslash", Character.valueOf('\u00f8'), "ugrave", Character.valueOf('\u00f9'), "uacute", Character.valueOf('\u00fa'), "ucirc", Character.valueOf('\u00fb'), "uuml", Character.valueOf('\u00fc'), "yacute", Character.valueOf('\u00fd'), "thorn", Character.valueOf('\u00fe'), "yuml", Character.valueOf('\u00ff'), "fnof", Character.valueOf('\u0192'), "Alpha", Character.valueOf('\u0391'), "Beta", Character.valueOf('\u0392'), "Gamma", Character.valueOf('\u0393'), "Delta", Character.valueOf('\u0394'), "Epsilon", Character.valueOf('\u0395'), "Zeta", Character.valueOf('\u0396'), "Eta", Character.valueOf('\u0397'), "Theta", Character.valueOf('\u0398'), "Iota", Character.valueOf('\u0399'), "Kappa", Character.valueOf('\u039a'), "Lambda", Character.valueOf('\u039b'), "Mu", Character.valueOf('\u039c'), "Nu", Character.valueOf('\u039d'), "Xi", Character.valueOf('\u039e'), "Omicron", Character.valueOf('\u039f'), "Pi", Character.valueOf('\u03a0'), "Rho", Character.valueOf('\u03a1'), "Sigma", Character.valueOf('\u03a3'), "Tau", Character.valueOf('\u03a4'), "Upsilon", Character.valueOf('\u03a5'), "Phi", Character.valueOf('\u03a6'), "Chi", Character.valueOf('\u03a7'), "Psi", Character.valueOf('\u03a8'), "Omega", Character.valueOf('\u03a9'), "alpha", Character.valueOf('\u03b1'), "beta", Character.valueOf('\u03b2'), "gamma", Character.valueOf('\u03b3'), "delta", Character.valueOf('\u03b4'), "epsilon", Character.valueOf('\u03b5'), "zeta", Character.valueOf('\u03b6'), "eta", Character.valueOf('\u03b7'), "theta", Character.valueOf('\u03b8'), "iota", Character.valueOf('\u03b9'), "kappa", Character.valueOf('\u03ba'), "lambda", Character.valueOf('\u03bb'), "mu", Character.valueOf('\u03bc'), "nu", Character.valueOf('\u03bd'), "xi", Character.valueOf('\u03be'), "omicron", Character.valueOf('\u03bf'), "pi", Character.valueOf('\u03c0'), "rho", Character.valueOf('\u03c1'), "sigmaf", Character.valueOf('\u03c2'), "sigma", Character.valueOf('\u03c3'), "tau", Character.valueOf('\u03c4'), "upsilon", Character.valueOf('\u03c5'), "phi", Character.valueOf('\u03c6'), "chi", Character.valueOf('\u03c7'), "psi", Character.valueOf('\u03c8'), "omega", Character.valueOf('\u03c9'), "thetasym", Character.valueOf('\u03d1'), "upsih", Character.valueOf('\u03d2'), "piv", Character.valueOf('\u03d6'), "bull", Character.valueOf('\u2022'), "hellip", Character.valueOf('\u2026'), "prime", Character.valueOf('\u2032'), "Prime", Character.valueOf('\u2033'), "oline", Character.valueOf('\u203e'), "frasl", Character.valueOf('\u2044'), "weierp", Character.valueOf('\u2118'), "image", Character.valueOf('\u2111'), "real", Character.valueOf('\u211c'), "trade", Character.valueOf('\u2122'), "alefsym", Character.valueOf('\u2135'), "larr", Character.valueOf('\u2190'), "uarr", Character.valueOf('\u2191'), "rarr", Character.valueOf('\u2192'), "darr", Character.valueOf('\u2193'), "harr", Character.valueOf('\u2194'), "crarr", Character.valueOf('\u21b5'), "lArr", Character.valueOf('\u21d0'), "uArr", Character.valueOf('\u21d1'), "rArr", Character.valueOf('\u21d2'), "dArr", Character.valueOf('\u21d3'), "hArr", Character.valueOf('\u21d4'), "forall", Character.valueOf('\u2200'), "part", Character.valueOf('\u2202'), "exist", Character.valueOf('\u2203'), "empty", Character.valueOf('\u2205'), "nabla", Character.valueOf('\u2207'), "isin", Character.valueOf('\u2208'), "notin", Character.valueOf('\u2209'), "ni", Character.valueOf('\u220b'), "prod", Character.valueOf('\u220f'), "sum", Character.valueOf('\u2211'), "minus", Character.valueOf('\u2212'), "lowast", Character.valueOf('\u2217'), "radic", Character.valueOf('\u221a'), "prop", Character.valueOf('\u221d'), "infin", Character.valueOf('\u221e'), "ang", Character.valueOf('\u2220'), "and", Character.valueOf('\u2227'), "or", Character.valueOf('\u2228'), "cap", Character.valueOf('\u2229'), "cup", Character.valueOf('\u222a'), "int", Character.valueOf('\u222b'), "there4", Character.valueOf('\u2234'), "sim", Character.valueOf('\u223c'), "cong", Character.valueOf('\u2245'), "asymp", Character.valueOf('\u2248'), "ne", Character.valueOf('\u2260'), "equiv", Character.valueOf('\u2261'), "le", Character.valueOf('\u2264'), "ge", Character.valueOf('\u2265'), "sub", Character.valueOf('\u2282'), "sup", Character.valueOf('\u2283'), "nsub", Character.valueOf('\u2284'), "sube", Character.valueOf('\u2286'), "supe", Character.valueOf('\u2287'), "oplus", Character.valueOf('\u2295'), "otimes", Character.valueOf('\u2297'), "perp", Character.valueOf('\u22a5'), "sdot", Character.valueOf('\u22c5'), "lceil", Character.valueOf('\u2308'), "rceil", Character.valueOf('\u2309'), "lfloor", Character.valueOf('\u230a'), "rfloor", Character.valueOf('\u230b'), "lang", Character.valueOf('\u2329'), "rang", Character.valueOf('\u232a'), "loz", Character.valueOf('\u25ca'), "spades", Character.valueOf('\u2660'), "clubs", Character.valueOf('\u2663'), "hearts", Character.valueOf('\u2665'), "diams", Character.valueOf('\u2666'), "quot", Character.valueOf('\"'), "amp", Character.valueOf('&'), "lt", Character.valueOf('<'), "gt", Character.valueOf('>'), "OElig", Character.valueOf('\u0152'), "oelig", Character.valueOf('\u0153'), "Scaron", Character.valueOf('\u0160'), "scaron", Character.valueOf('\u0161'), "Yuml", Character.valueOf('\u0178'), "circ", Character.valueOf('\u02c6'), "tilde", Character.valueOf('\u02dc'), "ensp", Character.valueOf('\u2002'), "emsp", Character.valueOf('\u2003'), "thinsp", Character.valueOf('\u2009'), "zwnj", Character.valueOf('\u200c'), "zwj", Character.valueOf('\u200d'), "lrm", Character.valueOf('\u200e'), "rlm", Character.valueOf('\u200f'), "ndash", Character.valueOf('\u2013'), "mdash", Character.valueOf('\u2014'), "lsquo", Character.valueOf('\u2018'), "rsquo", Character.valueOf('\u2019'), "sbquo", Character.valueOf('\u201a'), "ldquo", Character.valueOf('\u201c'), "rdquo", Character.valueOf('\u201d'), "bdquo", Character.valueOf('\u201e'), "dagger", Character.valueOf('\u2020'), "Dagger", Character.valueOf('\u2021'), "permil", Character.valueOf('\u2030'), "lsaquo", Character.valueOf('\u2039'), "rsaquo", Character.valueOf('\u203a'), "euro", Character.valueOf('\u20ac'), "apos", Character.valueOf('\''));
    public static Map<Character, String> normalizeMap = new TreeMap<Character, String>();

    public static String normalize(int c) {
        if (c == -1) {
            return null;
        }
        if (c >= 32 && c <= 128) {
            return "" + (char)c;
        }
        boolean u = Character.isUpperCase(c);
        char cu = (char)Character.toUpperCase(c);
        if (normalizeMap.get(Character.valueOf(cu)) != null) {
            return u ? normalizeMap.get(Character.valueOf(cu)) : normalizeMap.get(Character.valueOf(cu)).toLowerCase();
        }
        if (c < 32) {
            return "";
        }
        if (cu >= '\u00c0' && cu <= '\u00c5') {
            return u ? "A" : "a";
        }
        if (cu >= '\u00c8' && cu <= '\u00cb') {
            return u ? "E" : "e";
        }
        if (cu >= '\u00cc' && cu <= '\u00cf') {
            return u ? "I" : "i";
        }
        if (cu >= '\u00d2' && cu <= '\u00d8') {
            return u ? "O" : "o";
        }
        if (cu >= '\u0080' && cu <= '\u00a0') {
            return " ";
        }
        if (cu >= '\u0100' && cu <= '\u0105') {
            return u ? "A" : "a";
        }
        if (cu >= '\u0106' && cu <= '\u010d') {
            return u ? "C" : "c";
        }
        if (cu >= '\u010e' && cu <= '\u0111') {
            return u ? "D" : "d";
        }
        if (cu >= '\u0112' && cu <= '\u011b') {
            return u ? "E" : "e";
        }
        if (cu >= '\u011c' && cu <= '\u0123') {
            return u ? "G" : "g";
        }
        if (cu >= '\u0124' && cu <= '\u0127') {
            return u ? "H" : "h";
        }
        if (cu >= '\u0128' && cu <= '\u0131') {
            return u ? "I" : "i";
        }
        if (cu >= '\u0136' && cu <= '\u0138') {
            return u ? "K" : "k";
        }
        if (cu >= '\u0139' && cu <= '\u0142') {
            return u ? "L" : "l";
        }
        if (cu >= '\u0143' && cu <= '\u014b') {
            return u ? "N" : "n";
        }
        if (cu >= '\u014c' && cu <= '\u014f') {
            return u ? "O" : "o";
        }
        if (cu >= '\u0150' && cu <= '\u0153') {
            return u ? "Oe" : "oe";
        }
        if (cu >= '\u0156' && cu <= '\u0159') {
            return u ? "R" : "r";
        }
        if (cu >= '\u015a' && cu <= '\u0161') {
            return u ? "S" : "s";
        }
        if (cu >= '\u0161' && cu <= '\u0167') {
            return u ? "T" : "t";
        }
        if (cu >= '\u0176' && cu <= '\u0178') {
            return u ? "Y" : "y";
        }
        if (cu >= '\u0179' && cu <= '\u017e') {
            return u ? "Z" : "z";
        }
        if (cu >= '\u2000' && cu <= '\u200a') {
            return " ";
        }
        if (cu >= '\u200b' && cu <= '\u200f') {
            return "";
        }
        if (cu >= '\u2010' && cu <= '\u2015') {
            return "--";
        }
        if (cu >= '\u2018' && cu <= '\u201b') {
            return "'";
        }
        if (cu >= '\u201c' && cu <= '\u201f') {
            return "\"";
        }
        if (cu >= '\u2029' && cu <= '\u202f') {
            return " ";
        }
        if (cu >= '\u203e' && cu <= '\u2040') {
            return "-";
        }
        if (cu >= '\u2056' && cu <= '\u205e') {
            return ".";
        }
        return defaultNormalizer.apply((char)c);
    }

    public static char eatPercentage(String a, int[] n) {
        char c;
        if (!a.startsWith("%") || a.length() < 3) {
            n[0] = 0;
            return '\u0000';
        }
        try {
            c = (char)Integer.parseInt(a.substring(1, 3), 16);
        }
        catch (Exception e) {
            n[0] = -1;
            return '\u0000';
        }
        int len = Char.Utf8Length(c);
        n[0] = 3;
        if (len <= 1) {
            return c;
        }
        String dec = "" + c;
        for (int i = 1; i < len; ++i) {
            try {
                dec = dec + (char)Integer.parseInt(a.substring(1 + i * 3, 3 + i * 3), 16);
                continue;
            }
            catch (Exception e) {
                return c;
            }
        }
        int[] eatLength = new int[1];
        char utf8 = Char.eatUtf8(dec, eatLength);
        if (eatLength[0] != len) {
            return c;
        }
        n[0] = len * 3;
        return utf8;
    }

    public static char eatAmpersand(List<Character> a, int[] n) {
        n[0] = 0;
        if (a.get(0).charValue() != '&') {
            return '\u0000';
        }
        while (n[0] < a.size() && !Character.isSpaceChar(a.get(n[0]).charValue()) && a.get(n[0]).charValue() != ';') {
            n[0] = n[0] + 1;
        }
        if (n[0] <= 1) {
            n[0] = -1;
            return '\u0000';
        }
        List<Character> sublist = a.subList(1, n[0]);
        StringBuilder sb = new StringBuilder();
        for (Character c : sublist) {
            sb.append(c);
        }
        String b = sb.toString();
        if (n[0] < a.size() && a.get(n[0]).charValue() == ';') {
            n[0] = n[0] + 1;
        }
        if (b.startsWith("#x")) {
            try {
                return (char)Integer.parseInt(b.substring(2), 16);
            }
            catch (Exception e) {
                n[0] = -1;
                return '\u0000';
            }
        }
        if (b.startsWith("#")) {
            try {
                return (char)Integer.parseInt(b.substring(1));
            }
            catch (Exception e) {
                n[0] = -1;
                return '\u0000';
            }
        }
        if (ampersandMap.get(b) != null) {
            return ampersandMap.get(b).charValue();
        }
        if (ampersandMap.get(b.toLowerCase()) != null) {
            return ampersandMap.get(b.toLowerCase()).charValue();
        }
        n[0] = -1;
        return '\u0000';
    }

    public static char eatAmpersand(String a, int[] n) {
        n[0] = 0;
        if (!a.startsWith("&")) {
            return '\u0000';
        }
        while (n[0] < a.length() && !Character.isSpaceChar(a.charAt(n[0])) && a.charAt(n[0]) != ';') {
            n[0] = n[0] + 1;
        }
        if (n[0] <= 1) {
            n[0] = -1;
            return '\u0000';
        }
        if (n[0] < a.length() && a.charAt(n[0]) == ';') {
            a = a.substring(1, n[0]);
            n[0] = n[0] + 1;
        } else {
            a = a.substring(1, n[0]);
        }
        if (a.startsWith("#x")) {
            try {
                return (char)Integer.parseInt(a.substring(2), 16);
            }
            catch (Exception e) {
                n[0] = -1;
                return '\u0000';
            }
        }
        if (a.startsWith("#")) {
            try {
                return (char)Integer.parseInt(a.substring(1));
            }
            catch (Exception e) {
                n[0] = -1;
                return '\u0000';
            }
        }
        if (ampersandMap.get(a) != null) {
            return ampersandMap.get(a).charValue();
        }
        if (ampersandMap.get(a.toLowerCase()) != null) {
            return ampersandMap.get(a.toLowerCase()).charValue();
        }
        n[0] = -1;
        return '\u0000';
    }

    public static int Utf8Length(char c) {
        if ((c & 0x80) == 0) {
            return 1;
        }
        if ((c & 0xE0) == 192) {
            return 2;
        }
        if ((c & 0xF0) == 224) {
            return 3;
        }
        if ((c & 0xF8) == 240) {
            return 4;
        }
        return -1;
    }

    public static char eatUtf8(String a, int[] n) {
        if (a.length() == 0) {
            n[0] = 0;
            return '\u0000';
        }
        n[0] = Char.Utf8Length(a.charAt(0));
        if (a.length() >= n[0]) {
            switch (n[0]) {
                case 1: {
                    return a.charAt(0);
                }
                case 2: {
                    if ((a.charAt(1) & 0xC0) != 128) break;
                    return (char)(((a.charAt(0) & 0x1F) << 6) + (a.charAt(1) & 0x3F));
                }
                case 3: {
                    if ((a.charAt(1) & 0xC0) != 128 || (a.charAt(2) & 0xC0) != 128) break;
                    return (char)(((a.charAt(0) & 0xF) << 12) + ((a.charAt(1) & 0x3F) << 6) + (a.charAt(2) & 0x3F));
                }
                case 4: {
                    if ((a.charAt(1) & 0xC0) != 128 || (a.charAt(2) & 0xC0) != 128 || (a.charAt(3) & 0xC0) != 128) break;
                    return (char)(((a.charAt(0) & 7) << 18) + ((a.charAt(1) & 0x3F) << 12) + ((a.charAt(2) & 0x3F) << 6) + (a.charAt(3) & 0x3F));
                }
            }
        }
        n[0] = -1;
        return '\u0000';
    }

    public static String decodeUTF8(String s) {
        StringBuilder result = new StringBuilder();
        int[] eatLength = new int[1];
        while (s.length() != 0) {
            char c = Char.eatUtf8(s, eatLength);
            if (eatLength[0] != -1) {
                result.append(c);
                s = s.substring(eatLength[0]);
                continue;
            }
            result.append(s.charAt(0));
            s = s.substring(1);
        }
        return result.toString();
    }

    public static String decodePercentage(String s) {
        StringBuilder result = new StringBuilder();
        int[] eatLength = new int[1];
        while (s.length() != 0) {
            char c = Char.eatPercentage(s, eatLength);
            if (eatLength[0] > 1) {
                result.append(c);
                s = s.substring(eatLength[0]);
                continue;
            }
            result.append(s.charAt(0));
            s = s.substring(1);
        }
        return result.toString();
    }

    public static String decodeAmpersand_UNKNOWN(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s.length());
        while (s != null && s.length() != 0) {
            int i = s.indexOf("&");
            if (i == -1) {
                sb.append(s);
                s = null;
                continue;
            }
            boolean space = false;
            boolean end = false;
            sb.append(s.substring(0, i));
            s = s.substring(i);
            int j1 = s.indexOf(";");
            int j2 = s.indexOf(" ");
            int j = -1;
            if (j1 == -1 || j2 == -1) {
                if (j1 == -1 && j2 == -1) {
                    end = true;
                    j = s.length();
                } else if (j1 == -1) {
                    j = j2;
                } else if (j2 == -1) {
                    j = j1;
                }
            } else if (j1 < j2) {
                j = j1;
            } else if (j1 > j2) {
                j = j2;
                space = true;
            }
            String a = s.substring(1, j);
            if (ampersandMap.get(a) != null) {
                sb.append(ampersandMap.get(a));
                if (space) {
                    sb.append(' ');
                }
            } else if (a.startsWith("#")) {
                try {
                    sb.append((char)Integer.parseInt(a.substring(1)));
                }
                catch (Exception e) {
                    sb.append(a);
                }
                if (space) {
                    sb.append(' ');
                }
            } else if (end) {
                sb.append(s.substring(0, j));
            } else {
                sb.append(s.substring(0, j + 1));
            }
            if (end) {
                s = s.substring(j);
                continue;
            }
            s = s.substring(j + 1);
        }
        return sb.toString();
    }

    public static String decodeAmpersand(String s, PositionTracker posTracker) {
        if (s == null) {
            return null;
        }
        int pos = 0;
        StringBuffer sb = new StringBuffer(s.length());
        while (s != null && s.length() != 0) {
            int i = s.indexOf("&");
            if (i == -1) {
                sb.append(s);
                s = null;
                continue;
            }
            boolean space = false;
            boolean end = false;
            sb.append(s.substring(0, i));
            s = s.substring(i);
            pos += i;
            int j1 = s.indexOf(";");
            int j2 = s.indexOf(" ");
            int j = -1;
            if (j1 == -1 || j2 == -1) {
                if (j1 == -1 && j2 == -1) {
                    end = true;
                    j = s.length();
                } else if (j1 == -1) {
                    j = j2;
                } else if (j2 == -1) {
                    j = j1;
                }
            } else if (j1 < j2) {
                j = j1;
            } else if (j1 > j2) {
                j = j2;
                space = true;
            }
            pos += j + 1;
            String a = s.substring(1, j);
            if (ampersandMap.get(a) != null) {
                sb.append(ampersandMap.get(a));
                int difference = 1 - (j + 1);
                if (space) {
                    sb.append(' ');
                    ++difference;
                }
                posTracker.addPositionChange(pos, difference);
            } else if (end) {
                sb.append(s.substring(0, j));
            } else {
                sb.append(s.substring(0, j + 1));
            }
            if (end) {
                s = s.substring(j);
                continue;
            }
            s = s.substring(j + 1);
        }
        posTracker.closeRun();
        return sb.toString();
    }

    public static String decodeAmpersand(String s) {
        if (s == null || s.indexOf(38) == -1) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        int[] eatLength = new int[1];
        LinkedList<Character> chars = new LinkedList<Character>();
        for (int i = 0; i < s.length(); ++i) {
            chars.add(Character.valueOf(s.charAt(i)));
        }
        while (chars.size() != 0) {
            char c = Char.eatAmpersand(chars, eatLength);
            if (eatLength[0] > 1) {
                result.append(c);
                for (int i = 0; i < eatLength[0]; ++i) {
                    chars.remove(0);
                }
                continue;
            }
            result.append(chars.get(0));
            chars.remove(0);
        }
        return result.toString();
    }

    public static String decodeBackslash(String s) {
        if (s == null || s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        int[] eatLength = new int[1];
        while (s.length() != 0) {
            char c = Char.eatBackslash(s, eatLength);
            if (eatLength[0] > 1) {
                result.append(c);
                s = s.substring(eatLength[0]);
                continue;
            }
            result.append(s.charAt(0));
            s = s.substring(1);
        }
        return result.toString();
    }

    public static String encodeBackslash(CharSequence s, Legal legal) {
        StringBuilder b = new StringBuilder((int)((double)s.length() * 1.5));
        for (int i = 0; i < s.length(); ++i) {
            if (legal.isLegal(s.charAt(i))) {
                b.append(s.charAt(i));
                continue;
            }
            if (charToBackslash.containsKey(Character.valueOf(s.charAt(i)))) {
                b.append(charToBackslash.get(Character.valueOf(s.charAt(i))));
                continue;
            }
            b.append("\\u");
            String hex = Integer.toHexString(s.charAt(i));
            for (int j = 0; j < 4 - hex.length(); ++j) {
                b.append('0');
            }
            b.append(hex);
        }
        return b.toString();
    }

    public static char eatBackslash(String a, int[] n) {
        if (!a.startsWith("\\")) {
            n[0] = 0;
            return '\u0000';
        }
        if (a.startsWith("\\u")) {
            try {
                n[0] = 6;
                return (char)Integer.parseInt(a.substring(2, 6), 16);
            }
            catch (Exception e) {
                n[0] = -1;
                return '\u0000';
            }
        }
        if (a.startsWith("\\uu")) {
            try {
                n[0] = 7;
                return (char)Integer.parseInt(a.substring(3, 7), 16);
            }
            catch (Exception e) {
                n[0] = -1;
                return '\u0000';
            }
        }
        if (a.startsWith("\\b")) {
            n[0] = 2;
            return '\b';
        }
        if (a.startsWith("\\t")) {
            n[0] = 2;
            return '\t';
        }
        if (a.startsWith("\\n")) {
            n[0] = 2;
            return '\n';
        }
        if (a.startsWith("\\f")) {
            n[0] = 2;
            return '\f';
        }
        if (a.startsWith("\\r")) {
            n[0] = 2;
            return '\r';
        }
        if (a.startsWith("\\\\")) {
            n[0] = 2;
            return '\\';
        }
        if (a.startsWith("\\\"")) {
            n[0] = 2;
            return '\"';
        }
        if (a.startsWith("\\'")) {
            n[0] = 2;
            return '\'';
        }
        n[0] = 1;
        while (n[0] < a.length() && a.charAt(n[0]) >= '0' && a.charAt(n[0]) <= '8') {
            n[0] = n[0] + 1;
        }
        if (n[0] == 1) {
            n[0] = 0;
            return '\u0000';
        }
        try {
            return (char)Integer.parseInt(a.substring(1, n[0]), 8);
        }
        catch (Exception exception) {
            n[0] = -1;
            return '\u0000';
        }
    }

    public static String decode(String s) {
        StringBuilder b = new StringBuilder();
        int[] eatLength = new int[1];
        while (s.length() > 0) {
            char c = Char.eatPercentage(s, eatLength);
            if (eatLength[0] <= 0) {
                c = Char.eatAmpersand(s, eatLength);
                if (eatLength[0] <= 0) {
                    c = Char.eatBackslash(s, eatLength);
                    if (eatLength[0] <= 0) {
                        c = Char.eatUtf8(s, eatLength);
                        if (eatLength[0] <= 0) {
                            c = s.charAt(0);
                            eatLength[0] = 1;
                        }
                    }
                }
            }
            b.append(c);
            s = s.substring(eatLength[0]);
        }
        return b.toString();
    }

    public static String encodeUTF8(int c) {
        if (c <= 127) {
            return "" + (char)c;
        }
        if (c <= 2047) {
            return "" + (char)(192 + (c >> 6 & 0x1F)) + (char)(128 + (c & 0x3F));
        }
        if (c <= 65535) {
            return "" + (char)(224 + (c >> 12 & 0xF)) + (char)(128 + (c >> 6 & 0x3F)) + (char)(128 + (c & 0x3F));
        }
        return "" + c;
    }

    public static String encodeBackslash(char c) {
        if (Char.isAlphanumeric(c) || c == ' ') {
            return "" + c;
        }
        String hex = Integer.toHexString(c);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        return "\\u" + hex;
    }

    public static String encodeBackslashToAlphanumeric(char c) {
        if (Char.isAlphanumeric(c) || c == '_') {
            return "" + c;
        }
        String hex = Integer.toHexString(c);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        return "\\u" + hex;
    }

    public static String encodeBackslashToASCII(char c) {
        if (c >= ' ' && c < '\u0080' && c != '\\' && c != '\"') {
            return "" + c;
        }
        String hex = Integer.toHexString(c);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        return "\\u" + hex;
    }

    public static String encodeAmpersand(char c) {
        String s = charToAmpersand.get(Character.valueOf(c));
        if (null != s) {
            return s;
        }
        if (c < '\u0080' && c >= ' ') {
            return "" + c;
        }
        return "&#" + c + ";";
    }

    public static String encodeAmpersandToAlphanumeric(char c) {
        if (Char.isAlphanumeric(c) || c == '_') {
            return "" + c;
        }
        return "&#" + c + ";";
    }

    public static String encodePercentage(char c) {
        if (Char.isAlphanumeric(c)) {
            return "" + c;
        }
        if (c < '\u0010') {
            return "%0" + Integer.toHexString(c).toUpperCase();
        }
        if (c < '\u0080') {
            return "%" + Integer.toHexString(c).toUpperCase();
        }
        String s = Char.encodeUTF8(c);
        String result = "";
        for (int i = 0; i < s.length(); ++i) {
            result = result + "%" + Integer.toHexString(s.charAt(i)).toUpperCase();
        }
        return result;
    }

    public static String encodeXmlAttribute(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return str;
        }
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '<') {
                encoded.append("&lt;");
                continue;
            }
            if (c == '\"') {
                encoded.append("&quot;");
                continue;
            }
            if (c == '>') {
                encoded.append("&gt;");
                continue;
            }
            if (c == '\'') {
                encoded.append("&apos;");
                continue;
            }
            if (c == '&') {
                encoded.append("&amp;");
                continue;
            }
            encoded.append(c);
        }
        return encoded.toString();
    }

    public static boolean in(char c, char a, char b) {
        return c >= a && c <= b;
    }

    public static boolean in(char c, String s) {
        return s.indexOf(c) != -1;
    }

    public static boolean isAlphanumeric(char c) {
        return Char.in(c, 'a', 'z') || Char.in(c, 'A', 'Z') || Char.in(c, '0', '9');
    }

    public static boolean isReserved(char c) {
        return Char.isSubDelim(c) || Char.isGenDelim(c);
    }

    public static boolean isUnreserved(char c) {
        return Char.isAlphanumeric(c) || Char.in(c, "-._~");
    }

    public static boolean isEscaped(String s) {
        return s.matches("%[0-9A-Fa-f]{2}");
    }

    public static boolean isSubDelim(char c) {
        return Char.in(c, "!$&'()*+,=");
    }

    public static boolean isGenDelim(char c) {
        return Char.in(c, ":/?#[]@");
    }

    public static boolean isPchar(char c) {
        return Char.isUnreserved(c) || Char.isSubDelim(c) || Char.in(c, "@");
    }

    public static String encodeURIPathComponent(char c) {
        if (Char.isPchar(c)) {
            return "" + c;
        }
        return Char.encodePercentage(c);
    }

    public static String encodeURIPathComponent(String s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            result.append(Char.encodeURIPathComponent(s.charAt(i)));
        }
        return result.toString();
    }

    public static String encodeURIPathComponentXML(String s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '&') {
                result.append(Char.encodePercentage(s.charAt(i)));
                continue;
            }
            if (s.charAt(i) == '\"') {
                result.append(Char.encodePercentage(s.charAt(i)));
                continue;
            }
            result.append(Char.encodeURIPathComponent(s.charAt(i)));
        }
        return result.toString();
    }

    public static String decodeURIPathComponent(String s) {
        return Char.decodePercentage(s);
    }

    public static String encodeUTF8(String c) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < c.length(); ++i) {
            r.append(Char.encodeUTF8(c.charAt(i)));
        }
        return r.toString();
    }

    public static String encodeBackslash(String c) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < c.length(); ++i) {
            r.append(Char.encodeBackslash(c.charAt(i)));
        }
        return r.toString();
    }

    public static String encodeBackslashToAlphanumeric(String c) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < c.length(); ++i) {
            r.append(Char.encodeBackslashToAlphanumeric(c.charAt(i)));
        }
        return r.toString();
    }

    public static String encodeBackslashToASCII(String c) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < c.length(); ++i) {
            r.append(Char.encodeBackslashToASCII(c.charAt(i)));
        }
        return r.toString();
    }

    public static String encodeAmpersand(String c) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < c.length(); ++i) {
            r.append(Char.encodeAmpersand(c.charAt(i)));
        }
        return r.toString();
    }

    public static String encodeAmpersandToAlphanumeric(String c) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < c.length(); ++i) {
            r.append(Char.encodeAmpersandToAlphanumeric(c.charAt(i)));
        }
        return r.toString();
    }

    public static String encodePercentage(String c) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < c.length(); ++i) {
            r.append(Char.encodePercentage(c.charAt(i)));
        }
        return r.toString();
    }

    public static String decodeAndNormalize(String s) {
        return Char.normalize(Char.decode(s));
    }

    public static String normalize(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            b.append(Char.normalize(s.charAt(i)));
        }
        return b.toString();
    }

    public static char last(CharSequence s) {
        return s.length() == 0 ? (char)'\u0000' : s.charAt(s.length() - 1);
    }

    public static String cutLast(String s) {
        return s.length() == 0 ? "" : s.substring(0, s.length() - 1);
    }

    public static StringBuilder cutLast(StringBuilder s) {
        s.setLength(s.length() - 1);
        return s;
    }

    public static String toHTML(String s) {
        return Char.encodeAmpersand(s).replace("&#10;", "<BR>");
    }

    public static String hexAll(String s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            result.append(Integer.toHexString(s.charAt(i)).toUpperCase()).append(' ');
        }
        return result.toString();
    }

    public static String encodeHex(String s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Char.isAlphanumeric(c)) {
                result.append(c);
                continue;
            }
            result.append(Integer.toHexString(s.charAt(i)).toUpperCase());
        }
        return result.toString();
    }

    public static String upCaseFirst(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String lowCaseFirst(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static CharSequence truncate(CharSequence s, int len) {
        if (s.length() == len) {
            return s;
        }
        if (s.length() > len) {
            return s.subSequence(0, len);
        }
        StringBuilder result = new StringBuilder(s);
        while (result.length() < len) {
            result.append(' ');
        }
        return result;
    }

    public static String capitalize(String s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            c = i == 0 || i > 0 && !Character.isLetterOrDigit(s.charAt(i - 1)) ? Character.toUpperCase(c) : Character.toLowerCase(c);
            result.append(c);
        }
        return result.toString();
    }

    public static boolean endsWith(CharSequence s, String end) {
        return s.length() >= end.length() && s.subSequence(s.length() - end.length(), s.length()).equals(end);
    }

    public static void main(String[] argv) throws Exception {
        System.out.println("Enter a string with HTML ampersand codes, umlauts and/or UTF-8 codes and hit ENTER.");
        System.out.println("Press CTRL+C to abort");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String s = in.readLine();
            s = Char.decode(s);
            System.out.println("Decoded: " + s);
            System.out.println("Normalized: " + Char.normalize(s));
            System.out.println("As UTF8: " + Char.encodeUTF8(s));
            System.out.println("As percentage: " + Char.encodePercentage(s));
            System.out.println("As backslash: " + Char.encodeBackslash(s));
            System.out.println("As ampersand: " + Char.encodeAmpersand(s));
            System.out.println("As URI component: " + Char.encodeURIPathComponent(s));
        }
    }

    static {
        Object[] o = new Object[]{Character.valueOf('\u0007'), "BEEP", Character.valueOf('\t'), " ", Character.valueOf('\n'), "\n", Character.valueOf('\u00a0'), " ", Character.valueOf('\u00a1'), "!", Character.valueOf('\u00a2'), "cent", Character.valueOf('\u00a3'), "pound", Character.valueOf('\u00a4'), "currency", Character.valueOf('\u00a5'), "yen", Character.valueOf('\u00a6'), "|", Character.valueOf('\u00a7'), "/", Character.valueOf('\u00a9'), "(c)", Character.valueOf('\u00aa'), "^a", Character.valueOf('\u00ab'), "\"", Character.valueOf('\u00ac'), "~", Character.valueOf('\u00ad'), "", Character.valueOf('\u00ae'), "(R)", Character.valueOf('\u00b0'), "degree", Character.valueOf('\u00b1'), "+/-", Character.valueOf('\u00b2'), "^2", Character.valueOf('\u00b3'), "^3", Character.valueOf('\u00b4'), "'", Character.valueOf('\u00b5'), "mu", Character.valueOf('\u00b6'), "P", Character.valueOf('\u00b7'), ".", Character.valueOf('\u00b8'), ",", Character.valueOf('\u00b9'), "^1", Character.valueOf('\u00ba'), "^o", Character.valueOf('\u00bb'), "\"", Character.valueOf('\u00bc'), "1/4", Character.valueOf('\u00bd'), "1/2", Character.valueOf('\u00be'), "3/4", Character.valueOf('\u00bf'), "?", Character.valueOf('\u00c4'), "Ae", Character.valueOf('\u00d6'), "Oe", Character.valueOf('\u00dc'), "Ue", Character.valueOf('\u00df'), "ss", Character.valueOf('\u00c6'), "Ae", Character.valueOf('\u00c7'), "C", Character.valueOf('\u00d0'), "D", Character.valueOf('\u00d1'), "N", Character.valueOf('\u00d7'), "x", Character.valueOf('\u00dd'), "Y", Character.valueOf('\u00de'), "b", Character.valueOf('\u00f7'), "/", Character.valueOf('\u00ff'), "y", Character.valueOf('\u0132'), "IJ", Character.valueOf('\u0134'), "J", Character.valueOf('\u0170'), "Ue", Character.valueOf('\u0174'), "W", Character.valueOf('\u017f'), "f", Character.valueOf('\u0374'), "'", Character.valueOf('\u0375'), ",", Character.valueOf('\u037a'), ",", Character.valueOf('\u037e'), ";", Character.valueOf('\u0384'), "'", Character.valueOf('\u0385'), "'", Character.valueOf('\u0386'), "A", Character.valueOf('\u0387'), ".", Character.valueOf('\u0388'), "E", Character.valueOf('\u0380'), "I", Character.valueOf('\u038c'), "O", Character.valueOf('\u038e'), "Y", Character.valueOf('\u038f'), "O", Character.valueOf('\u0390'), "i", Character.valueOf('\u00d7'), "*", Character.valueOf('\u0391'), "A", Character.valueOf('\u0392'), "B", Character.valueOf('\u0393'), "G", Character.valueOf('\u0394'), "D", Character.valueOf('\u0395'), "E", Character.valueOf('\u0396'), "Z", Character.valueOf('\u0397'), "E", Character.valueOf('\u0398'), "Th", Character.valueOf('\u0399'), "I", Character.valueOf('\u039a'), "K", Character.valueOf('\u039b'), "L", Character.valueOf('\u039c'), "M", Character.valueOf('\u039d'), "N", Character.valueOf('\u039e'), "X", Character.valueOf('\u039f'), "O", Character.valueOf('\u03a0'), "P", Character.valueOf('\u03a1'), "R", Character.valueOf('\u03a3'), "S", Character.valueOf('\u03a4'), "T", Character.valueOf('\u03a5'), "Y", Character.valueOf('\u03a6'), "Ph", Character.valueOf('\u03a7'), "Ch", Character.valueOf('\u03a8'), "Ps", Character.valueOf('\u03a9'), "O", Character.valueOf('\u03d1'), "th", Character.valueOf('\u03d2'), "y", Character.valueOf('\u03d6'), "pi", Character.valueOf('\u2013'), "-", Character.valueOf('\u2016'), "||", Character.valueOf('\u2017'), "_", Character.valueOf('\u2020'), "+", Character.valueOf('\u2021'), "++", Character.valueOf('\u2022'), "*", Character.valueOf('\u2023'), "*", Character.valueOf('\u2024'), ".", Character.valueOf('\u2025'), "..", Character.valueOf('\u2026'), "...", Character.valueOf('\u2027'), ".", Character.valueOf('\u2028'), "\n", Character.valueOf('\u2030'), "/1000", Character.valueOf('\u2031'), "/10000", Character.valueOf('\u2032'), "'", Character.valueOf('\u2033'), "''", Character.valueOf('\u2034'), "'''", Character.valueOf('\u2035'), "'", Character.valueOf('\u2036'), "''", Character.valueOf('\u2037'), "'''", Character.valueOf('\u2038'), "^", Character.valueOf('\u2039'), "\"", Character.valueOf('\u203a'), "\"", Character.valueOf('\u203b'), "*", Character.valueOf('\u203c'), "!!", Character.valueOf('\u203d'), "?!", Character.valueOf('\u2041'), ",", Character.valueOf('\u2042'), "***", Character.valueOf('\u2043'), "-", Character.valueOf('\u2044'), "/", Character.valueOf('\u2045'), "[", Character.valueOf('\u2046'), "]", Character.valueOf('\u2047'), "??", Character.valueOf('\u2048'), "?!", Character.valueOf('\u2049'), "!?", Character.valueOf('\u204a'), "-", Character.valueOf('\u204b'), "P", Character.valueOf('\u204c'), "<", Character.valueOf('\u204d'), ">", Character.valueOf('\u204f'), ";", Character.valueOf('\u2050'), "-", Character.valueOf('\u2051'), "**", Character.valueOf('\u2052'), "./.", Character.valueOf('\u2053'), "~", Character.valueOf('\u2054'), "_", Character.valueOf('\u2055'), "_", Character.valueOf('\u2111'), "I", Character.valueOf('\u211c'), "R", Character.valueOf('\u2122'), "(TM)", Character.valueOf('\u2135'), "a", Character.valueOf('\u2190'), "<-", Character.valueOf('\u2191'), "^", Character.valueOf('\u2192'), "->", Character.valueOf('\u2193'), "v", Character.valueOf('\u2194'), "<->", Character.valueOf('\u21b5'), "<-'", Character.valueOf('\u21d0'), "<=", Character.valueOf('\u21d1'), "^", Character.valueOf('\u21d2'), "=>", Character.valueOf('\u21d3'), "v", Character.valueOf('\u21d4'), "<=>", Character.valueOf('\u2200'), "FOR ALL", Character.valueOf('\u2202'), "d", Character.valueOf('\u2203'), "EXIST", Character.valueOf('\u2205'), "{}", Character.valueOf('\u2208'), "IN", Character.valueOf('\u2209'), "NOT IN", Character.valueOf('\u220b'), "CONTAINS", Character.valueOf('\u220f'), "PRODUCT", Character.valueOf('\u2211'), "SUM", Character.valueOf('\u2212'), "-", Character.valueOf('\u2217'), "*", Character.valueOf('\u221a'), "SQRT", Character.valueOf('\u221d'), "~", Character.valueOf('\u221e'), "INF", Character.valueOf('\u2220'), "angle", Character.valueOf('\u2227'), "&", Character.valueOf('\u2228'), "|", Character.valueOf('\u2229'), "INTERSECTION", Character.valueOf('\u222a'), "UNION", Character.valueOf('\u222b'), "INTEGRAL", Character.valueOf('\u2234'), "=>", Character.valueOf('\u223c'), "~", Character.valueOf('\u2245'), "~=", Character.valueOf('\u2248'), "~=", Character.valueOf('\u2260'), "!=", Character.valueOf('\u2261'), "==", Character.valueOf('\u2264'), "=<", Character.valueOf('\u2265'), ">=", Character.valueOf('\u2282'), "SUBSET OF", Character.valueOf('\u2283'), "SUPERSET OF", Character.valueOf('\u2284'), "NOT SUBSET OF", Character.valueOf('\u2286'), "SUBSET OR EQUAL", Character.valueOf('\u2287'), "SUPERSET OR EQUAL", Character.valueOf('\u2295'), "(+)", Character.valueOf('\u2297'), "(*)", Character.valueOf('\u22a5'), "_|_", Character.valueOf('\u22c5'), "*", Character.valueOf('\u20ac'), "EUR", Character.valueOf('\ufb00'), "ff", Character.valueOf('\ufb01'), "fi", Character.valueOf('\ufb02'), "fl", Character.valueOf('\ufb03'), "ffi", Character.valueOf('\ufb04'), "ffl", Character.valueOf('\ufb05'), "ft", Character.valueOf('\ufb06'), "st"};
        for (int i = 0; i < o.length; i += 2) {
            normalizeMap.put((Character)o[i], (String)o[i + 1]);
        }
    }

    public static interface Legal {
        public boolean isLegal(char var1);
    }

    public static interface Char2StringFn {
        public String apply(char var1);
    }
}

