/*
 * Decompiled with CFR 0.152.
 */
package javatools.parsers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javatools.administrative.D;
import javatools.datatypes.Triple;
import javatools.parsers.Language;
import javatools.parsers.NumberFormatter;
import javatools.parsers.NumberParser;
import javatools.parsers.PositionTracker;

public class DateParser {
    private static final String WBNEG = "[(?:(?<=[A-Za-z0-9_-])(?![A-Za-z0-9_-])|(?<![A-Za-z0-9_-])(?=[A-Za-z0-9_-]))&&[^|\\(\\)]]";
    public static final String DATE = DateParser.newDate("(-?[0-9#X]++)", "([0-9#X]{1,2})", "([0-9#X]{1,2})");
    public static final Pattern DATEPATTERN = Pattern.compile("[(?:(?<=[A-Za-z0-9_-])(?![A-Za-z0-9_-])|(?<![A-Za-z0-9_-])(?=[A-Za-z0-9_-]))&&[^|\\(\\)]]" + DATE);
    public static final Pattern JUSTDATEPATTERN = Pattern.compile(DATE);
    public static final String SDATE = DateParser.newSubDate("(-?[0-9#X]++)", "([0-9#X]{1,2})");
    public static final Pattern SDATEPATTERN = Pattern.compile("[(?:(?<=[A-Za-z0-9_-])(?![A-Za-z0-9_-])|(?<![A-Za-z0-9_-])(?=[A-Za-z0-9_-]))&&[^|\\(\\)]]" + SDATE);
    public static final Pattern SIMPLEYEARPATTERN = Pattern.compile("\\b(\\d{3,4})\\b");
    public static final Pattern YEARPATTERN = Pattern.compile("\\d{4}");
    private static final String[] MONTHS_EN = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] MONTHS_DE = new String[]{"Jan", "Feb", "M\u00e4r", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"};
    private static final String[] MONTHS_ES = new String[]{"ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"};
    private static final String[] MONTHS_FR = new String[]{"janv", "f\u00e9vr", "mars", "avr", "mai", "juin", "juil", "ao\u00fbt", "sept", "oct", "nov", "d\u00e9c"};
    private static final String[] MONTHS_IT = new String[]{"gen", "feb", "mar", "apr", "mag", "giu", "lug", "ago", "sep", "ott", "nov", "dic"};
    private static final String B = "[\\W_&&[^-]]*+";
    private static final String FB = "[\\W_&&[^-(]]++";
    private static final String WB = "\\b";
    private static final String H = "[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+";
    private static final String BC = "[\\W_&&[^-]]*+(?:BC|B\\.C\\.|BCE|AC|A\\.C\\.)";
    private static final String AD = "AD|A\\.D\\.[\\W_&&[^-]]*+";
    private static final String CE = "[\\W_&&[^-]]*+CE|C\\.E\\.";
    private static final String NTH = "(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+";
    private static final String N = "(\\d{1,2})[a-z]{0,2}";
    private static final String Y4 = "(\\d{4})";
    private static final String Y = "(-?\\d{1,10})";
    private static final String M = "MONTH(\\d\\d)";
    private static final String THE = "(?:the)?[\\W_&&[^-]]*+";
    private static final String CENTURY = "-?[cC]entur(?:y|(?:ies))";
    private static final String MILENNIUM = "[mM]ill?enn?ium";
    private static final FindReplace[] patterns = new FindReplace[]{new FindReplace("(-?\\d{1,10}) ?[-\\|] ?(\\d{1,2}) ?[-\\|] ?(\\d{1,2})", DateParser.newDate("$1", "$2", "$3")), new FindReplace("(-?\\d{1,10}) ?[-\\|] ?MONTH(\\d\\d) ?[-\\|] ?(\\d{1,2})", DateParser.newDate("$1", "$2", "$3")), new FindReplace("(-?\\d{1,10})[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(-?\\d{1,10})[\\W_&&[^-]]*+(?:BC|B\\.C\\.|BCE|AC|A\\.C\\.)", DateParser.newDate("-$1", "##", "##") + " to " + DateParser.newDate("-$2", "##", "##")), new FindReplace("(-?\\d{1,10})[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(-?\\d{1,10})[\\W_&&[^-]]*+CE|C\\.E\\.", DateParser.newDate("$1", "##", "##") + " to " + DateParser.newDate("$2", "##", "##")), new FindReplace("(-?\\d{1,10})[\\W_&&[^-]]*+(?:BC|B\\.C\\.|BCE|AC|A\\.C\\.)[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+AD|A\\.D\\.[\\W_&&[^-]]*+(-?\\d{1,10})", DateParser.newDate("-$1", "##", "##") + " to " + DateParser.newDate("$2", "##", "##")), new FindReplace("(-?\\d{1,10})[\\W_&&[^-]]*+(?:BC|B\\.C\\.|BCE|AC|A\\.C\\.)[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(-?\\d{1,10})[\\W_&&[^-]]*+CE|C\\.E\\.", DateParser.newDate("-$1", "##", "##") + " to " + DateParser.newDate("$2", "##", "##")), new FindReplace("AD|A\\.D\\.[\\W_&&[^-]]*+(-?\\d{1,10})[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(-?\\d{1,10})", DateParser.newDate("$1", "##", "##") + " to " + DateParser.newDate("$2", "##", "##")), new FindReplace("(-?\\d{1,10})[\\W_&&[^-]]*+(?:BC|B\\.C\\.|BCE|AC|A\\.C\\.)", DateParser.newDate("-$1", "##", "##")), new FindReplace("(-?\\d{1,10})[\\W_&&[^-]]*+CE|C\\.E\\.", DateParser.newDate("$1", "##", "##")), new FindReplace("AD|A\\.D\\.[\\W_&&[^-]]*+(-?\\d{1,10})", DateParser.newDate("$1", "##", "##")), new FindReplace("\\b(\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+(?:of)?[\\W_&&[^-]]*+MONTH(\\d\\d)[\\W_&&[^-]]*+(-?\\d{1,10})", DateParser.newDate("$4", "$3", "$1") + " to " + DateParser.newDate("$4", "$3", "$2")), new FindReplace("MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}[\\W_&&[^-(]]++(-?\\d{1,10})", DateParser.newDate("$4", "$1", "$2") + " to " + DateParser.newDate("$4", "$1", "$3")), new FindReplace("MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}[\\W_&&[^-(]]++(-?\\d{1,10})", DateParser.newDate("$5", "$1", "$2") + " to " + DateParser.newDate("$5", "$3", "$4")), new FindReplace("MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}[\\W_&&[^-(]]++(-?\\d{1,10})", DateParser.newDate("$3", "$1", "$2")), new FindReplace("MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+,[\\W_&&[^-]]*+(-?\\d{1,10})", DateParser.newDate("$3", "$1", "$2")), new FindReplace("(\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+MONTH(\\d\\d)[\\W_&&[^-]]*+(-?\\d{1,10})", DateParser.newDate("$3", "$2", "$1")), new FindReplace("the (\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+of[\\W_&&[^-]]*+MONTH(\\d\\d)[\\W_&&[^-]]*+(-?\\d{1,10})", DateParser.newDate("$3", "$2", "$1")), new FindReplace("(\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+of[\\W_&&[^-]]*+MONTH(\\d\\d)[\\W_&&[^-]]*+(-?\\d{1,10})", DateParser.newDate("$3", "$2", "$1")), new FindReplace("(\\d{1,2})[a-z]{0,2}\\.(\\d{1,2})[a-z]{0,2}\\.(-?\\d{1,10})", DateParser.newDate("$3", "$2", "$1")), new FindReplace("(\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+MONTH(\\d\\d)[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(-?\\d{1,10})", DateParser.newDate("$3", "$2", "$1")), new FindReplace("MONTH(\\d\\d)[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{4})", DateParser.newDate("$3", "$1", "##") + " to " + DateParser.newDate("$3", "$2", "##")), new FindReplace("MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{4})", DateParser.newDate("$2", "$1", "##")), new FindReplace("MONTH(\\d\\d)[\\W_&&[^-]]*+of[\\W_&&[^-]]*+(\\d{4})", DateParser.newDate("$2", "$1", "##")), new FindReplace("MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}", DateParser.newDate("##", "$1", "$2") + " to " + DateParser.newDate("##", "$3", "$4")), new FindReplace("MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}", DateParser.newDate("##", "$1", "$2") + " to " + DateParser.newDate("##", "$1", "$3")), new FindReplace("MONTH(\\d\\d)[\\W_&&[^-]]*+(\\d{1,2})[a-z]{0,2}", DateParser.newDate("##", "$1", "$2")), new FindReplace("(?:the)?[\\W_&&[^-]]*+(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+[\\W_&&[^-]]*+[mM]ill?enn?ium[\\W_&&[^-]]*+(?:BC|B\\.C\\.|BCE|AC|A\\.C\\.)", ' ' + DateParser.newDate("-&DEC$1###", "##", "##") + " to " + DateParser.newDate("-&DEC$2###", "##", "##")), new FindReplace("(?:the)?[\\W_&&[^-]]*+(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+[\\W_&&[^-]]*+-?[cC]entur(?:y|(?:ies))[\\W_&&[^-]]*+(?:BC|B\\.C\\.|BCE|AC|A\\.C\\.)", ' ' + DateParser.newDate("-&DEC$1##", "##", "##") + " to " + DateParser.newDate("-&DEC$2##", "##", "##")), new FindReplace("(?:the)?[\\W_&&[^-]]*+(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+[\\W_&&[^-]]*+(?:-+|to|until)[\\W_&&[^-]]*+(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+[\\W_&&[^-]]*+-?[cC]entur(?:y|(?:ies))", ' ' + DateParser.newDate("&DEC$1##", "##", "##") + " to " + DateParser.newDate("&DEC$2##", "##", "##")), new FindReplace("(?:the)?[\\W_&&[^-]]*+(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+[\\W_&&[^-]]*+[mM]ill?enn?ium[\\W_&&[^-]]*+(?:BC|B\\.C\\.|BCE|AC|A\\.C\\.)", ' ' + DateParser.newDate("-&DEC$1###", "##", "##")), new FindReplace("(?:the)?[\\W_&&[^-]]*+(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+[\\W_&&[^-]]*+-?[cC]entur(?:y|(?:ies))[\\W_&&[^-]]*+(?:BC|B\\.C\\.|BCE|AC|A\\.C\\.)", ' ' + DateParser.newDate("-&DEC$1##", "##", "##")), new FindReplace("(?:the)?[\\W_&&[^-]]*+(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+[\\W_&&[^-]]*+[mM]ill?enn?ium", ' ' + DateParser.newDate("&DEC$1###", "##", "##")), new FindReplace("(?:the)?[\\W_&&[^-]]*+(\\d{1,2})(?:[a-z]{2}|\\#th)[\\W_&&[^-]]*+[\\W_&&[^-]]*+-?[cC]entur(?:y|(?:ies))", ' ' + DateParser.newDate("&DEC$1##", "##", "##")), new FindReplace("(\\d{3})0'?s", DateParser.newDate("$1#", "##", "##")), new FindReplace("summer of (-?\\d{1,10})", ' ' + DateParser.newDate("$1", "68", "##")), new FindReplace("winter of (-?\\d{1,10})", ' ' + DateParser.newDate("$1", "22", "##")), new FindReplace("spring of (-?\\d{1,10})", ' ' + DateParser.newDate("$1", "35", "##")), new FindReplace("autumn of (-?\\d{1,10})", ' ' + DateParser.newDate("$1", "91", "##")), new FindReplace(DateParser.newDate("([0-9#]++)", "([0-9])", "([0-9\\#]++)"), DateParser.newDate("$1", "0$2", "$3")), new FindReplace(DateParser.newDate("([0-9#]++)", "([0-9#]{2})", "([0-9])\\b"), DateParser.newDate("$1", "$2", "0$3"))};
    private static final Pattern monthPatternEn = Pattern.compile("\\b(Jan|January|Feb|February|Febr|Mar|March|Apr|April|May|Jun|June|Jul|July|Aug|August|Sep|September|Sept|Oct|October|Nov|November|Dec|December)\\b");
    private static final Pattern monthPatternDe = Pattern.compile("\\b(Jan|Januar|Feb|Februar|Febr|M\u00e4r|M\u00e4rz|Apr|April|Mai|Jun|Juni|Jul|Juli|Aug|August|Sep|September|Sept|Okt|Oktober|Nov|November|Dez|Dezember)\\b");
    private static final Pattern monthPatternEs = Pattern.compile("\\b(ene|enero|feb|febrero|febr|mar|marzo|abr|abril|may|mayo|jun|junio|julio|ago|agosto|sep|septiembre|oct|octubre|nov|noviembre|dic|diciembre)\\b");
    private static final Pattern monthPatternFr = Pattern.compile("\\b(janv|janvier|f\u00e9vr|f\u00e9vrier|mars|avr|avril|mai|juin|juil|juillet|ao\u00fbt|sept|septembre|oct|octobre|nov|novembre|d\u00e9c|d\u00e9cembre)\\b");
    private static final Pattern monthPatternIt = Pattern.compile("\\b(gen|gennaio|feb|febbraio|febr|mar|marzo|apr|aprile|mag|maggio|giu|giugno|lug|luglio|ago|agosto|set|settembre|ott|ottobre|nov|novembre|dic|dicembre)\\b");
    private static final Pattern yearPattern = Pattern.compile("\\d{2,4}|\\d{4}s|B\\.?C\\.?|A\\.?C\\.?|A\\.?D\\.?|-?[cC]entur(?:y|(?:ies))|\\d{2,4}s");

    public static final String newDate(String y, String m, String d) {
        return y + "-" + m + "-" + d;
    }

    public static final String newDate(int y, int m, int d) {
        return DateParser.newDate("" + y, m < 10 ? "0" + m : "" + m, d < 10 ? "0" + d : "" + d);
    }

    public static final String newSubDate(String y, String m) {
        return y + "-" + m;
    }

    public static String normalize(CharSequence s) {
        return DateParser.normalize(s, Language.ENGLISH);
    }

    public static String normalize(CharSequence s, Language language) {
        Pattern monthPattern;
        String[] months = null;
        if (language.equals(Language.ENGLISH)) {
            months = MONTHS_EN;
            monthPattern = monthPatternEn;
        } else if (language.equals(Language.GERMAN)) {
            months = MONTHS_DE;
            monthPattern = monthPatternDe;
        } else if (language.equals(Language.SPANISH)) {
            months = MONTHS_ES;
            monthPattern = monthPatternEs;
        } else if (language.equals(Language.FRENCH)) {
            months = MONTHS_FR;
            monthPattern = monthPatternFr;
        } else if (language.equals(Language.ITALIAN)) {
            months = MONTHS_IT;
            monthPattern = monthPatternIt;
        } else {
            throw new IllegalArgumentException("Unsupported language: " + language);
        }
        if (!monthPattern.matcher(s).find() && !yearPattern.matcher(s).find()) {
            return s.toString();
        }
        StringBuffer in = new StringBuffer((int)((double)s.length() * 1.1));
        Matcher m = monthPattern.matcher(s);
        while (m.find()) {
            int monthNum = D.indexOf(m.group().substring(0, 3), months);
            if (monthNum == -1) {
                monthNum = D.indexOf(m.group().substring(0, 4), months);
            }
            m.appendReplacement(in, "MONTH" + ++monthNum / 10 + monthNum % 10);
        }
        m.appendTail(in);
        StringBuffer out = new StringBuffer((int)((double)in.length() * 1.1));
        for (FindReplace p : patterns) {
            m = p.pattern.matcher(in);
            if (!m.find()) continue;
            out.setLength(0);
            do {
                m.appendReplacement(out, p.replacement);
            } while (m.find());
            m.appendTail(out);
            StringBuffer temp = out;
            out = in;
            in = temp;
        }
        m = Pattern.compile("&DEC(\\d++)").matcher(in);
        if (m.find()) {
            out.setLength(0);
            do {
                m.appendReplacement(out, "" + (Integer.parseInt(m.group(1)) - 1));
            } while (m.find());
            m.appendTail(out);
            in = null;
            return out.toString();
        }
        out = null;
        return in.toString();
    }

    public static String normalize(CharSequence s, PositionTracker posTracker) {
        return DateParser.normalize(s, Language.ENGLISH, posTracker);
    }

    public static String normalize(CharSequence s, Language language, PositionTracker posTracker) {
        Object replacement;
        Pattern monthPattern;
        String[] months = null;
        if (language.equals(Language.ENGLISH)) {
            months = MONTHS_EN;
            monthPattern = monthPatternEn;
        } else if (language.equals(Language.GERMAN)) {
            months = MONTHS_DE;
            monthPattern = monthPatternDe;
        } else if (language.equals(Language.SPANISH)) {
            months = MONTHS_ES;
            monthPattern = monthPatternEs;
        } else if (language.equals(Language.FRENCH)) {
            months = MONTHS_FR;
            monthPattern = monthPatternFr;
        } else if (language.equals(Language.ITALIAN)) {
            months = MONTHS_IT;
            monthPattern = monthPatternIt;
        } else {
            throw new IllegalArgumentException("Unsupported language: " + language);
        }
        Integer difference = 0;
        if (!monthPattern.matcher(s).find() && !yearPattern.matcher(s).find()) {
            return s.toString();
        }
        StringBuffer in = new StringBuffer((int)((double)s.length() * 1.1));
        Matcher m = monthPattern.matcher(s);
        while (m.find()) {
            m.end();
            int monthNum = D.indexOf(m.group().substring(0, 3), months);
            if (monthNum == -1) {
                monthNum = D.indexOf(m.group().substring(0, 4), months);
            }
            replacement = "MONTH" + ++monthNum / 10 + monthNum % 10;
            m.appendReplacement(in, (String)replacement);
            difference = ((String)replacement).length() - (m.end() - m.start());
            posTracker.addPositionChange(m.end(), difference);
        }
        m.appendTail(in);
        StringBuffer out = new StringBuffer((int)((double)in.length() * 1.1));
        posTracker.closeRun();
        for (FindReplace p : patterns) {
            m = p.pattern.matcher(in);
            if (!m.find()) continue;
            out.setLength(0);
            do {
                m.appendReplacement(out, p.replacement);
                String test = in.substring(m.start(), m.end());
                test = p.pattern.matcher(test).replaceFirst(p.replacement);
                difference = test.length() - (m.end() - m.start());
                posTracker.addPositionChange(m.end(), difference);
            } while (m.find());
            m.appendTail(out);
            StringBuffer temp = out;
            out = in;
            in = temp;
            posTracker.closeRun();
        }
        m = Pattern.compile("&DEC(\\d++)").matcher(in);
        if (m.find()) {
            out.setLength(0);
            do {
                m.appendReplacement(out, "" + (Integer.parseInt(m.group(1)) - 1));
                replacement = "" + (Integer.parseInt(m.group(1)) - 1);
                difference = ((String)replacement).length() - (m.end() - m.start());
                posTracker.addPositionChange(m.end(), difference);
            } while (m.find());
            m.appendTail(out);
            posTracker.closeRun();
            in = null;
            return out.toString();
        }
        out = null;
        return in.toString();
    }

    public static Collection<String> getAllDates(CharSequence s) {
        return DateParser.getAllDates(s, Language.ENGLISH);
    }

    public static Collection<String> getAllDates(CharSequence s, Language language) {
        Pattern monthPattern;
        String[] months = null;
        if (language.equals(Language.ENGLISH)) {
            months = MONTHS_EN;
            monthPattern = monthPatternEn;
        } else if (language.equals(Language.GERMAN)) {
            months = MONTHS_DE;
            monthPattern = monthPatternDe;
        } else if (language.equals(Language.SPANISH)) {
            months = MONTHS_ES;
            monthPattern = monthPatternEs;
        } else if (language.equals(Language.FRENCH)) {
            months = MONTHS_FR;
            monthPattern = monthPatternFr;
        } else if (language.equals(Language.ITALIAN)) {
            months = MONTHS_IT;
            monthPattern = monthPatternIt;
        } else {
            throw new IllegalArgumentException("Unsupported language: " + language);
        }
        if (!monthPattern.matcher(s).find() && !yearPattern.matcher(s).find()) {
            return null;
        }
        ArrayList<String> dates = new ArrayList<String>();
        StringBuffer in = new StringBuffer((int)((double)s.length() * 1.1));
        Matcher m = monthPattern.matcher(s);
        while (m.find()) {
            int monthNum = D.indexOf(m.group().substring(0, 3), months);
            if (monthNum == -1) {
                monthNum = D.indexOf(m.group().substring(0, 4), months);
            }
            m.appendReplacement(in, "MONTH" + ++monthNum / 10 + monthNum % 10);
        }
        m.appendTail(in);
        StringBuffer out = new StringBuffer((int)((double)in.length() * 1.1));
        for (FindReplace p : patterns) {
            m = p.pattern.matcher(in);
            if (!m.find()) continue;
            out.setLength(0);
            do {
                String retrivel = m.group();
                StringBuffer tem = new StringBuffer(retrivel);
                m.appendReplacement(out, p.replacement);
                Matcher tt = p.pattern.matcher(tem);
                StringBuffer o1 = new StringBuffer();
                if (!tt.find()) continue;
                tt.appendReplacement(o1, p.replacement);
                dates.add(o1.toString());
            } while (m.find());
            m.appendTail(out);
            StringBuffer temp = out;
            out = in;
            in = temp;
        }
        m = Pattern.compile("&DEC(\\d++)").matcher(in);
        if (m.find()) {
            out.setLength(0);
            do {
                String retrivel = m.group();
                StringBuffer tem = new StringBuffer(retrivel);
                m.appendReplacement(out, "" + (Integer.parseInt(m.group(1)) - 1));
                Matcher tt = Pattern.compile("&DEC(\\d++)").matcher(tem);
                StringBuffer o1 = new StringBuffer();
                if (!tt.find()) continue;
                tt.appendReplacement(o1, "" + (Integer.parseInt(m.group(1)) - 1));
                dates.add(o1.toString());
            } while (m.find());
            m.appendTail(out);
            in = null;
        }
        out = null;
        return dates;
    }

    public static Collection<Triple<String, Integer, Integer>> getAllDatePositions(CharSequence s) {
        return DateParser.getAllDatePositions(s, Language.ENGLISH);
    }

    public static Collection<Triple<String, Integer, Integer>> getAllDatePositions(CharSequence s, Language language) {
        Pattern monthPattern;
        String[] months = null;
        if (language.equals(Language.ENGLISH)) {
            months = MONTHS_EN;
            monthPattern = monthPatternEn;
        } else if (language.equals(Language.GERMAN)) {
            months = MONTHS_DE;
            monthPattern = monthPatternDe;
        } else if (language.equals(Language.SPANISH)) {
            months = MONTHS_ES;
            monthPattern = monthPatternEs;
        } else if (language.equals(Language.FRENCH)) {
            months = MONTHS_FR;
            monthPattern = monthPatternFr;
        } else if (language.equals(Language.ITALIAN)) {
            months = MONTHS_IT;
            monthPattern = monthPatternIt;
        } else {
            throw new IllegalArgumentException("Unsupported language: " + language);
        }
        ArrayList<Triple<String, Integer, Integer>> dates = new ArrayList<Triple<String, Integer, Integer>>();
        if (!monthPattern.matcher(s).find() && !yearPattern.matcher(s).find()) {
            return dates;
        }
        StringBuffer in = new StringBuffer((int)((double)s.length() * 1.1));
        LinkedList<Triple<Integer, Integer, Integer>> offSetList = new LinkedList<Triple<Integer, Integer, Integer>>();
        Matcher m = monthPattern.matcher(s);
        while (m.find()) {
            int monthNum = D.indexOf(m.group().substring(0, 3), months);
            if (monthNum == -1) {
                monthNum = D.indexOf(m.group().substring(0, 4), months);
            }
            String newMonth = "MONTH" + ++monthNum / 10 + monthNum % 10;
            int diff = m.end() - m.start() - newMonth.length();
            m.appendReplacement(in, newMonth);
            int position = in.length() - newMonth.length();
            Triple<Integer, Integer, Integer> offsetPair = new Triple<Integer, Integer, Integer>(position, m.end() - m.start(), diff);
            offSetList.add(offsetPair);
        }
        m.appendTail(in);
        StringBuffer out = new StringBuffer((int)((double)in.length() * 1.1));
        int previousOffSet = 0;
        HashSet<Integer> offsetUsed = new HashSet<Integer>();
        for (FindReplace p : patterns) {
            m = p.pattern.matcher(in);
            LinkedList<Triple> toRemove = new LinkedList<Triple>();
            LinkedList<Triple<Integer, Integer, Integer>> toAdd = new LinkedList<Triple<Integer, Integer, Integer>>();
            if (!m.find()) continue;
            out.setLength(0);
            previousOffSet = 0;
            do {
                String retrivel = m.group();
                StringBuffer tem = new StringBuffer(retrivel);
                m.appendReplacement(out, p.replacement);
                Matcher tt = p.pattern.matcher(tem);
                StringBuffer o1 = new StringBuffer();
                if (!tt.find()) continue;
                tt.appendReplacement(o1, p.replacement);
                int start = m.start();
                int end = m.end();
                LinkedList<Triple> offSetPairs = new LinkedList<Triple>();
                Iterator iter = offSetList.iterator();
                previousOffSet = 0;
                boolean ignore = false;
                while (iter.hasNext()) {
                    Triple nextOffSetPair = (Triple)iter.next();
                    if (start <= (Integer)nextOffSetPair.first && end >= (Integer)nextOffSetPair.first) {
                        offSetPairs.add(nextOffSetPair);
                    } else if ((Integer)nextOffSetPair.first < start) {
                        previousOffSet += ((Integer)nextOffSetPair.third).intValue();
                    }
                    if ((Integer)nextOffSetPair.first >= start || (Integer)nextOffSetPair.second + (Integer)nextOffSetPair.first < end) continue;
                    ignore = true;
                }
                if (ignore) continue;
                if (offSetPairs.size() > 0) {
                    int diff = 0;
                    for (Triple offSetPair : offSetPairs) {
                        toRemove.add(offSetPair);
                        diff += ((Integer)offSetPair.third).intValue();
                    }
                    end = end - start + diff;
                    start += previousOffSet;
                    previousOffSet += diff;
                    int position = out.length() - o1.length();
                    int length = end - o1.length();
                    Triple<Integer, Integer, Integer> newOffSetPair = new Triple<Integer, Integer, Integer>(position, o1.length(), length);
                    toAdd.add(newOffSetPair);
                } else {
                    end -= start;
                    start += previousOffSet;
                    int position = out.length() - o1.length();
                    int length = end - o1.length();
                    Triple<Integer, Integer, Integer> newOffSetPair = new Triple<Integer, Integer, Integer>(position, o1.length(), length);
                    toAdd.add(newOffSetPair);
                }
                if (offsetUsed.contains(start)) continue;
                dates.add(new Triple<String, Integer, Integer>(o1.toString(), start, end));
                offsetUsed.add(start);
            } while (m.find());
            m.appendTail(out);
            StringBuffer temp = out;
            out = in;
            in = temp;
            Iterator iter = toRemove.iterator();
            while (iter.hasNext()) {
                offSetList.remove(iter.next());
            }
            iter = toAdd.iterator();
            while (iter.hasNext()) {
                offSetList.add((Triple<Integer, Integer, Integer>)iter.next());
            }
        }
        m = Pattern.compile("&DEC(\\d++)").matcher(in);
        if (m.find()) {
            LinkedList<Triple> toRemove = new LinkedList<Triple>();
            LinkedList<Triple<Integer, Integer, Integer>> toAdd = new LinkedList<Triple<Integer, Integer, Integer>>();
            out.setLength(0);
            previousOffSet = 0;
            do {
                String retrivel = m.group();
                StringBuffer tem = new StringBuffer(retrivel);
                m.appendReplacement(out, "" + (Integer.parseInt(m.group(1)) - 1));
                Matcher tt = Pattern.compile("&DEC(\\d++)").matcher(tem);
                StringBuffer o1 = new StringBuffer();
                if (!tt.find()) continue;
                tt.appendReplacement(o1, "" + (Integer.parseInt(m.group(1)) - 1));
                int start = m.start();
                int end = m.end();
                LinkedList<Triple> offSetPairs = new LinkedList<Triple>();
                Iterator iter = offSetList.iterator();
                previousOffSet = 0;
                boolean ignore = false;
                while (iter.hasNext()) {
                    Triple nextOffSetPair = (Triple)iter.next();
                    if (start <= (Integer)nextOffSetPair.first && end >= (Integer)nextOffSetPair.first) {
                        offSetPairs.add(nextOffSetPair);
                    } else if ((Integer)nextOffSetPair.first < start) {
                        previousOffSet += ((Integer)nextOffSetPair.third).intValue();
                    }
                    if ((Integer)nextOffSetPair.first >= start || (Integer)nextOffSetPair.second + (Integer)nextOffSetPair.first < end) continue;
                    ignore = true;
                }
                if (ignore) continue;
                if (offSetPairs.size() > 0) {
                    int diff = 0;
                    for (Triple offSetPair : offSetPairs) {
                        toRemove.add(offSetPair);
                        diff += ((Integer)offSetPair.third).intValue();
                    }
                    end = end - start + diff;
                    start += previousOffSet;
                    previousOffSet += diff;
                    int position = out.length() - o1.length();
                    int length = end - o1.length();
                    Triple<Integer, Integer, Integer> newOffSetPair = new Triple<Integer, Integer, Integer>(position, o1.length(), length);
                    toAdd.add(newOffSetPair);
                } else {
                    end -= start;
                    start += previousOffSet;
                    int position = out.length() - o1.length();
                    int length = end - o1.length();
                    Triple<Integer, Integer, Integer> newOffSetPair = new Triple<Integer, Integer, Integer>(position, o1.length(), length);
                    toAdd.add(newOffSetPair);
                }
                if (offsetUsed.contains(start)) continue;
                dates.add(new Triple<String, Integer, Integer>(o1.toString(), start, end));
                offsetUsed.add(start);
            } while (m.find());
            m.appendTail(out);
            in = null;
        }
        out = null;
        return dates;
    }

    public static String[] getDate(CharSequence d, int[] pos) {
        if (d == null) {
            return null;
        }
        Matcher m = JUSTDATEPATTERN.matcher(d);
        if (!m.find()) {
            m = SIMPLEYEARPATTERN.matcher(d.toString());
            if (!m.find()) {
                return null;
            }
            pos[0] = m.start();
            pos[1] = m.end();
            return new String[]{m.group(1), "##", "##"};
        }
        pos[0] = m.start();
        pos[1] = m.end();
        String[] result = new String[]{m.group(1), m.group(2), m.group(3)};
        return result;
    }

    public static List<String> getDates(CharSequence d) {
        ArrayList<String> preresult = new ArrayList<String>(3);
        Matcher m = DATEPATTERN.matcher(d);
        while (m.find()) {
            preresult.add(m.group());
        }
        ArrayList<String> result = new ArrayList<String>(3);
        for (String date : preresult) {
            Integer value;
            String[] split = DateParser.getDate(date);
            if (split.length != 3) {
                split = new String[3];
                for (int i = 0; i < split.length; ++i) {
                    split[i] = "##";
                }
            }
            if (!split[0].contains("#")) {
                try {
                    Integer.parseInt(split[0]);
                }
                catch (NumberFormatException e) {
                    split[0] = "##";
                }
            }
            if (split[0].length() > 4) {
                return result;
            }
            if (!(split[1].contains("#") || (value = NumberParser.parseInt(split[1])) != null && value <= 12 && value >= 1)) {
                split[1] = "##";
            }
            if (!(split[2].contains("#") || (value = NumberParser.parseInt(split[2])) != null && value <= 31 && value >= 1)) {
                split[2] = "##";
            }
            result.add(DateParser.newDate(split[0], split[1], split[2]));
        }
        if (result.size() == 0) {
            m = SIMPLEYEARPATTERN.matcher(d);
            while (m.find()) {
                result.add(DateParser.newDate(m.group(), "##", "##"));
            }
        }
        return result;
    }

    public static String[] getDate(CharSequence d) {
        return DateParser.getDate(d, new int[2]);
    }

    public static boolean isDate(CharSequence s) {
        return DATEPATTERN.matcher(s).matches();
    }

    public static Calendar asCalendar(int[] date) {
        Calendar c = Calendar.getInstance();
        c.clear();
        int year = date[0];
        if (year < 0) {
            year = -year;
            c.set(0, 0);
        }
        c.set(1, year);
        if (date[1] != Integer.MAX_VALUE) {
            c.set(2, date[1]);
        }
        if (date[2] != Integer.MAX_VALUE) {
            c.set(5, date[2]);
        }
        return c;
    }

    public static Calendar asCalendar(String[] date) {
        return DateParser.asCalendar(DateParser.asInts(date));
    }

    public static Calendar asCalendar(String date) {
        return DateParser.asCalendar(DateParser.asInts(DateParser.getDate(date)));
    }

    protected static boolean matches(String a, String b) {
        if (a.length() != b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == '#' || a.charAt(i) == b.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int[] asInts(String[] yearMonthDay) {
        int[] result = new int[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = yearMonthDay == null ? Integer.MAX_VALUE : (yearMonthDay[i].contains("#") ? Integer.MAX_VALUE : Integer.parseInt(yearMonthDay[i]));
        }
        return result;
    }

    public static boolean isEarlier(int[] date1, int[] date2) {
        for (int i = 0; i < 3; ++i) {
            if (date1[i] == Integer.MAX_VALUE || date2[i] == Integer.MAX_VALUE) {
                return false;
            }
            if (date1[i] > date2[i]) {
                return false;
            }
            if (date1[i] >= date2[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isEarlier(String[] date1, String[] date2) {
        return DateParser.isEarlier(DateParser.asInts(date1), DateParser.asInts(date2));
    }

    public static boolean isEarlier(String date1, String date2) {
        return DateParser.isEarlier(DateParser.getDate(date1), DateParser.getDate(date2));
    }

    public static boolean includes(int[] date1, int[] date2) {
        for (int i = 0; i < 3; ++i) {
            if (date1[i] == Integer.MAX_VALUE) {
                return true;
            }
            if (date1[i] == date2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean includes(String[] date1, String[] date2) {
        for (int i = 0; i < 3; ++i) {
            if (DateParser.matches(date1[i], date2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean includes(String date1, String date2) {
        return DateParser.includes(DateParser.getDate(date1), DateParser.getDate(date2));
    }

    public static boolean equal(int[] date1, int[] date2) {
        for (int i = 0; i < 3; ++i) {
            if (date1[i] == date2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(String[] date1, String[] date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (date1[i].equals(date2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(String date1, String date2) {
        return DateParser.equal(DateParser.getDate(date1), DateParser.getDate(date2));
    }

    public static boolean disjoint(int[] date1, int[] date2) {
        return !DateParser.includes(date1, date2) && !DateParser.includes(date2, date1);
    }

    public static boolean disjoint(String[] date1, String[] date2) {
        return !DateParser.includes(date1, date2) && !DateParser.includes(date2, date1);
    }

    public static boolean disjoint(String date1, String date2) {
        return !DateParser.includes(date1, date2) && !DateParser.includes(date2, date1);
    }

    public static void main(String[] argv) throws Exception {
        System.out.println(NumberFormatter.ISOtime(DateParser.asCalendar(DateParser.normalize("November 24th 1998"))));
        System.out.println("Enter a string containing a date expression and hit ENTER. Press CTRL+C to abort");
        while (true) {
            String in = D.r();
            System.out.println(DateParser.normalize(in));
            System.out.println(DateParser.getDates(DateParser.normalize(in)));
        }
    }

    private static class FindReplace {
        public Pattern pattern;
        public String replacement;
        public static int counter = 0;
        public int id = counter++;

        public FindReplace(String f, String r) {
            this.pattern = Pattern.compile(f);
            this.replacement = r;
        }

        public String toString() {
            return this.id + ": " + this.pattern + "     -->     " + this.replacement;
        }
    }
}

