/*
 * Decompiled with CFR 0.152.
 */
package javatools.parsers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javatools.administrative.Announce;

public class Language
implements Comparable<Language> {
    protected String id;
    Map<String, List<String>> pronounPositiveTypes = new HashMap<String, List<String>>();
    Map<String, List<String>> pronounNegativeTypes = new HashMap<String, List<String>>();
    protected static final Map<String, String> supported = new HashMap<String, String>();
    public static final Language ENGLISH;
    public static final Language GERMAN;
    public static final Language FRENCH;
    public static final Language SPANISH;
    public static final Language ITALIAN;

    public Language(String id) throws LanguageNotSupportedException {
        if (!this.supportedLanguage(id)) {
            throw new LanguageNotSupportedException();
        }
        this.id = id;
        this.initPronouns();
    }

    protected void initPronouns() {
        for (Map.Entry<String, String> prTypes : Language.getPronounTypes(this.id).entrySet()) {
            String[] split = prTypes.getValue().split("\\+:-");
            if (split[0] != null) {
                this.pronounPositiveTypes.put(prTypes.getKey(), Arrays.asList(split[0].split(",")));
            }
            if (split.length <= 1 || split[1] == null) continue;
            this.pronounNegativeTypes.put(prTypes.getKey(), Arrays.asList(split[0].split(",")));
        }
    }

    protected static final Map<String, String> getPronounTypes(String id) {
        HashMap<String, String> prons = new HashMap<String, String>();
        if (id.equals("en")) {
            prons.put("my", "wordnet_person_100007846");
            prons.put("he", "wordnet_person_100007846");
            prons.put("his", "wordnet_person_100007846");
            prons.put("she", "wordnet_person_100007846");
            prons.put("her", "wordnet_person_100007846");
            prons.put("it", "wordnet_entity_100001740+:-wordnet_person_100007846");
        }
        return prons;
    }

    protected static final Language generateLanguage(String id) {
        Language lang = null;
        try {
            lang = new Language(id);
        }
        catch (LanguageNotSupportedException ex) {
            Announce.error(ex);
        }
        return lang;
    }

    public boolean isPronoun(String candidate) {
        return this.pronounPositiveTypes.keySet().contains(candidate.toLowerCase());
    }

    public Set<String> getPronouns() {
        return this.pronounPositiveTypes.keySet();
    }

    public List<String> getPronounEntityTypes(String pronoun) {
        return this.pronounPositiveTypes.get(pronoun.toLowerCase());
    }

    public List<String> getPronounCounterEntityTypes(String pronoun) {
        return this.pronounNegativeTypes.get(pronoun.toLowerCase());
    }

    public final boolean supportedLanguage(String lang) {
        for (String supLang : supported.keySet()) {
            if (!supLang.equals(lang)) continue;
            return true;
        }
        return false;
    }

    public final String getLongForm() {
        return supported.get(this.id);
    }

    public final String getId() {
        return this.id;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Language)) {
            return false;
        }
        Language otherLanguage = (Language)other;
        return this.id.equals(otherLanguage.id);
    }

    public final int hashCode() {
        if (this.id == null) {
            return 0;
        }
        return this.id.hashCode();
    }

    @Override
    public final int compareTo(Language other) {
        return this.id.compareTo(other.id);
    }

    public static void main(String[] argv) throws Exception {
        for (String langID : supported.keySet()) {
            Language lang = new Language(langID);
            Announce.message("Language ID:'" + langID + "' full name:'" + lang.getLongForm() + "'");
            assert (lang.getLongForm().equals(supported.get(langID)));
            Announce.message("Pronouns: " + lang.getPronouns());
            for (String pronoun : lang.getPronouns()) {
                assert (lang.isPronoun(pronoun));
            }
        }
    }

    static {
        supported.put("en", "English");
        supported.put("de", "German");
        supported.put("fr", "French");
        supported.put("es", "Spanish");
        supported.put("it", "Italian");
        ENGLISH = Language.generateLanguage("en");
        GERMAN = Language.generateLanguage("de");
        FRENCH = Language.generateLanguage("fr");
        SPANISH = Language.generateLanguage("es");
        ITALIAN = Language.generateLanguage("it");
    }

    public static class LanguageNotSupportedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LanguageNotSupportedException() {
        }

        public LanguageNotSupportedException(String message) {
            super(message);
        }

        public LanguageNotSupportedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

