/*
 * Decompiled with CFR 0.152.
 */
package javatools.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.StringTokenizer;
import javatools.administrative.D;
import javatools.datatypes.ArrayQueue;
import javatools.datatypes.PeekIterator;

public class RegularExpression
implements Iterable<List<String>> {
    public List<RegExState> entries = new ArrayList<RegExState>();
    public List<RegExState> exits = new ArrayList<RegExState>();
    public String original;

    public String getOrginal() {
        return this.original;
    }

    public static RegularExpression compile(String regex) {
        regex = regex.replaceAll("([^\\| \\(])\\(", "$1 (");
        regex = regex.replaceAll("\\)([^\\| \\)\\*\\+])", ") $1");
        regex = regex.replaceAll("\\*([^\\| \\)])", "* $1");
        regex = regex.replaceAll("\\+([^\\| \\)])", "+ $1");
        RegularExpression result = RegularExpression.parseSimple(new StringTokenizer(regex, "|*+ ()", true));
        result.original = regex;
        return result;
    }

    public String toString() {
        return this.original;
    }

    protected RegularExpression(String token) {
        RegExState r = new RegExState(token);
        this.entries.add(r);
        this.exits.add(r);
    }

    protected RegularExpression() {
    }

    public boolean isExit(RegExState e) {
        return this.exits.contains(e);
    }

    public List<RegExState> getEntries() {
        return this.entries;
    }

    public static RegularExpression parseSimple(StringTokenizer regex) {
        boolean disjunctMode = false;
        RegularExpression result = null;
        while (regex.hasMoreElements()) {
            RegularExpression nextRegEx;
            String next = regex.nextToken();
            if (next.equals("(")) {
                nextRegEx = RegularExpression.parseSimple(regex);
            } else {
                if (next.length() == 0 || next.length() == 1 && "|*+ ()".indexOf(next.charAt(0)) != -1) {
                    throw new RuntimeException("Invalid token in regular expression " + next);
                }
                nextRegEx = new RegularExpression(next);
            }
            String delim = regex.hasMoreTokens() ? regex.nextToken() : ")";
            boolean star = delim.equals("*");
            if (delim.equals("+") || delim.equals("*")) {
                for (RegExState c : nextRegEx.exits) {
                    c.addSuccessors(nextRegEx.entries);
                }
                delim = regex.hasMoreTokens() ? regex.nextToken() : ")";
            }
            boolean bl = disjunctMode = disjunctMode || delim.equals("|");
            if (result == null) {
                result = nextRegEx;
            } else if (disjunctMode) {
                result.entries.addAll(nextRegEx.entries);
                result.exits.addAll(nextRegEx.exits);
            } else if (star) {
                for (RegExState c : result.exits) {
                    c.addSuccessors(nextRegEx.entries);
                }
                result.exits.addAll(nextRegEx.exits);
            } else {
                for (RegExState c : result.exits) {
                    c.addSuccessors(nextRegEx.entries);
                }
                result.exits = nextRegEx.exits;
            }
            if (!delim.equals(")")) continue;
            break;
        }
        return result;
    }

    public String describe() {
        StringBuilder b = new StringBuilder();
        b.append(this.original).append("\nEntries: ").append(this.entries).append("\nExits: ").append(this.exits).append('\n');
        for (RegExState s : this.entries) {
            b.append(s.describe());
        }
        return b.toString();
    }

    public List<RegExState> getStates() {
        ArrayList<RegExState> result = new ArrayList<RegExState>();
        result.addAll(this.getEntries());
        for (int i = 0; i < result.size(); ++i) {
            for (RegExState s : ((RegExState)result.get(i)).getSuccessors()) {
                if (result.contains(s)) continue;
                result.add(s);
            }
        }
        return result;
    }

    public RegularExpression inverse() {
        RegularExpression result = new RegularExpression();
        result.original = "Inverse of " + this.original;
        ArrayList<RegExState> resultStates = new ArrayList<RegExState>();
        List<RegExState> states = this.getStates();
        for (RegExState s : states) {
            resultStates.add(new RegExState(s.getToken()));
        }
        for (int i = 0; i < states.size(); ++i) {
            RegExState resultState = (RegExState)resultStates.get(i);
            RegExState state = states.get(i);
            for (int j = 0; j < states.size(); ++j) {
                if (!states.get(j).getSuccessors().contains(state)) continue;
                resultState.addSuccessor((RegExState)resultStates.get(j));
            }
            if (this.entries.contains(state)) {
                result.exits.add(resultState);
            }
            if (!this.exits.contains(state)) continue;
            result.entries.add(resultState);
        }
        return result;
    }

    @Override
    public PeekIterator<List<String>> iterator() {
        return new PeekIterator<List<String>>(){
            Queue<List<RegExState>> queue = new ArrayQueue<List>(new List[0]);
            {
                for (RegExState r : RegularExpression.this.getEntries()) {
                    this.queue.add(Arrays.asList(r));
                }
            }

            @Override
            public List<String> internalNext() {
                List<RegExState> next;
                RegExState end;
                do {
                    if (this.queue.size() == 0) {
                        return null;
                    }
                    next = this.queue.poll();
                    end = next.get(next.size() - 1);
                    for (RegExState followUp : end.getSuccessors()) {
                        ArrayList<RegExState> nextPlusFollowUp = new ArrayList<RegExState>(next);
                        nextPlusFollowUp.add(followUp);
                        this.queue.add(nextPlusFollowUp);
                    }
                } while (!RegularExpression.this.exits.contains(end));
                ArrayList<String> result = new ArrayList<String>();
                for (RegExState s : next) {
                    result.add(s.token);
                }
                return result;
            }
        };
    }

    public static void main(String[] args) {
        block0: while (true) {
            D.p("Enter a regular expression");
            RegularExpression r = RegularExpression.compile(D.r());
            D.p(r.describe());
            D.p(new Object[0]);
            D.p("Inverse:");
            D.p(r.inverse().describe());
            D.p(new Object[0]);
            Iterator it = r.iterator();
            int i = 0;
            while (true) {
                if (i >= 10 || !it.hasNext()) continue block0;
                D.p(it.next());
                ++i;
            }
            break;
        }
    }

    public static class RegExState
    implements Comparable<RegExState> {
        public static int idcounter = 0;
        public final int id = ++idcounter;
        public List<RegExState> successors = new ArrayList<RegExState>();
        public String token = null;

        public void setToken(String t) {
            this.token = t;
        }

        public void addSuccessor(RegExState s) {
            this.successors.add(s);
        }

        public void addSuccessors(Collection<RegExState> s) {
            this.successors.addAll(s);
        }

        public String getToken() {
            return this.token;
        }

        public List<RegExState> getSuccessors() {
            return this.successors;
        }

        public RegExState(String token) {
            this.token = token;
        }

        public String toString() {
            return (this.token == null ? "null" : this.token.toString()) + "(" + this.id + ")";
        }

        public String describe() {
            StringBuilder b = new StringBuilder();
            ArrayList<RegExState> s = new ArrayList<RegExState>();
            this.describe(b, s);
            return b.toString();
        }

        protected void describe(StringBuilder b, Collection<RegExState> done) {
            if (done.contains(this)) {
                return;
            }
            b.append(this.toString());
            b.append(" -> ").append(this.successors).append("\n");
            done.add(this);
            for (RegExState c : this.successors) {
                c.describe(b, done);
            }
        }

        @Override
        public int compareTo(RegExState o) {
            return o.id < this.id ? -1 : (o.id > this.id ? 1 : 0);
        }

        public boolean equals(Object o) {
            return o != null & o instanceof RegExState && ((RegExState)o).id == this.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

