/*
 * Decompiled with CFR 0.152.
 */
package de.qaware.maven.plugin.offline;

import de.qaware.maven.plugin.offline.AbstractGoOfflineMojo;
import de.qaware.maven.plugin.offline.ArtifactWithRepoType;
import de.qaware.maven.plugin.offline.DependencyDownloader;
import de.qaware.maven.plugin.offline.DynamicDependency;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositoryException;

@Mojo(name="resolve-dependencies", threadSafe=true, requiresOnline=true, aggregator=true)
public class ResolveDependenciesMojo
extends AbstractGoOfflineMojo {
    @Component
    private DependencyDownloader dependencyDownloader;
    @Parameter
    private List<DynamicDependency> dynamicDependencies;
    @Parameter(defaultValue="false", property="downloadSources")
    private boolean downloadSources;
    @Parameter(defaultValue="false", property="downloadJavadoc")
    private boolean downloadJavadoc;
    @Parameter(defaultValue="false", property="failOnErrors")
    private boolean failOnErrors;

    public void execute() throws MojoExecutionException {
        this.dependencyDownloader.init(this.getBuildingRequest(), this.getReactorProjects(), this.getLog());
        if (this.downloadSources) {
            this.dependencyDownloader.enableDownloadSources();
        }
        if (this.downloadJavadoc) {
            this.dependencyDownloader.enableDownloadJavadoc();
        }
        HashSet allPlugins = new HashSet();
        for (MavenProject mavenProject : this.getReactorProjects()) {
            List buildPlugins = mavenProject.getBuildPlugins();
            allPlugins.addAll(buildPlugins);
        }
        HashSet<ArtifactWithRepoType> artifactsToDownload = new HashSet<ArtifactWithRepoType>();
        for (Plugin plugin : allPlugins) {
            artifactsToDownload.addAll(this.dependencyDownloader.resolvePlugin(plugin));
        }
        for (MavenProject project : this.getReactorProjects()) {
            artifactsToDownload.addAll(this.dependencyDownloader.resolveDependencies(project));
        }
        if (this.dynamicDependencies != null) {
            for (DynamicDependency dep : this.dynamicDependencies) {
                artifactsToDownload.addAll(this.dependencyDownloader.resolveDynamicDependency(dep));
            }
        }
        this.dependencyDownloader.downloadArtifacts(artifactsToDownload);
        List<RepositoryException> list = this.dependencyDownloader.getErrors();
        for (RepositoryException error : list) {
            this.getLog().warn((CharSequence)error.getMessage());
        }
        if (this.failOnErrors && !list.isEmpty()) {
            throw new MojoExecutionException("Unable to download dependencies, consult the errors and warnings printed above.");
        }
    }
}

