/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.ui;

import de.redsix.pdfcompare.Exclusions;
import de.redsix.pdfcompare.PageArea;
import de.redsix.pdfcompare.env.Environment;
import de.redsix.pdfcompare.ui.Display;
import de.redsix.pdfcompare.ui.ExclusionItemPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class ExclusionsPanel
extends JPanel {
    private final Environment environment;
    private JPanel exclusionsList;
    private JLabel configFile;
    private File selectedFile;
    private ExclusionItemPanel selectedItem;
    private final Display display;
    private Collection<PageArea> differencesFromCompare = new ArrayList<PageArea>();

    public ExclusionsPanel(Display display, Environment environment) {
        this.environment = environment;
        this.display = display;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(220, 100));
        this.add((Component)new JLabel("Excluded Areas"), "North");
        this.exclusionsList = new JPanel();
        this.exclusionsList.setLayout(new BoxLayout(this.exclusionsList, 3));
        JPanel configPanel = new JPanel(null);
        configPanel.setPreferredSize(new Dimension(200, 40));
        JLabel configLabel = new JLabel("Config File:");
        configLabel.setFont(Font.decode("SansSerif-plain-10"));
        configLabel.setBounds(5, 0, 190, 15);
        configPanel.add(configLabel);
        this.configFile = new JLabel("unknown");
        this.configFile.setBounds(10, 15, 190, 20);
        configPanel.add(this.configFile);
        JPanel exclusionsWrapper = new JPanel(new BorderLayout());
        exclusionsWrapper.add((Component)this.exclusionsList, "North");
        exclusionsWrapper.add((Component)configPanel, "South");
        JScrollPane scrollPane = new JScrollPane(exclusionsWrapper);
        this.add((Component)scrollPane, "Center");
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        this.add((Component)toolBar, "South");
        ExclusionsPanel.addToolBarButton(toolBar, "New", "Add new exclusion block", event -> this.addItemAction());
        ExclusionsPanel.addToolBarButton(toolBar, "Diffs", "Show computed differences", event -> this.showComputedDifferencesAction());
        ExclusionsPanel.addToolBarButton(toolBar, "Load", "Load exclusions file", event -> this.loadAction());
        ExclusionsPanel.addToolBarButton(toolBar, "Save", "Save exclusions file", event -> this.saveAction());
        new DropTarget(this, 1, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                DataFlavor flavor = DataFlavor.javaFileListFlavor;
                if (!dtde.isDataFlavorSupported(flavor)) {
                    dtde.rejectDrop();
                    return;
                }
                try {
                    dtde.acceptDrop(1);
                    List files = (List)dtde.getTransferable().getTransferData(flavor);
                    if (files == null || files.isEmpty()) {
                        dtde.dropComplete(false);
                        return;
                    }
                    File exclusionFile = (File)files.get(0);
                    ExclusionsPanel.this.openExclusionFile(exclusionFile);
                    dtde.dropComplete(true);
                }
                catch (Exception e) {
                    dtde.dropComplete(false);
                }
            }

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                if (!dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.rejectDrag();
                    return;
                }
                if (dtde.getDropAction() != 1) {
                    dtde.acceptDrag(1);
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                if (dtde.getDropAction() != 1) {
                    dtde.acceptDrag(1);
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
                if (dtde.getDropAction() != 1) {
                    dtde.acceptDrag(1);
                }
            }
        });
    }

    private void addItemAction() {
        this.addExclusion(new PageArea(this.display.getPageNumber()));
    }

    private void showComputedDifferencesAction() {
        if (this.exclusionsList.getComponents().length == 0 || this.askForReplacement()) {
            this.useDifferencesFromCompare();
            this.display.redrawImages();
        }
    }

    private boolean askForReplacement() {
        return JOptionPane.showConfirmDialog(null, "This replaces the current exclusions with the computed differences.", "Info", 2, 1) == 0;
    }

    private void loadAction() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(this.selectedFile);
        if (fileChooser.showDialog(this, "Open exclusions definition") == 0) {
            this.openExclusionFile(fileChooser.getSelectedFile());
        }
    }

    private void saveAction() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(this.selectedFile);
        if (fileChooser.showDialog(this, "Save exclusions as") == 0) {
            try {
                this.selectedFile = fileChooser.getSelectedFile();
                this.saveExclusionFile(this.selectedFile);
            }
            catch (IOException ex) {
                JFrame frame = ExclusionsPanel.getFrame(this);
                Display.displayExceptionDialog(frame, ex);
            }
        }
    }

    public void useDifferencesFromCompare(Collection<PageArea> differences) {
        this.differencesFromCompare = differences;
        this.useDifferencesFromCompare();
    }

    private void useDifferencesFromCompare() {
        Exclusions exclusions = new Exclusions(this.environment);
        for (PageArea pageArea : this.differencesFromCompare) {
            exclusions.add(pageArea);
        }
        this.createExclusionItems(exclusions);
    }

    public void addExclusion(PageArea pageArea) {
        Exclusions exclusions = this.getExclusions();
        exclusions.add(pageArea);
        this.createExclusionItems(exclusions);
    }

    private void removeItem(ExclusionItemPanel item) {
        this.exclusionsList.remove(item);
        this.exclusionsList.repaint();
        this.display.redrawImages();
    }

    public ExclusionItemPanel getItemForArea(PageArea pageArea) {
        if (pageArea == null) {
            return null;
        }
        for (ExclusionItemPanel item : this.getExclusionItemPanels()) {
            PageArea itemArea = item.getData();
            if (!pageArea.equals(itemArea)) continue;
            return item;
        }
        return null;
    }

    public ExclusionItemPanel getItemAt(int pageNumber, int x, int y) {
        for (ExclusionItemPanel item : this.getExclusionItemPanels()) {
            PageArea itemArea = item.getData();
            if (itemArea == null || itemArea.getPage() != pageNumber && itemArea.getPage() != -1 || !itemArea.contains(x, y)) continue;
            return item;
        }
        return null;
    }

    public void setSelectedItem(ExclusionItemPanel item) {
        if (this.selectedItem != null) {
            this.selectedItem.setBorder(null);
        }
        this.selectedItem = item;
        if (this.selectedItem != null) {
            this.selectedItem.setBorder(BorderFactory.createBevelBorder(1));
        }
        this.display.redrawImages();
    }

    public boolean isSelected(PageArea pageArea) {
        if (this.selectedItem == null) {
            return false;
        }
        PageArea selectedArea = this.selectedItem.getData();
        if (selectedArea == null) {
            return false;
        }
        return selectedArea.equals(pageArea);
    }

    private void createExclusionItems(Exclusions exclusions) {
        this.exclusionsList.removeAll();
        exclusions.forEach(e -> {
            final ExclusionItemPanel item = new ExclusionItemPanel((PageArea)e);
            item.addActionListener(event -> {
                if ("input_changed".equals(event.getActionCommand())) {
                    this.display.redrawImages();
                }
                if ("got_focus".equals(event.getActionCommand())) {
                    this.setSelectedItem((ExclusionItemPanel)event.getSource());
                }
                if ("remove".equals(event.getActionCommand())) {
                    this.removeItem((ExclusionItemPanel)event.getSource());
                }
            });
            item.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    PageArea pageArea;
                    if (event.getClickCount() == 1) {
                        if (ExclusionsPanel.this.isSelected(item.getData())) {
                            ExclusionsPanel.this.setSelectedItem(null);
                        } else {
                            ExclusionsPanel.this.setSelectedItem(item);
                        }
                    }
                    if (event.getClickCount() == 2 && (pageArea = item.getData()) != null) {
                        ExclusionsPanel.this.display.showPageArea(pageArea);
                    }
                }
            });
            this.exclusionsList.add(item);
        });
        this.exclusionsList.revalidate();
    }

    public Exclusions getExclusions() {
        Exclusions exclusions = new Exclusions(this.environment);
        for (Component component : this.exclusionsList.getComponents()) {
            PageArea pageArea;
            if (!(component instanceof ExclusionItemPanel) || (pageArea = ((ExclusionItemPanel)component).getData()) == null) continue;
            exclusions.add(pageArea);
        }
        return exclusions;
    }

    public List<ExclusionItemPanel> getExclusionItemPanels() {
        ArrayList<ExclusionItemPanel> itemPanels = new ArrayList<ExclusionItemPanel>();
        for (Component component : this.exclusionsList.getComponents()) {
            if (!(component instanceof ExclusionItemPanel)) continue;
            itemPanels.add((ExclusionItemPanel)component);
        }
        return itemPanels;
    }

    void openExclusionFile(File exclusionFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.selectedFile = exclusionFile;
            Exclusions exclusions = new Exclusions(this.environment);
            this.setSelectedFile(exclusionFile);
            if (exclusionFile != null) {
                exclusions.readExclusions(exclusionFile);
            }
            this.createExclusionItems(exclusions);
            this.display.redrawImages();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveExclusionFile(File exclusionFile) throws IOException {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try (BufferedWriter writer = Files.newBufferedWriter(exclusionFile.toPath(), new OpenOption[0]);){
            writer.write(this.getExclusions().asJson());
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private static void addToolBarButton(JToolBar toolBar, String label, String tooltip, ActionListener actionListener) {
        JButton button = new JButton(label);
        button.setFocusable(false);
        button.addActionListener(actionListener);
        button.setToolTipText(tooltip);
        toolBar.add(button);
    }

    private static JFrame getFrame(Container component) {
        while (component != null && !(component instanceof JFrame)) {
            component = component.getParent();
        }
        return (JFrame)component;
    }

    public void setSelectedFile(File ef) {
        this.selectedFile = ef;
        if (ef != null) {
            this.configFile.setText(ef.getName());
        } else {
            this.configFile.setText("unknown");
        }
    }
}

