/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="jars-lock", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.TEST)
public class JarsLockMojo
extends AbstractMojo {
    private static final String JARS_HOME = "JARS_HOME";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="Jars.lock", property="jars.lock")
    public File jarsLock;
    @Parameter(property="jars.home")
    public File jarsHome;
    @Parameter(defaultValue="false", property="jars.force")
    public boolean force;
    @Parameter(property="jars.update")
    public String update;
    @Parameter
    public List<String> gems = Collections.emptyList();
    @Parameter(property="jars.outputFile")
    File outputFile;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.update != null) {
            this.updateArtifact();
        } else {
            this.processJarsLock();
        }
    }

    void processJarsLock() throws MojoExecutionException {
        List<String> lines = this.toLines(this.getArtifacts());
        try {
            switch (this.checkForUpdates(lines)) {
                case NEEDS_FORCED_UPDATE: {
                    this.getLog().info((CharSequence)this.message(this.jarsLock() + " has outdated dependencies"));
                    this.resolve(true);
                    break;
                }
                case CAN_UPDATE: {
                    this.updateJarsLock(lines);
                    break;
                }
                case UP_TO_DATE: {
                    this.getLog().info((CharSequence)this.message(this.jarsLock() + " is up to date"));
                    this.vendorJars();
                }
            }
        }
        catch (IOException e) {
            throw this.exception("can not read " + this.jarsLock, e);
        }
    }

    private List<Artifact> getArtifacts() {
        List artifacts = this.project.getRuntimeArtifacts();
        artifacts.addAll(this.project.getSystemArtifacts());
        for (String gem : this.gems) {
            if (!gem.endsWith(":")) {
                gem = gem + ":";
            }
            ArtifactResolutionRequest request = new ArtifactResolutionRequest();
            request.setResolveTransitively(true);
            request.setCollectionFilter(new ArtifactFilter(){

                public boolean include(Artifact artifact) {
                    return artifact.getDependencyTrail() == null || artifact.getType().equals("jar");
                }
            });
            request.setResolveRoot(true);
            request.setArtifact(this.createArtifact("rubygems:" + gem, "pom"));
            request.setLocalRepository(this.localRepository);
            request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            ArtifactResolutionResult result = this.repositorySystem.resolve(request);
            artifacts.addAll(result.getArtifacts());
        }
        return artifacts;
    }

    private void updateJarsLock(List<String> lines) throws MojoExecutionException {
        String action = this.jarsLock.exists() ? "updated" : "created";
        try {
            this.writeJarsLock(lines);
        }
        catch (IOException e) {
            throw this.exception("can not write " + this.jarsLock(), e);
        }
        try {
            this.vendorJars();
        }
        catch (IOException e) {
            throw this.exception("can not vendor jars from " + this.jarsLock(), e);
        }
        this.getLog().info((CharSequence)this.message(this.jarsLock() + " " + action));
    }

    private MojoExecutionException exception(String text, IOException e) {
        return new MojoExecutionException(this.message(text), (Exception)e);
    }

    private String message(String text) {
        if (this.outputFile != null) {
            try {
                FileUtils.fileAppend((String)this.outputFile.getPath(), (String)(text + "\n"));
            }
            catch (IOException e) {
                throw new RuntimeException("error writing text to output-file: " + text, e);
            }
        }
        return text;
    }

    private List<String> toLines(Collection<Artifact> artifacts) {
        LinkedList<String> lines = new LinkedList<String>();
        for (Artifact a : artifacts) {
            String line = this.toLine(a);
            if (line == null) continue;
            lines.add(line);
        }
        return lines;
    }

    private void updateArtifact() throws MojoExecutionException {
        ArtifactResolutionResult result = this.resolveUpdate();
        if (result == null) {
            this.getLog().error((CharSequence)this.message("no such artifact in " + this.jarsLock() + ": " + this.update));
        } else if (result.isSuccess()) {
            for (Artifact a : result.getArtifacts()) {
                if (!a.getArtifactId().equals(this.update)) continue;
                this.getLog().info((CharSequence)this.message("updated " + a));
                break;
            }
            this.updateJarsLock(this.toLines(result.getArtifacts()));
        } else {
            for (Exception e : result.getExceptions()) {
                this.getLog().error((CharSequence)this.message(e.getMessage()));
            }
            for (Artifact a : result.getMissingArtifacts()) {
                this.getLog().error((CharSequence)this.message("missing artifact: " + a));
            }
        }
    }

    private ArtifactResolutionResult resolveUpdate() throws MojoExecutionException {
        return this.resolve(false);
    }

    private ArtifactResolutionResult resolve(boolean hasUpdate) throws MojoExecutionException {
        List<String> jars = this.loadJarsLock();
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (String jar : jars) {
            Artifact a = this.createArtifact(jar, "jar");
            if (a == null) continue;
            if (a.getArtifactId().equals(this.update)) {
                try {
                    a.setVersionRange(VersionRange.createFromVersionSpec((String)("[" + a.getVersion() + ",)")));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new RuntimeException("something wrong with creating version range", e);
                }
                hasUpdate = true;
            }
            artifacts.add(a);
        }
        if (!hasUpdate) {
            return null;
        }
        request.setArtifactDependencies(artifacts);
        request.setResolveTransitively(false);
        request.setResolveRoot(false);
        request.setArtifact(this.project.getArtifact());
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        return this.repositorySystem.resolve(request);
    }

    private Artifact createArtifact(String jar, String type) {
        if (!jar.endsWith(":") || jar.startsWith("#")) {
            return null;
        }
        String[] parts = jar.split(":");
        if (parts.length == 3) {
            return this.repositorySystem.createArtifact(parts[0], parts[1], parts[2], "compile", type);
        }
        if (parts.length == 4) {
            return this.repositorySystem.createArtifact(parts[0], parts[1], parts[2], parts[3], type);
        }
        if (parts.length == 5) {
            Artifact a = this.repositorySystem.createArtifactWithClassifier(parts[0], parts[1], parts[3], type, parts[2]);
            a.setScope(parts[4]);
            return a;
        }
        this.getLog().warn((CharSequence)this.message("ignore :" + jar));
        return null;
    }

    private String jarsLock() {
        return this.jarsLock.getAbsolutePath().replace(this.project.getBasedir().getAbsolutePath() + File.separator, "");
    }

    private void vendorJars() throws IOException {
        if (this.jarsHome == null && System.getenv(JARS_HOME) != null) {
            this.jarsHome = new File(System.getenv(JARS_HOME));
        }
        if (this.jarsHome != null) {
            this.jarsHome.mkdirs();
        }
        if (this.jarsHome == null || !this.jarsHome.exists() || !this.jarsHome.isDirectory()) {
            return;
        }
        this.getLog().info((CharSequence)this.message("vendor jars:"));
        for (Artifact a : this.getArtifacts()) {
            if (a.getType().equals("jar") && !a.getScope().equals("system")) {
                File target = new File(this.jarsHome, a.getGroupId().replace(".", File.separator) + File.separator + a.getArtifactId() + File.separator + a.getVersion() + File.separator + a.getFile().getName());
                if (this.force || a.getFile().length() != target.length() && !a.getFile().equals(target)) {
                    this.getLog().info((CharSequence)this.message("\t- create " + target));
                    FileUtils.copyFile((File)a.getFile(), (File)target);
                } else {
                    this.getLog().info((CharSequence)this.message("\t- exists " + target));
                }
            }
            this.getLog().info((CharSequence)this.message(""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJarsLock(List<String> lines) throws FileNotFoundException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(this.jarsLock);
            for (String line : lines) {
                out.println(line);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Writer)out);
    }

    private Status checkForUpdates(List<String> lines) throws IOException, MojoExecutionException {
        if (this.force) {
            return Status.CAN_UPDATE;
        }
        if (this.jarsLock.exists()) {
            TreeSet<String> newLines = new TreeSet<String>(lines);
            TreeSet<String> oldLines = new TreeSet<String>(this.loadJarsLock());
            TreeSet<String> newLinesClone = new TreeSet<String>((Collection<String>)newLines);
            TreeSet<String> oldLinesClone = new TreeSet<String>((Collection<String>)oldLines);
            oldLinesClone.removeAll(newLines);
            newLinesClone.removeAll(oldLines);
            TreeSet<String> diffOld = new TreeSet<String>();
            for (String string : oldLinesClone) {
                diffOld.add(string.replaceFirst("^([^:]+:[^:]+):.*", "$1"));
            }
            TreeSet<String> diffNew = new TreeSet<String>();
            for (String dep : newLinesClone) {
                diffNew.add(dep.replaceFirst("^([^:]+:[^:]+):.*", "$1"));
            }
            boolean bl2 = !new TreeSet(diffOld).removeAll(diffNew);
            bl2 = bl2 && !diffNew.removeAll(diffOld);
            Status result = Status.NEEDS_FORCED_UPDATE;
            if (newLines.equals(oldLines)) {
                result = Status.UP_TO_DATE;
            } else if (bl2) {
                result = Status.CAN_UPDATE;
            }
            if (result != Status.UP_TO_DATE && this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("missing : " + newLinesClone));
                this.getLog().info((CharSequence)("obsolete: " + oldLinesClone));
            }
            return result;
        }
        return Status.CAN_UPDATE;
    }

    private List<String> loadJarsLock() throws MojoExecutionException {
        try {
            return FileUtils.loadFile((File)this.jarsLock);
        }
        catch (IOException e) {
            throw this.exception("can not read " + this.jarsLock, e);
        }
    }

    private String toLine(Artifact a) {
        if (!a.getType().equals("jar")) {
            return null;
        }
        StringBuilder line = new StringBuilder(a.toString().replace(":jar:", ":"));
        line.append(":");
        if (a.getScope().equals("system")) {
            line.append(this.getSystemFile(a.getFile().getPath()));
        }
        return line.toString();
    }

    private String getSystemFile(String file) {
        for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
            String key = prop.getKey().toString();
            String value = prop.getValue().toString();
            int index = file.indexOf(value);
            if (index <= -1 || !new File(value).isDirectory() || "file.separator".equals(key)) continue;
            return file.replace(value, "${" + key + "}");
        }
        return "";
    }

    private static enum Status {
        CAN_UPDATE,
        NEEDS_FORCED_UPDATE,
        UP_TO_DATE;

    }
}

