/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.db;

import edu.cmu.lti.jawjaw.db.SQL;
import edu.cmu.lti.jawjaw.db.SQLQuery;
import edu.cmu.lti.jawjaw.pobj.Lang;
import edu.cmu.lti.jawjaw.pobj.Sense;
import edu.cmu.lti.jawjaw.util.Configuration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SenseDAO {
    private static ConcurrentMap<String, List<Sense>> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Sense> findSensesBySynset(String synset) {
        List cachedObj;
        String key = synset;
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return SenseDAO.clone(cachedObj);
        }
        ArrayList<Sense> senses = new ArrayList<Sense>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_SENSES_BY_SYNSET);
            synchronized (preparedStatement) {
                ps.setString(1, synset);
                rs = ps.executeQuery();
                while (rs.next()) {
                    senses.add(SenseDAO.rsToObject(rs));
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (senses != null) {
                cache.put(key, SenseDAO.clone(senses));
            }
        }
        return senses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Sense> findSensesByWordid(int wordid) {
        List cachedObj;
        String key = wordid + "";
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return SenseDAO.clone(cachedObj);
        }
        ArrayList<Sense> senses = new ArrayList<Sense>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_SENSES_BY_WORDID);
                synchronized (preparedStatement) {
                    ps.setInt(1, wordid);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        senses.add(SenseDAO.rsToObject(rs));
                    }
                    rs.close();
                    rs = null;
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (senses != null) {
                cache.put(key, SenseDAO.clone(senses));
            }
        }
        return senses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Sense> findSensesBySynsetAndLang(String synset, Lang lang) {
        List cachedObj;
        String key = synset + " " + (Object)((Object)lang);
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return SenseDAO.clone(cachedObj);
        }
        ArrayList<Sense> senses = new ArrayList<Sense>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_SENSES_BY_SYNSET_AND_LANG);
            synchronized (preparedStatement) {
                ps.setString(1, synset);
                ps.setString(2, lang.toString());
                rs = ps.executeQuery();
                while (rs.next()) {
                    senses.add(SenseDAO.rsToObject(rs));
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (senses != null) {
                cache.put(key, SenseDAO.clone(senses));
            }
        }
        return senses;
    }

    private static Sense rsToObject(ResultSet rs) throws SQLException {
        Sense sense = new Sense(rs.getString(1), rs.getInt(2), Lang.valueOf(rs.getString(3)), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getString(7));
        return sense;
    }

    private static List<Sense> clone(List<Sense> senses) {
        ArrayList<Sense> cloned = new ArrayList<Sense>(senses.size());
        for (Sense sense : senses) {
            cloned.add(sense.clone());
        }
        return senses;
    }

    static {
        if (Configuration.getInstance().useCache()) {
            cache = new ConcurrentHashMap<String, List<Sense>>(Configuration.getInstance().getMaxCacheSize());
        }
    }
}

