/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.db;

import edu.cmu.lti.jawjaw.db.SQL;
import edu.cmu.lti.jawjaw.db.SQLQuery;
import edu.cmu.lti.jawjaw.pobj.Link;
import edu.cmu.lti.jawjaw.pobj.Synlink;
import edu.cmu.lti.jawjaw.util.Configuration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SynlinkDAO {
    private static ConcurrentMap<String, List<Synlink>> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Synlink> findSynlinksBySynset(String synset) {
        List cachedObj;
        String key = synset;
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return SynlinkDAO.clone(cachedObj);
        }
        ArrayList<Synlink> synlinks = new ArrayList<Synlink>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_SYNLINK_BY_SYNSET);
            synchronized (preparedStatement) {
                ps.setString(1, synset);
                rs = ps.executeQuery();
                while (rs.next()) {
                    synlinks.add(SynlinkDAO.rsToObject(rs));
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (synlinks != null) {
                cache.put(key, SynlinkDAO.clone(synlinks));
            }
        }
        return synlinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Synlink> findSynlinksBySynsetAndLink(String synset, Link link) {
        List cachedObj;
        String key = synset + " " + link.toString();
        if (Configuration.getInstance().useCache() && (cachedObj = (List)cache.get(key)) != null) {
            return SynlinkDAO.clone(cachedObj);
        }
        ArrayList<Synlink> synlinks = new ArrayList<Synlink>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_SYNLINK_BY_SYNSET_AND_LINK);
            synchronized (preparedStatement) {
                ps.setString(1, synset);
                ps.setString(2, link.toString());
                rs = ps.executeQuery();
                while (rs.next()) {
                    synlinks.add(SynlinkDAO.rsToObject(rs));
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (synlinks != null) {
                cache.put(key, SynlinkDAO.clone(synlinks));
            }
        }
        return synlinks;
    }

    private static Synlink rsToObject(ResultSet rs) throws SQLException {
        Synlink synlink = new Synlink(rs.getString(1), rs.getString(2), Link.valueOf(rs.getString(3)), rs.getString(4));
        return synlink;
    }

    private static List<Synlink> clone(List<Synlink> synlinks) {
        ArrayList<Synlink> cloned = new ArrayList<Synlink>(synlinks.size());
        for (Synlink synlink : synlinks) {
            cloned.add(synlink.clone());
        }
        return synlinks;
    }

    static {
        if (Configuration.getInstance().useCache()) {
            cache = new ConcurrentHashMap<String, List<Synlink>>(Configuration.getInstance().getMaxCacheSize());
        }
    }
}

