/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.db;

import edu.cmu.lti.jawjaw.db.SQL;
import edu.cmu.lti.jawjaw.db.SQLQuery;
import edu.cmu.lti.jawjaw.pobj.Lang;
import edu.cmu.lti.jawjaw.pobj.SynsetDef;
import edu.cmu.lti.jawjaw.util.Configuration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SynsetDefDAO {
    private static ConcurrentMap<String, SynsetDef> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynsetDef findSynsetDefBySynsetAndLang(String synset, Lang lang) {
        SynsetDef cachedObj;
        String key = synset + " " + lang.toString();
        if (Configuration.getInstance().useCache() && (cachedObj = (SynsetDef)cache.get(key)) != null) {
            return cachedObj.clone();
        }
        SynsetDef synsetDef = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = ps = SQL.getInstance().getPreparedStatement(SQLQuery.FIND_SYNSETDEF_BY_SYNSET_AND_LANG);
            synchronized (preparedStatement) {
                ps.setString(1, synset);
                ps.setString(2, lang.toString());
                rs = ps.executeQuery();
                if (rs.next()) {
                    synsetDef = SynsetDefDAO.rsToObject(rs);
                }
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (synsetDef != null) {
                cache.put(key, synsetDef.clone());
            }
        }
        return synsetDef;
    }

    private static SynsetDef rsToObject(ResultSet rs) throws SQLException {
        SynsetDef synsetDef = new SynsetDef(rs.getString(1), Lang.valueOf(rs.getString(2)), rs.getString(3), rs.getInt(4));
        return synsetDef;
    }

    static {
        if (Configuration.getInstance().useCache()) {
            cache = new ConcurrentHashMap<String, SynsetDef>(Configuration.getInstance().getMaxCacheSize());
        }
    }
}

