/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.util;

import edu.cmu.lti.jawjaw.db.SenseDAO;
import edu.cmu.lti.jawjaw.db.SynsetDAO;
import edu.cmu.lti.jawjaw.db.WordDAO;
import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.jawjaw.pobj.Synset;
import edu.cmu.lti.jawjaw.util.Configuration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CollectionUtil {
    private static ConcurrentMap<String, String> cache;
    public static int capacity;

    public static String synsetToOffset(String synset) {
        String cachedObj;
        if (synset.equals("0")) {
            return "*Root*";
        }
        String key = synset;
        if (Configuration.getInstance().useCache() && (cachedObj = (String)cache.get(key)) != null) {
            return cachedObj;
        }
        Synset synsetObj = SynsetDAO.findSynsetBySynset(synset);
        String word = synsetObj.getName();
        int wordid = SenseDAO.findSensesBySynset(synset).get(0).getWordid();
        POS pos = WordDAO.findWordByWordid(wordid).getPos();
        List<Synset> synsets = SynsetDAO.findSynsetsByName(word);
        int index = 0;
        for (int i = 0; i < synsets.size(); ++i) {
            if (!synsets.get(i).getSynset().equals(synset)) continue;
            index = i + 1;
        }
        String offset = word + "#" + pos.toString() + "#" + index;
        if (Configuration.getInstance().useCache()) {
            if (cache.size() >= Configuration.getInstance().getMaxCacheSize()) {
                cache.remove(cache.keySet().iterator().next());
            }
            if (offset != null) {
                cache.put(key, offset);
            }
        }
        return offset;
    }

    static {
        capacity = Configuration.getInstance().getMaxCacheSize();
        cache = new ConcurrentHashMap<String, String>(capacity);
    }
}

