/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.util;

import java.io.InputStream;
import java.util.Properties;

public class Configuration {
    private static final Configuration instance = new Configuration();
    private Properties p;
    private String wordnet;
    private boolean cache;
    private int maxCacheSize;
    private static final String CONF = "/jawjaw.conf";
    private boolean memoryDB;
    private int dbCacheSize;

    private Configuration() {
        InputStream stream = null;
        try {
            stream = Configuration.class.getResourceAsStream(CONF);
            this.p = new Properties();
            this.p.load(stream);
            this.wordnet = this.readString("wordnet", "wnjpn-0.9.db");
            this.cache = this.readInt("cache", 1) == 1;
            this.maxCacheSize = this.readInt("maxCacheSize", 1000);
            this.memoryDB = this.readInt("memoryDB", 1) == 1;
            this.dbCacheSize = this.readInt("dbCacheSize", 2000);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int readInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.readString(key, defaultValue + ""));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private String readString(String key, String defaultValue) {
        String value = this.p.getProperty(key);
        if (value == null) {
            System.err.println("Configuration \"" + key + "\" not found in " + CONF);
            return defaultValue;
        }
        value = value.replaceAll("#.+", "");
        value = value.trim();
        return value;
    }

    public static Configuration getInstance() {
        return instance;
    }

    public int getDbCacheSize() {
        return this.dbCacheSize;
    }

    public void setDbCacheSize(int dbCacheSize) {
        this.dbCacheSize = dbCacheSize;
    }

    public String getWordnet() {
        return this.wordnet;
    }

    public boolean useCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public boolean useMemoryDB() {
        return this.memoryDB;
    }

    public void setMemoryDB(boolean memoryDB) {
        this.memoryDB = memoryDB;
    }
}

