/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.lti.jawjaw.util;

import edu.cmu.lti.jawjaw.db.SenseDAO;
import edu.cmu.lti.jawjaw.db.SynlinkDAO;
import edu.cmu.lti.jawjaw.db.WordDAO;
import edu.cmu.lti.jawjaw.pobj.Lang;
import edu.cmu.lti.jawjaw.pobj.Link;
import edu.cmu.lti.jawjaw.pobj.POS;
import edu.cmu.lti.jawjaw.pobj.Sense;
import edu.cmu.lti.jawjaw.pobj.Synlink;
import edu.cmu.lti.jawjaw.pobj.Synset;
import edu.cmu.lti.jawjaw.pobj.SynsetDef;
import edu.cmu.lti.jawjaw.pobj.Word;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class WordNetUtil {
    public static List<Synset> wordToSynsets(String word, POS pos) {
        List<Word> words = WordDAO.findWordsByLemmaAndPos(word, pos);
        ArrayList<Synset> results = new ArrayList<Synset>();
        for (Word wordObj : words) {
            int wordid = wordObj.getWordid();
            List<Sense> senses = SenseDAO.findSensesByWordid(wordid);
            for (Sense sense : senses) {
                Synset synset = new Synset(sense.getSynset(), null, null, null);
                results.add(synset);
            }
        }
        return results;
    }

    public static List<Word> synsetToWords(String synset) {
        ArrayList<Word> words = new ArrayList<Word>();
        List<Sense> senses = SenseDAO.findSensesBySynset(synset);
        for (Sense sense : senses) {
            Word word = WordDAO.findWordByWordid(sense.getWordid());
            words.add(word);
        }
        return words;
    }

    public static String getGloss(SynsetDef synsetDef) {
        String gloss = synsetDef.getDef().replaceFirst("; \".+", "");
        return gloss;
    }

    public static Set<String> findLinks(String word, POS pos, Link link) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        List<Synset> synsets = WordNetUtil.wordToSynsets(word, pos);
        Lang lang = WordNetUtil.findLang(word);
        for (Synset synset : synsets) {
            List<Synlink> synlinks = SynlinkDAO.findSynlinksBySynsetAndLink(synset.getSynset(), link);
            for (Synlink synlink : synlinks) {
                List<Sense> senses = SenseDAO.findSensesBySynsetAndLang(synlink.getSynset2(), lang);
                for (Sense sense : senses) {
                    Word wordObj = WordDAO.findWordByWordid(sense.getWordid());
                    results.add(wordObj.getLemma());
                }
            }
        }
        return results;
    }

    public static Lang findLang(String word) {
        List<Word> words = WordDAO.findWordsByLemma(word);
        if (words.size() > 0) {
            return words.get(0).getLang();
        }
        return Lang.jpn;
    }

    public static Set<String> findSynonyms(String word, POS pos, boolean translate) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        List<Synset> synsets = WordNetUtil.wordToSynsets(word, pos);
        Lang srcLang = WordNetUtil.findLang(word);
        Lang anotherLang = srcLang.equals((Object)Lang.jpn) ? Lang.eng : Lang.jpn;
        Lang targetLang = translate ? anotherLang : srcLang;
        for (Synset synset : synsets) {
            List<Sense> moreSenses = SenseDAO.findSensesBySynsetAndLang(synset.getSynset(), targetLang);
            for (Sense moreSense : moreSenses) {
                Word synonym = WordDAO.findWordByWordid(moreSense.getWordid());
                results.add(synonym.getLemma());
            }
        }
        results.remove(word);
        return results;
    }
}

