/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import de.undercouch.gradle.tasks.download.internal.DefaultHttpClientFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.client.CloseableHttpClient;

public class CachingHttpClientFactory
extends DefaultHttpClientFactory {
    private Map<CacheKey, CloseableHttpClient> cachedClients = new HashMap<CacheKey, CloseableHttpClient>();

    @Override
    public CloseableHttpClient createHttpClient(HttpHost httpHost, boolean acceptAnyCertificate, HttpRequestInterceptor requestInterceptor, HttpResponseInterceptor responseInterceptor) {
        CacheKey key = new CacheKey(httpHost, acceptAnyCertificate, requestInterceptor, responseInterceptor);
        CloseableHttpClient c = this.cachedClients.get(key);
        if (c == null) {
            c = super.createHttpClient(httpHost, acceptAnyCertificate, requestInterceptor, responseInterceptor);
            this.cachedClients.put(key, c);
        }
        return c;
    }

    public void close() throws IOException {
        for (CloseableHttpClient c : this.cachedClients.values()) {
            c.close();
        }
        this.cachedClients.clear();
    }

    private static class CacheKey {
        private final HttpHost httpHost;
        private final boolean acceptAnyCertificate;
        private final HttpRequestInterceptor requestInterceptor;
        private final HttpResponseInterceptor responseInterceptor;

        CacheKey(HttpHost httpHost, boolean acceptAnyCertificate, HttpRequestInterceptor requestInterceptor, HttpResponseInterceptor responseInterceptor) {
            this.httpHost = httpHost;
            this.acceptAnyCertificate = acceptAnyCertificate;
            this.requestInterceptor = requestInterceptor;
            this.responseInterceptor = responseInterceptor;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.acceptAnyCertificate ? 1231 : 1237);
            result = 31 * result + (this.httpHost == null ? 0 : this.httpHost.hashCode());
            result = 31 * result + (this.requestInterceptor == null ? 0 : System.identityHashCode(this.requestInterceptor));
            result = 31 * result + (this.responseInterceptor == null ? 0 : System.identityHashCode(this.responseInterceptor));
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.acceptAnyCertificate != other.acceptAnyCertificate) {
                return false;
            }
            if (this.httpHost == null ? other.httpHost != null : !this.httpHost.equals((Object)other.httpHost)) {
                return false;
            }
            if (this.requestInterceptor != other.requestInterceptor) {
                return false;
            }
            return this.responseInterceptor == other.responseInterceptor;
        }
    }
}

