/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import de.undercouch.gradle.tasks.download.internal.CustomContentEncodingEntity;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class ContentEncodingNoneInterceptor
implements HttpResponseInterceptor {
    private static final Header IDENTITY = new BasicHeader("Content-Encoding", "identity");

    private static boolean isNone(Header h) {
        return h != null && h.getValue().equalsIgnoreCase("none");
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ce;
        HttpEntity entity;
        Header[] hs;
        for (Header h : hs = response.getHeaders("Content-Encoding")) {
            if (!ContentEncodingNoneInterceptor.isNone(h)) continue;
            response.removeHeaders("Content-Encoding");
            response.addHeader(IDENTITY);
            break;
        }
        if ((entity = response.getEntity()) != null && ContentEncodingNoneInterceptor.isNone(ce = entity.getContentEncoding())) {
            response.setEntity((HttpEntity)new CustomContentEncodingEntity(entity, IDENTITY));
        }
    }
}

