/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.P2Client;
import dev.equo.solstice.p2.P2ClientCache;
import dev.equo.solstice.p2.P2Query;
import dev.equo.solstice.p2.P2Unit;
import dev.equo.solstice.p2.Unchecked;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class P2QueryResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> mavenCoordinates;
    private final List<File> downloadedP2Jars;

    P2QueryResult(P2Query query, P2ClientCache cachingPolicy) {
        this.mavenCoordinates = new ArrayList<String>(query.getJarsOnMavenCentral());
        this.downloadedP2Jars = new ArrayList<File>();
        try (P2Client client = new P2Client(cachingPolicy);){
            for (P2Unit unit : query.getJarsNotOnMavenCentral()) {
                this.downloadedP2Jars.add(client.download(unit));
            }
        }
        catch (IOException e) {
            throw Unchecked.wrap(e);
        }
    }

    public List<String> getJarsOnMavenCentral() {
        return Collections.unmodifiableList(this.mavenCoordinates);
    }

    public List<File> getJarsNotOnMavenCentral() {
        return Collections.unmodifiableList(this.downloadedP2Jars);
    }
}

