/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.common;

import dk.itst.oiosaml.common.SAMLUtil;
import java.io.IOException;
import java.util.List;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.soap11.Fault;

public class SOAPException
extends IOException {
    private static final long serialVersionUID = 6684189535343316988L;
    private final String response;
    private Envelope envelope;

    public SOAPException(int responseCode, String response) {
        super("Server returned error response: " + responseCode);
        this.response = response;
        try {
            this.envelope = (Envelope)SAMLUtil.unmarshallElementFromString(response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public String getResponse() {
        return this.response;
    }

    public Fault getFault() {
        if (this.envelope == null) {
            return null;
        }
        List faults = this.envelope.getBody().getUnknownXMLObjects(Fault.DEFAULT_ELEMENT_NAME);
        if (faults.isEmpty()) {
            return null;
        }
        return (Fault)faults.get(0);
    }
}

