/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.helper;

import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class DeveloperHelper {
    private static final Logger log = LoggerFactory.getLogger(DeveloperHelper.class);

    public static void log(String message) {
        List<String> messageLines = DeveloperHelper.convertToLines(message);
        StringBuilder builder = new StringBuilder();
        builder.append("\n\n *****************************************************************************\n");
        builder.append(" *   DEVELOPER HINT   - the message below might explain the error            *\n");
        builder.append(" *****************************************************************************\n");
        for (String messageLine : messageLines) {
            builder.append(" * " + messageLine + " *\n");
        }
        builder.append(" *****************************************************************************\n\n");
        log.info(builder.toString());
    }

    private static List<String> convertToLines(String message) {
        StringBuilder messageLine;
        ArrayList<String> messageLines = new ArrayList<String>();
        while (true) {
            int cutPoint;
            if (message.length() <= 73) {
                messageLine = new StringBuilder(message);
                while (messageLine.length() < 73) {
                    messageLine.append(" ");
                }
                break;
            }
            for (cutPoint = 73; cutPoint >= 0 && message.charAt(cutPoint) != ' '; --cutPoint) {
            }
            if (cutPoint == 0) {
                cutPoint = 73;
            }
            StringBuilder messageLine2 = new StringBuilder(message.substring(0, cutPoint));
            while (messageLine2.length() < 73) {
                messageLine2.append(" ");
            }
            messageLines.add(messageLine2.toString());
            while (message.length() > cutPoint && message.charAt(cutPoint) == ' ') {
                ++cutPoint;
            }
            message = message.substring(cutPoint);
        }
        messageLines.add(messageLine.toString());
        return messageLines;
    }
}

