/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.logging;

import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.UserAssertion;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;

public class Audit {
    private static Logger log = LoggerFactory.getLogger("OIOSAML_AUDIT_LOGGER");
    private static final ThreadLocal<MessageFormat> format = new ThreadLocal<MessageFormat>(){

        @Override
        protected MessageFormat initialValue() {
            return new MessageFormat("{0} {1,choice,-1#---|0#-->|1#'<'--} {2} {3} ''{4}'' ''{5}'' ''{6}''");
        }
    };
    private static final ThreadLocal<String> remoteAddress = new ThreadLocal();
    private static final ThreadLocal<String> session = new ThreadLocal();
    private static final ThreadLocal<String> assertionId = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "";
        }
    };

    public static void log(Operation operation, String msg) {
        Audit.logEntry(operation.name(), null, "", msg);
    }

    public static void log(Operation operation, boolean out, String id, String request) {
        if (id != null && !"".equals(id)) {
            Audit.logEntry(operation.name(), out, request, "RequestID " + id);
        } else {
            Audit.logEntry(operation.name(), out, request, "");
        }
    }

    private static void logEntry(String operation, Boolean out, String data, String msg) {
        int dir = Audit.getDirection(out);
        if (msg == null) {
            msg = "";
        }
        String entry = format.get().format(new Object[]{operation, dir, remoteAddress.get(), session.get(), assertionId.get(), data, msg.replace('\n', ' ')});
        log.info(entry);
    }

    public static void logSystem(String sessionId, String assId, Operation operation, String msg) {
        int dir = Audit.getDirection(null);
        if (msg == null) {
            msg = "";
        }
        String entry = format.get().format(new Object[]{operation, dir, "127.0.0.1", sessionId, assId, "", msg.replace('\n', ' ')});
        log.info(entry);
    }

    public static void logError(Operation operation, boolean out, String id, Throwable t) {
        Audit.logError(operation.name(), (Boolean)out, t.getMessage(), t);
    }

    public static void logError(String action, boolean b, Exception e) {
        Audit.logError("Dispatch:" + action, (Boolean)b, e.getMessage(), (Throwable)e);
    }

    public static void logError(Operation operation, boolean out, String id, String error) {
        Audit.logError(operation.name(), (Boolean)out, error, null);
    }

    private static void logError(String operation, Boolean out, String msg, Throwable e) {
        String entry = format.get().format(new Object[]{operation, Audit.getDirection(out), remoteAddress.get(), session.get(), assertionId.get(), "", msg});
        log.error(entry, e);
    }

    private static int getDirection(Boolean out) {
        int dir = out == null ? -1 : (out != false ? 0 : 1);
        return dir;
    }

    public static void init(HttpServletRequest request) {
        log.info("Session created at: " + request.getSession().getCreationTime() + ", timeout after " + request.getSession().getMaxInactiveInterval() + " seconds");
        remoteAddress.set(request.getRemoteAddr());
        session.set(request.getSession().getId());
        UserAssertion ua = (UserAssertion)request.getSession().getAttribute("dk.itst.oiosaml.userassertion");
        if (ua != null) {
            assertionId.set(ua.getAssertionId());
        } else {
            assertionId.set("");
        }
    }

    public static void setAssertionId(String id) {
        assertionId.set(id);
    }
}

