/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.security;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Date;
import org.apache.xml.security.algorithms.JCEMapper;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.util.Base64;

public class SecurityHelper {
    public static final String VERSION = "$Id: SecurityHelper.java 2836 2008-05-14 06:22:24Z jre $";

    private SecurityHelper() {
    }

    public static X509Certificate buildJavaX509Cert(String base64Cert) throws CertificateException {
        CertificateFactory cf = null;
        cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream input = new ByteArrayInputStream(Base64.decode((String)base64Cert));
        X509Certificate newCert = null;
        newCert = (X509Certificate)cf.generateCertificate(input);
        return newCert;
    }

    public static X509CRL buildJavaX509CRL(String base64CRL) throws CertificateException, CRLException {
        CertificateFactory cf = null;
        cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream input = new ByteArrayInputStream(Base64.decode((String)base64CRL));
        X509CRL newCRL = null;
        newCRL = (X509CRL)cf.generateCRL(input);
        return newCRL;
    }

    public static PublicKey buildKey(KeySpec keySpec, String keyAlgorithm) throws KeyException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException(keyAlgorithm + "algorithm is not supported by the JCE:" + e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            throw new KeyException("Invalid key information:" + e.getMessage());
        }
    }

    public static KeyPair generateKeyPairFromURI(String algoURI, int keyLength) throws NoSuchAlgorithmException, NoSuchProviderException {
        String jceAlgorithmName = JCEMapper.getJCEKeyAlgorithmFromURI((String)algoURI);
        return SecurityHelper.generateKeyPair(jceAlgorithmName, keyLength, null);
    }

    public static KeyPair generateKeyPair(String algo, int keyLength, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair keyPair = null;
        KeyPairGenerator keyGenerator = null;
        keyGenerator = provider != null ? KeyPairGenerator.getInstance(algo, provider) : KeyPairGenerator.getInstance(algo);
        keyGenerator.initialize(keyLength);
        keyPair = keyGenerator.generateKeyPair();
        return keyPair;
    }

    public static X509Certificate generateCertificate(Credential credential, String entityId) throws Exception {
        X500Name issuer = new X500Name("o=keymanager, ou=oiosaml-sp");
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        Date notBefore = new Date();
        Date notAfter = new Date(System.currentTimeMillis() + 315360000000L);
        X500Name subject = new X500Name("cn=" + entityId + ", ou=oiosaml-sp");
        ByteArrayInputStream bIn = new ByteArrayInputStream(credential.getPublicKey().getEncoded());
        ASN1InputStream asn1in = new ASN1InputStream((InputStream)bIn);
        SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)asn1in.readObject());
        asn1in.close();
        X509v3CertificateBuilder gen = new X509v3CertificateBuilder(issuer, serialNumber, notBefore, notAfter, subject, publicKeyInfo);
        gen.addExtension(X509Extension.subjectKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createSubjectKeyIdentifier(credential.getPublicKey()));
        gen.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(credential.getPublicKey()));
        ContentSigner sigGen = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(credential.getPrivateKey());
        X509CertificateHolder certificateHolder = gen.build(sigGen);
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
        return x509Certificate;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

