/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp;

import dk.itst.oiosaml.security.SecurityHelper;
import dk.itst.oiosaml.sp.NameIDFormat;
import dk.itst.oiosaml.sp.UserAssertion;
import dk.itst.oiosaml.sp.UserAttribute;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.util.AttributeUtil;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnStatement;

public class UserAssertionImpl
implements UserAssertion,
Serializable {
    private static final long serialVersionUID = -1756335950388129831L;
    private Map<String, UserAttribute> attributes = new HashMap<String, UserAttribute>();
    private Date issueTime;
    private String issuer;
    private Date sessionExpireTime;
    private NameIDFormat nameIDFormat;
    private String nameID;
    private boolean signed;
    private String xml;
    private String id;

    public UserAssertionImpl(OIOAssertion assertion) {
        DateTime expireTime;
        for (AttributeStatement attrStatement : assertion.getAssertion().getAttributeStatements()) {
            for (Attribute attr : attrStatement.getAttributes()) {
                if (this.attributes.containsKey(attr.getName())) {
                    UserAttribute userAttribute = this.attributes.get(attr.getName());
                    List<String> values = AttributeUtil.extractAttributeValueValues(attr);
                    for (String value : values) {
                        userAttribute.getValues().add(value);
                    }
                    continue;
                }
                this.attributes.put(attr.getName(), new UserAttribute(attr.getName(), attr.getFriendlyName(), AttributeUtil.extractAttributeValueValues(attr), attr.getNameFormat()));
            }
        }
        this.id = assertion.getID();
        if (assertion.getAssertion().getIssueInstant() != null) {
            this.issueTime = assertion.getAssertion().getIssueInstant().toDate();
        }
        if (assertion.getAssertion().getIssuer() != null) {
            this.issuer = assertion.getAssertion().getIssuer().getValue();
        }
        if (!assertion.getAssertion().getAuthnStatements().isEmpty() && (expireTime = ((AuthnStatement)assertion.getAssertion().getAuthnStatements().get(0)).getSessionNotOnOrAfter()) != null) {
            this.sessionExpireTime = expireTime.toDate();
        }
        if (assertion.getAssertion().getSubject() != null) {
            this.nameIDFormat = NameIDFormat.getNameID(assertion.getAssertion().getSubject().getNameID().getFormat());
            this.nameID = assertion.getAssertion().getSubject().getNameID().getValue();
        }
        this.signed = assertion.getAssertion().getSignature() != null;
        try {
            this.xml = assertion.toXML();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Collection<UserAttribute> getAllAttributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    @Override
    public int getAssuranceLevel() {
        String level = this.getAttributeValue("dk:gov:saml:attribute:AssuranceLevel");
        if (level == null) {
            return 0;
        }
        if ("test".equals(level)) {
            return -1;
        }
        return Integer.valueOf(level);
    }

    @Override
    public UserAttribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public String getCVRNumberIdentifier() {
        return this.getAttributeValue("dk:gov:saml:attribute:CvrNumberIdentifier");
    }

    @Override
    public String getCertificateSerialNumber() {
        return this.getAttributeValue("urn:oid:2.5.4.5");
    }

    @Override
    public String getCommonName() {
        return this.getAttributeValue("urn:oid:2.5.4.3");
    }

    @Override
    public Date getIssueTime() {
        return this.issueTime;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getMail() {
        return this.getAttributeValue("urn:oid:0.9.2342.19200300.100.1.3");
    }

    @Override
    public NameIDFormat getNameIDFormat() {
        return this.nameIDFormat;
    }

    @Override
    public String getOrganizationName() {
        return this.getAttributeValue("urn:oid:2.5.4.10");
    }

    @Override
    public String getOrganizationUnit() {
        return this.getAttributeValue("urn:oid:2.5.4.11");
    }

    @Override
    public String getPostalAddress() {
        return this.getAttributeValue("urn:oid:2.5.4.16");
    }

    @Override
    public Date getSessionExpireTime() {
        return this.sessionExpireTime;
    }

    @Override
    public String getSpecificationVersion() {
        return this.getAttributeValue("dk:gov:saml:attribute:SpecVer");
    }

    @Override
    public String getSubject() {
        return this.nameID;
    }

    @Override
    public String getSurname() {
        return this.getAttributeValue("urn:oid:2.5.4.4");
    }

    @Override
    public String getTitle() {
        return this.getAttributeValue("urn:oid:2.5.4.12");
    }

    @Override
    public String getUniqueAccountKey() {
        return this.getAttributeValue("dk:gov:saml:attribute:UniqueAccountKey");
    }

    @Override
    public String getUserId() {
        return this.getAttributeValue("urn:oid:0.9.2342.19200300.100.1.1");
    }

    @Override
    public String getXML() {
        return this.xml;
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    private String getAttributeValue(String name) {
        List<String> values;
        UserAttribute attr = this.attributes.get(name);
        if (attr != null && (values = attr.getValues()).size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public String getCPRNumber() {
        return this.getAttributeValue("dk:gov:saml:attribute:CprNumberIdentifier");
    }

    @Override
    public String getRIDNumber() {
        return this.getAttributeValue("dk:gov:saml:attribute:RidNumberIdentifier");
    }

    @Override
    public String getPIDNumber() {
        return this.getAttributeValue("dk:gov:saml:attribute:PidNumberIdentifier");
    }

    @Override
    public String getPseudonym() {
        return this.getAttributeValue("urn:oid:2.5.4.65");
    }

    @Override
    public X509Certificate getUserCertificate() {
        String val = this.getAttributeValue("urn:oid:1.3.6.1.4.1.1466.115.121.1.8");
        if (val == null) {
            return null;
        }
        try {
            return SecurityHelper.buildJavaX509Cert(val);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isOCESProfileCompliant() {
        boolean res = this.isOIOSAMLCompliant();
        try {
            res &= NameIDFormat.X509SUBJECT.equals((Object)this.getNameIDFormat());
            res &= this.getCertificateSerialNumber() != null;
            res &= this.isYouthCertificate() != null;
            res &= this.getPIDNumber() != null ^ this.getRIDNumber() != null;
            if (this.getPIDNumber() != null) {
                res &= ("PID:" + this.getPIDNumber()).equals(this.getUserId());
            } else if (this.getRIDNumber() != null) {
                res &= this.getCVRNumberIdentifier() != null;
                res &= ("CVR:" + this.getCVRNumberIdentifier() + "-RID:" + this.getRIDNumber()).equals(this.getUserId());
            }
            return res;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public boolean isOIOSAMLCompliant() {
        boolean res = true;
        res &= "DK-SAML-2.0".equals(this.getSpecificationVersion());
        res &= this.getAssuranceLevel() > 0;
        res &= this.getSurname() != null;
        res &= this.getCommonName() != null;
        res &= this.getUserId() != null;
        return res &= this.getMail() != null;
    }

    @Override
    public boolean isPersistentPseudonymProfileCompliant() {
        boolean res = true;
        res &= "DK-SAML-2.0".equals(this.getSpecificationVersion());
        res &= this.getAssuranceLevel() > 0;
        res &= this.getUserId() == null;
        res &= NameIDFormat.PERSISTENT.equals((Object)this.getNameIDFormat());
        res &= this.getPIDNumber() == null;
        res &= this.getRIDNumber() == null;
        res &= this.getCertificateSerialNumber() == null;
        res &= this.getMail() == null;
        res &= this.getSurname() == null;
        return res &= this.getCommonName() == null;
    }

    @Override
    public Boolean isYouthCertificate() {
        String val = this.getAttributeValue("dk:gov:saml:attribute:IsYouthCert");
        if (val == null) {
            return null;
        }
        return Boolean.valueOf(val);
    }

    @Override
    public String getAssertionId() {
        return this.id;
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }
}

