/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.xml.util.Base64;

public class UserAttribute
implements Serializable {
    private static final long serialVersionUID = 7213348395041737852L;
    private final String name;
    private final String friendlyName;
    private final List<String> values;
    private final String format;

    public UserAttribute(String name, String friendlyName, List<String> values, String format) {
        this.name = name;
        this.friendlyName = friendlyName;
        this.values = values;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public List<String> getValues() {
        if (this.values == null) {
            return new ArrayList<String>();
        }
        return this.values;
    }

    public String getValue() {
        if (this.values == null || this.values.size() == 0) {
            return null;
        }
        return this.values.get(0);
    }

    public List<byte[]> getBase64Values() {
        ArrayList<byte[]> base64Values = new ArrayList<byte[]>();
        if (this.values == null) {
            return new ArrayList<byte[]>();
        }
        for (String str : this.values) {
            base64Values.add(Base64.decode((String)str));
        }
        return base64Values;
    }

    public byte[] getBase64Value() {
        if (this.values == null || this.values.size() == 0) {
            return null;
        }
        return Base64.decode((String)this.values.get(0));
    }

    public String getFormat() {
        return this.format;
    }

    public static UserAttribute create(String name, String format) {
        if (format != null && format.trim().equals("")) {
            format = null;
        }
        return new UserAttribute(name, null, null, format);
    }

    public String toString() {
        return this.name + " (" + this.friendlyName + "): " + this.values;
    }
}

