/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.bindings;

import dk.itst.oiosaml.configuration.SAMLConfigurationFactory;
import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.bindings.BindingHandler;
import dk.itst.oiosaml.sp.model.OIOAuthnRequest;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.xml.security.credential.Credential;

public class PostBindingHandler
implements BindingHandler {
    private static final Logger log = LoggerFactory.getLogger(PostBindingHandler.class);
    private String dispatchPath;

    public PostBindingHandler() {
        this.dispatchPath = SAMLConfigurationFactory.getConfiguration().getSystemConfiguration().getString("POSTDispatchPath", null);
    }

    public PostBindingHandler(String dispatchPath) {
        this.dispatchPath = dispatchPath;
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse response, Credential credential, OIOAuthnRequest request) throws IOException, ServletException {
        request.sign(credential);
        String encodedMessage = request.toBase64();
        req.setAttribute("action", (Object)request.getDestination());
        if (request.getRelayState() != null) {
            req.setAttribute("RelayState", (Object)request.getRelayState());
        }
        req.setAttribute("SAMLRequest", (Object)encodedMessage);
        RequestDispatcher dispatcher = req.getRequestDispatcher(this.dispatchPath);
        if (dispatcher == null) {
            log.error("No request dispatcher found for path: " + this.dispatchPath);
            throw new RuntimeException("No request dispatcher found for path: " + this.dispatchPath);
        }
        log.debug("Dispatching request to: " + this.dispatchPath);
        Audit.log(Operation.AUTHNREQUEST_POST, true, request.getID(), encodedMessage);
        dispatcher.forward((ServletRequest)req, (ServletResponse)response);
    }
}

