/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.configuration;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.configuration.FileConfiguration;
import dk.itst.oiosaml.configuration.SAMLConfigurationFactory;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.security.CredentialRepository;
import dk.itst.oiosaml.sp.service.RequestContext;
import dk.itst.oiosaml.sp.service.SAMLHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml2.metadata.ContactPerson;
import org.opensaml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.security.x509.BasicX509Credential;

public class ConfigurationHandler
implements SAMLHandler {
    public static final String SESSION_CONFIGURATION = "CONFIGURATION";
    private static final Logger log = LoggerFactory.getLogger(ConfigurationHandler.class);
    protected final VelocityEngine engine = new VelocityEngine();

    public ConfigurationHandler() {
        this.engine.setProperty("resource.loader", (Object)"classpath");
        this.engine.setProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            this.engine.init();
        }
        catch (Exception e) {
            log.error("Unable to initialize Velocity", e);
            throw new WrappedException(Layer.BUSINESS, (Throwable)e);
        }
    }

    @Override
    public void handleGet(RequestContext context) throws ServletException, IOException {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        if (request.getParameter("download") != null) {
            byte[] conf = (byte[])request.getSession().getAttribute(SESSION_CONFIGURATION);
            if (conf == null) {
                response.sendError(404, "No configuration available for download");
                return;
            }
            response.setContentType("application/octet-stream");
            response.setContentLength(conf.length);
            response.addHeader("Content-disposition", "attachment; filename=oiosaml.java-config.zip");
            response.getOutputStream().write(conf);
            return;
        }
        if (!this.checkConfiguration(response)) {
            return;
        }
        Map<String, Object> params = this.getStandardParameters(request);
        String res = this.renderTemplate("configure.vm", params, true);
        ConfigurationHandler.sendResponse(response, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePost(RequestContext context) throws ServletException, IOException {
        KeyStore ks;
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        if (!this.checkConfiguration(response)) {
            return;
        }
        List<?> parameters = ConfigurationHandler.extractParameterList(request);
        String orgName = ConfigurationHandler.extractParameter("organisationName", parameters);
        String orgUrl = ConfigurationHandler.extractParameter("organisationUrl", parameters);
        String email = ConfigurationHandler.extractParameter("email", parameters);
        String entityId = ConfigurationHandler.extractParameter("entityId", parameters);
        String password = ConfigurationHandler.extractParameter("keystorePassword", parameters);
        byte[] metadata = ConfigurationHandler.extractFile("metadata", parameters).get();
        FileItem ksData = ConfigurationHandler.extractFile("keystore", parameters);
        byte[] keystore = null;
        if (ksData != null) {
            keystore = ksData.get();
        }
        if (!ConfigurationHandler.checkNotNull(orgName, orgUrl, email, password, metadata, entityId) || metadata.length == 0 || keystore == null && !Boolean.valueOf(ConfigurationHandler.extractParameter("createkeystore", parameters)).booleanValue()) {
            Map<String, Object> params = this.getStandardParameters(request);
            params.put("error", "All fields must be filled.");
            params.put("organisationName", orgName);
            params.put("organisationUrl", orgUrl);
            params.put("email", email);
            params.put("keystorePassword", password);
            params.put("entityId", entityId);
            log.info("Parameters not correct: " + params);
            log.info("Metadata: " + new String(metadata));
            String res = this.renderTemplate("configure.vm", params, true);
            ConfigurationHandler.sendResponse(response, res);
            return;
        }
        Credential credential = context.getCredential();
        if (keystore != null && keystore.length > 0) {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(keystore);
                KeyStore ks2 = KeyStore.getInstance("JKS");
                ks2.load(byteArrayInputStream, password.toCharArray());
                credential = CredentialRepository.createCredential(ks2, password);
            }
            catch (Exception e) {
                log.info("Keystore is not of type JKS. Trying type PKCS12");
                try {
                    ks = KeyStore.getInstance("PKCS12");
                    byteArrayInputStream.reset();
                    ks.load(byteArrayInputStream, password.toCharArray());
                    credential = CredentialRepository.createCredential(ks, password);
                }
                catch (Exception e2) {
                    log.error("Unable to use/load keystore", e2);
                    throw new RuntimeException("Unable to use/load keystore", e2);
                }
            }
            finally {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
        } else if (Boolean.valueOf(ConfigurationHandler.extractParameter("createkeystore", parameters)).booleanValue()) {
            try {
                BasicX509Credential cred = new BasicX509Credential();
                KeyPair kp = dk.itst.oiosaml.security.SecurityHelper.generateKeyPairFromURI("http://www.w3.org/2001/04/xmlenc#rsa-1_5", 1024);
                cred.setPrivateKey(kp.getPrivate());
                cred.setPublicKey(kp.getPublic());
                credential = cred;
                ks = KeyStore.getInstance("JKS");
                ks.load(null, null);
                X509Certificate cert = dk.itst.oiosaml.security.SecurityHelper.generateCertificate(credential, ConfigurationHandler.getEntityId(request));
                cred.setEntityCertificate(cert);
                ks.setKeyEntry("oiosaml", credential.getPrivateKey(), password.toCharArray(), new Certificate[]{cert});
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ks.store(bos, password.toCharArray());
                keystore = bos.toByteArray();
                bos.close();
            }
            catch (Exception e) {
                log.error("Unable to generate credential", e);
                throw new RuntimeException("Unable to generate credential", e);
            }
        }
        EntityDescriptor descriptor = this.generateSPDescriptor(this.getBaseUrl(request), entityId, credential, orgName, orgUrl, email, Boolean.valueOf(ConfigurationHandler.extractParameter("enableArtifact", parameters)), Boolean.valueOf(ConfigurationHandler.extractParameter("enablePost", parameters)), Boolean.valueOf(ConfigurationHandler.extractParameter("enableSoap", parameters)), Boolean.valueOf(ConfigurationHandler.extractParameter("enablePostSLO", parameters)), Boolean.valueOf(ConfigurationHandler.extractParameter("supportOCESAttributeProfile", parameters)));
        File zipFile = this.generateZipFile(request.getContextPath(), password, metadata, keystore, descriptor);
        byte[] configurationContents = ConfigurationHandler.saveConfigurationInSession(request, zipFile);
        boolean written = this.writeConfiguration(ConfigurationHandler.getHome(), configurationContents);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("home", ConfigurationHandler.getHome());
        params.put("written", written);
        ConfigurationHandler.sendResponse(response, this.renderTemplate("done.vm", params, true));
    }

    public boolean writeConfiguration(String homeDir, byte[] configurationContents) {
        File root = new File(homeDir);
        if (!root.isDirectory() || !root.canWrite()) {
            return false;
        }
        boolean written = true;
        try {
            ZipInputStream input = new ZipInputStream(new ByteArrayInputStream(configurationContents));
            ZipEntry next = null;
            while ((next = input.getNextEntry()) != null) {
                File newFile = new File(root, next.getName());
                FileUtils.forceMkdir((File)newFile.getParentFile());
                FileOutputStream file = new FileOutputStream(newFile);
                IOUtils.copy((InputStream)input, (OutputStream)file);
                file.close();
                input.closeEntry();
            }
            input.close();
        }
        catch (IOException e) {
            log.error("Unable to write configuration files to " + root, e);
            written = false;
        }
        return written;
    }

    private static byte[] saveConfigurationInSession(HttpServletRequest request, File zipFile) throws IOException, FileNotFoundException {
        byte[] configurationContents = IOUtils.toByteArray((InputStream)new FileInputStream(zipFile));
        request.getSession().setAttribute(SESSION_CONFIGURATION, (Object)configurationContents);
        return configurationContents;
    }

    protected File generateZipFile(final String contextPath, final String password, byte[] idpMetadata, byte[] keystore, EntityDescriptor descriptor) throws IOException {
        File zipFile = File.createTempFile("oiosaml-", ".zip");
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        zos.putNextEntry(new ZipEntry("oiosaml-sp.properties"));
        zos.write(this.renderTemplate("defaultproperties.vm", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("homename", "oiosaml-sp.uri.home");
                this.put("servletPath", contextPath);
                this.put("password", password);
            }
        }, false).getBytes());
        zos.closeEntry();
        zos.putNextEntry(new ZipEntry("metadata/SP/SPMetadata.xml"));
        zos.write(SAMLUtil.getSAMLObjectAsPrettyPrintXML((XMLObject)descriptor).getBytes());
        zos.closeEntry();
        zos.putNextEntry(new ZipEntry("metadata/IdP/IdPMetadata.xml"));
        zos.write(idpMetadata);
        zos.closeEntry();
        zos.putNextEntry(new ZipEntry("certificate/keystore"));
        zos.write(keystore);
        zos.closeEntry();
        zos.putNextEntry(new ZipEntry("oiosaml-sp.log4j.xml"));
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/oiosaml-sp.log4j.xml"), (OutputStream)zos);
        zos.closeEntry();
        zos.close();
        return zipFile;
    }

    protected EntityDescriptor generateSPDescriptor(String baseUrl, String entityId, Credential credential, String orgName, String orgUrl, String email, boolean enableArtifact, boolean enableRedirect, boolean enableSoap, boolean enablePostSLO, boolean supportOCESAttributes) {
        EntityDescriptor descriptor = SAMLUtil.buildXMLObject(EntityDescriptor.class);
        descriptor.setEntityID(entityId);
        SPSSODescriptor spDescriptor = SAMLUtil.buildXMLObject(SPSSODescriptor.class);
        spDescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
        spDescriptor.setWantAssertionsSigned(Boolean.valueOf(true));
        ContactPerson contact = SAMLUtil.buildXMLObject(ContactPerson.class);
        contact.getEmailAddresses().add(SAMLUtil.createEmail(email));
        contact.setCompany(SAMLUtil.createCompany(orgName));
        contact.setType(ContactPersonTypeEnumeration.TECHNICAL);
        descriptor.getContactPersons().add(contact);
        descriptor.setOrganization(SAMLUtil.createOrganization(orgName, orgName, orgUrl));
        KeyDescriptor signingDescriptor = SAMLUtil.buildXMLObject(KeyDescriptor.class);
        signingDescriptor.setUse(UsageType.SIGNING);
        KeyDescriptor encryptionDescriptor = SAMLUtil.buildXMLObject(KeyDescriptor.class);
        encryptionDescriptor.setUse(UsageType.ENCRYPTION);
        try {
            KeyInfoGenerator gen = SecurityHelper.getKeyInfoGenerator((Credential)credential, (SecurityConfiguration)Configuration.getGlobalSecurityConfiguration(), null);
            signingDescriptor.setKeyInfo(gen.generate(credential));
            encryptionDescriptor.setKeyInfo(gen.generate(credential));
        }
        catch (SecurityException e1) {
            throw new WrappedException(Layer.BUSINESS, (Throwable)e1);
        }
        spDescriptor.getKeyDescriptors().add(signingDescriptor);
        spDescriptor.getKeyDescriptors().add(encryptionDescriptor);
        spDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        spDescriptor.getAssertionConsumerServices().add(SAMLUtil.createAssertionConsumerService(baseUrl + "/SAMLAssertionConsumer", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", 0, true));
        if (enableArtifact) {
            spDescriptor.getAssertionConsumerServices().add(SAMLUtil.createAssertionConsumerService(baseUrl + "/SAMLAssertionConsumer", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", 1, false));
        }
        if (enableRedirect) {
            spDescriptor.getAssertionConsumerServices().add(SAMLUtil.createAssertionConsumerService(baseUrl + "/SAMLAssertionConsumer", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", 2, false));
        }
        spDescriptor.getSingleLogoutServices().add(SAMLUtil.createSingleLogoutService(baseUrl + "/LogoutServiceHTTPRedirect", baseUrl + "/LogoutServiceHTTPRedirectResponse", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"));
        if (enableSoap) {
            spDescriptor.getSingleLogoutServices().add(SAMLUtil.createSingleLogoutService(baseUrl + "/LogoutServiceSOAP", null, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP"));
        }
        if (enablePostSLO) {
            spDescriptor.getSingleLogoutServices().add(SAMLUtil.createSingleLogoutService(baseUrl + "/LogoutServiceHTTPPost", baseUrl + "/LogoutServiceHTTPRedirectResponse", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST"));
        }
        NameIDFormat x509SubjectNameIDFormat = SAMLUtil.createNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        List nameIDFormats = spDescriptor.getNameIDFormats();
        nameIDFormats.add(x509SubjectNameIDFormat);
        if (enableArtifact) {
            spDescriptor.getArtifactResolutionServices().add(SAMLUtil.createArtifactResolutionService(baseUrl + "/SAMLAssertionConsumer"));
        }
        if (supportOCESAttributes) {
            ConfigurationHandler.addAttributeConsumerService(spDescriptor, entityId);
        }
        descriptor.getRoleDescriptors().add(spDescriptor);
        return descriptor;
    }

    private static void addAttributeConsumerService(SPSSODescriptor spDescriptor, String serviceName) {
        AttributeConsumingService service = SAMLUtil.createAttributeConsumingService(serviceName);
        String[] required = new String[]{"urn:oid:2.5.4.4", "urn:oid:2.5.4.3", "urn:oid:0.9.2342.19200300.100.1.1", "urn:oid:0.9.2342.19200300.100.1.3", "dk:gov:saml:attribute:AssuranceLevel", "dk:gov:saml:attribute:SpecVer", "urn:oid:2.5.4.5", "dk:gov:saml:attribute:IsYouthCert", "urn:oid:2.5.29.29"};
        String[] optional = new String[]{"dk:gov:saml:attribute:UniqueAccountKey", "dk:gov:saml:attribute:CvrNumberIdentifier", "urn:oid:2.5.4.10", "urn:oid:2.5.4.11", "urn:oid:2.5.4.12", "urn:oid:2.5.4.16", "urn:oid:2.5.4.65", "urn:oid:1.3.6.1.4.1.1466.115.121.1.8", "dk:gov:saml:attribute:PidNumberIdentifier", "dk:gov:saml:attribute:CprNumberIdentifier", "dk:gov:saml:attribute:RidNumberIdentifier", "dk:gov:saml:attribute:Privileges_intermediate", "dk:gov:saml:attribute:UserAdministratorIndicator"};
        for (String attr : required) {
            service.getRequestAttributes().add(SAMLUtil.createRequestedAttribute(attr, "urn:oasis:names:tc:SAML:2.0:attrname-format:basic", true));
        }
        for (String attr : optional) {
            service.getRequestAttributes().add(SAMLUtil.createRequestedAttribute(attr, "urn:oasis:names:tc:SAML:2.0:attrname-format:basic", false));
        }
        spDescriptor.getAttributeConsumingServices().add(service);
    }

    private static List<?> extractParameterList(HttpServletRequest request) {
        List parameters;
        try {
            DiskFileItemFactory itemFactory = new DiskFileItemFactory();
            parameters = new ServletFileUpload((FileItemFactory)itemFactory).parseRequest(request);
        }
        catch (FileUploadException e) {
            log.error("Unable to parse uploaded files", e);
            throw new RuntimeException("Unable to parse uploaded files", e);
        }
        return parameters;
    }

    private boolean checkConfiguration(HttpServletResponse response) throws IOException {
        if (this.isConfigured()) {
            ConfigurationHandler.sendResponse(response, this.renderTemplate("alreadyConfigured.vm", (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("home", ConfigurationHandler.getHome());
                }
            }, true));
            return false;
        }
        return true;
    }

    private static FileItem extractFile(String name, List<?> files) {
        for (FileItem file : files) {
            if (file.isFormField() || !file.getFieldName().equals(name)) continue;
            return file;
        }
        return null;
    }

    private static String extractParameter(String name, List<?> files) {
        for (FileItem file : files) {
            if (!file.isFormField() || !file.getFieldName().equals(name)) continue;
            return "".equals(file.getString()) ? null : file.getString();
        }
        return null;
    }

    private static void sendResponse(HttpServletResponse response, String res) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(res);
    }

    protected String getBaseUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        int idx = url.lastIndexOf(request.getServletPath());
        return url.substring(0, idx + request.getServletPath().length());
    }

    protected boolean isHomeAvailable() {
        String home = ConfigurationHandler.getHome();
        if (home == null) {
            return false;
        }
        return new File(home).isDirectory();
    }

    protected boolean isConfigured() {
        String home = ConfigurationHandler.getHome();
        if (home == null) {
            return false;
        }
        File homeDir = new File(home);
        String[] files = homeDir.list();
        return files != null && files.length > 0;
    }

    protected String renderTemplate(String template, Map<String, Object> objects, boolean html) {
        VelocityContext ctx = new VelocityContext();
        for (Map.Entry<String, Object> e : objects.entrySet()) {
            ctx.put(e.getKey(), e.getValue());
        }
        StringWriter w = new StringWriter();
        try {
            if (html) {
                this.engine.mergeTemplate("head.vm", "UTF-8", (Context)ctx, (Writer)w);
            }
            this.engine.mergeTemplate(template, "UTF-8", (Context)ctx, (Writer)w);
            if (html) {
                this.engine.mergeTemplate("foot.vm", "UTF-8", (Context)ctx, (Writer)w);
            }
        }
        catch (Exception e) {
            log.error("Unable to merge templates", e);
        }
        return w.toString();
    }

    private static String getHome() {
        String pathToHomeDir = ((FileConfiguration)SAMLConfigurationFactory.getConfiguration()).getHomeDir();
        File homeDir = new File(pathToHomeDir);
        if (!homeDir.exists()) {
            homeDir.mkdir();
        }
        return pathToHomeDir;
    }

    private static String getEntityId(HttpServletRequest request) {
        return request.getScheme() + "://saml." + request.getServerName();
    }

    private static boolean checkNotNull(Object ... objs) {
        for (Object o : objs) {
            if (o != null) continue;
            return false;
        }
        return true;
    }

    protected Map<String, Object> getStandardParameters(HttpServletRequest request) {
        String base = this.getBaseUrl(request);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("artifactResponseUrl", base + "/SAMLAssertionConsumer");
        params.put("postResponseUrl", base + "/SAMLAssertionConsumer");
        params.put("logoutUrl", base + "/SAMLAssertionConsumer");
        params.put("logoutResponseUrl", base + "/LogoutServiceHTTPRedirectResponse");
        params.put("logoutRequestUrl", base + "/LogoutServiceHTTPRedirect");
        params.put("logoutSoapRequestUrl", base + "/LogoutServiceSOAP");
        params.put("logoutPostRequestUrl", base + "/LogoutServiceHTTPPost");
        params.put("home", ConfigurationHandler.getHome());
        params.put("entityId", ConfigurationHandler.getEntityId(request));
        return params;
    }
}

