/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.metadata;

import dk.itst.oiosaml.configuration.SAMLConfigurationFactory;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.helper.DeveloperHelper;
import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.security.CredentialRepository;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import org.apache.commons.configuration.Configuration;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.i18n.filter.UntrustedUrlInput;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.fishwife.jrugged.CircuitBreaker;
import org.fishwife.jrugged.CircuitBreakerConfig;
import org.fishwife.jrugged.CircuitBreakerException;
import org.fishwife.jrugged.CircuitBreakerFactory;
import org.fishwife.jrugged.DefaultFailureInterpreter;
import org.fishwife.jrugged.FailureInterpreter;
import org.opensaml.xml.security.x509.X509Credential;

public class CRLChecker {
    private static final Logger log = LoggerFactory.getLogger(CRLChecker.class);
    private static final String AUTH_INFO_ACCESS = X509Extension.authorityInfoAccess.getId();
    private static final CircuitBreakerFactory CIRCUIT_BREAKER_FACTORY = new CircuitBreakerFactory();
    private Timer timer;

    public void checkCertificates(IdpMetadata metadata, final Configuration conf) {
        long resetTime = conf.getLong("oiosaml-sp.cb.reset.time.in.seconds") * 1000L;
        int attemptsBeforeOpening = conf.getInt("oiosaml-sp.cb.attempts.before.opening");
        long attemptsWithin = conf.getLong("oiosaml-sp.cb.attempts.within.in.seconds") * 1000L;
        long delayBetweenAttempts = conf.getLong("oiosaml-sp.cb.delay.between.attempts.in.seconds") * 1000L;
        long certificatesRemainValidPeriod = conf.getLong("oiosaml-sp.remain.valid.period.in.seconds") * 1000L;
        for (final String entityId : metadata.getEntityIDs()) {
            final IdpMetadata.Metadata md = metadata.getMetadata(entityId);
            for (final X509Certificate certificate : md.getAllCertificates()) {
                CircuitBreaker circuitBreaker = CIRCUIT_BREAKER_FACTORY.createCircuitBreaker(certificate.getSubjectDN().toString(), new CircuitBreakerConfig(resetTime, (FailureInterpreter)new DefaultFailureInterpreter(attemptsBeforeOpening, attemptsWithin)));
                boolean errorState = false;
                do {
                    try {
                        if (((Boolean)circuitBreaker.invoke((Callable)new Callable<Boolean>(){

                            @Override
                            public Boolean call() {
                                return CRLChecker.checkCertificate(conf, entityId, md, certificate);
                            }
                        })).booleanValue()) {
                            md.setCertificateValid(certificate, true);
                            log.debug("Certificate validated successfully: " + certificate.getSubjectDN());
                        } else {
                            md.setCertificateValid(certificate, false);
                            log.debug("Certificate did not validate: " + certificate.getSubjectDN());
                        }
                        errorState = false;
                    }
                    catch (CircuitBreakerException cbe) {
                        CRLChecker.RevokeCertificateIfRemainValidPeriodIsExpired(md, certificate, (Exception)((Object)cbe), certificatesRemainValidPeriod);
                        errorState = false;
                    }
                    catch (Exception e) {
                        CRLChecker.RevokeCertificateIfRemainValidPeriodIsExpired(md, certificate, e, certificatesRemainValidPeriod);
                        errorState = true;
                        try {
                            Thread.sleep(delayBetweenAttempts);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (errorState);
            }
        }
    }

    private static void RevokeCertificateIfRemainValidPeriodIsExpired(IdpMetadata.Metadata md, X509Certificate certificate, Exception e, long certificatesRemainValidPeriod) {
        Date lastTimeForCertificationValidation = md.getLastTimeForCertificationValidation(certificate);
        if (lastTimeForCertificationValidation != null) {
            Date currentTime = new Date();
            Date lastTimeForCertificationValidationPlusConfiguiredRemainValidPeriod = new Date(lastTimeForCertificationValidation.getTime() + certificatesRemainValidPeriod);
            if (currentTime.before(lastTimeForCertificationValidationPlusConfiguiredRemainValidPeriod)) {
                log.warn("Unexpected error while checking revocation of certificate. Certificate " + certificate.getSubjectDN() + " will remain valid until " + lastTimeForCertificationValidationPlusConfiguiredRemainValidPeriod + " if not validated successfully before.", e);
            } else {
                log.error("Unexpected error while checking revocation of certificate. Certificate " + certificate.getSubjectDN() + " has been marked as revoked!!", e);
                md.setCertificateValid(certificate, false);
            }
        }
    }

    private static Boolean checkCertificate(Configuration conf, String entityId, IdpMetadata.Metadata md, X509Certificate certificate) {
        String issuerName;
        boolean selfSigned;
        boolean validated = false;
        Exception error = null;
        boolean support_self_signed_certificates = conf.getBoolean("oiosaml-sp.selfsignedcertificates", false);
        boolean disable_check_on_oces_test_certificates = conf.getBoolean("oiosaml-cp.crl.disable-in-oces-test", true);
        if (support_self_signed_certificates && (selfSigned = certificate.getSubjectDN().equals(certificate.getIssuerDN()))) {
            log.info("Certificate is self-signed, skip validation");
            return true;
        }
        if (disable_check_on_oces_test_certificates && (issuerName = certificate.getIssuerDN().getName()).indexOf("C=DK") >= 0 && issuerName.indexOf("O=TRUST2408") >= 0 && issuerName.indexOf("Systemtest") >= 0) {
            log.info("Certificate is from OCES-test, skip validation");
            return true;
        }
        try {
            log.debug("Checking if certificate with the following subject is revoked using OCSP: " + certificate.getSubjectDN());
            validated = CRLChecker.doOCSPCheck(conf, entityId, md, certificate);
            if (validated) {
                log.info("Certificate with the following subject IS NOT marked as revoked using OCSP: " + certificate.getSubjectDN());
            } else {
                log.info("Certificate with the following subject IS revoked using OCSP: " + certificate.getSubjectDN());
            }
        }
        catch (Exception e) {
            log.warn("Unexpected error while validating certificate using OCSP.", e);
            try {
                log.debug("Checking if certificate with the following subject is revoked using CRL: " + certificate.getSubjectDN());
                validated = CRLChecker.doCRLCheck(conf, entityId, md, certificate);
                if (validated) {
                    log.info("Certificate with the following subject IS NOT marked as revoked using CRL: " + certificate.getSubjectDN());
                } else {
                    log.info("Certificate with the following subject IS revoked using CRL: " + certificate.getSubjectDN());
                }
            }
            catch (Exception ex) {
                log.warn("Unexpected error while validating certificate using CRL.", e);
                error = ex;
            }
        }
        if (error != null) {
            throw new WrappedException(Layer.BUSINESS, (Throwable)error);
        }
        return validated;
    }

    private static boolean doOCSPCheck(Configuration conf, String entityId, IdpMetadata.Metadata md, X509Certificate certificate) throws CertificateException, CertPathValidatorException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        boolean revoked;
        String ocspServer = CRLChecker.getOCSPUrl(conf, entityId, certificate);
        if (ocspServer == null) {
            String message = "No OCSP access location could be found for " + entityId;
            log.debug(message);
            throw new RuntimeException(message);
        }
        log.debug("Starting OCSP validation of certificate " + certificate.getSubjectDN());
        X509Certificate ca = CRLChecker.getCertificateCA(conf);
        if (ca == null) {
            throw new RuntimeException("CA Certificate for OCSP check could not be retrieved!");
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(certificate);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        CertPath cp = cf.generateCertPath(certList);
        Security.setProperty("ocsp.enable", "true");
        Security.setProperty("ocsp.responderURL", ocspServer);
        try {
            TrustAnchor anchor = new TrustAnchor(ca, null);
            PKIXParameters params = new PKIXParameters(Collections.singleton(anchor));
            params.setRevocationEnabled(true);
            CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
            cpv.validate(cp, params);
            log.debug("Certificate successfully validated during OCSP check.");
            revoked = false;
        }
        catch (CertPathValidatorException cpve) {
            if ("Certificate has been revoked".equals(cpve.getMessage())) {
                revoked = true;
                log.info("Certificate revoked, cert[" + cpve.getIndex() + "] :" + cpve.getMessage());
            }
            log.error("Validation failure, cert[" + cpve.getIndex() + "] :" + cpve.getMessage());
            throw cpve;
        }
        if (!revoked) {
            Audit.log(Operation.OCSPCHECK, false, entityId, "Revoked: NO");
        } else {
            Audit.log(Operation.OCSPCHECK, false, entityId, "Revoked: YES");
        }
        return !revoked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate getCertificateCA(Configuration conf) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate ca = null;
        InputStream is = null;
        String caPath = conf.getString("oiosaml-sp.ocsp.ca");
        try {
            if (caPath == null) {
                log.debug("CA certificate path is not configured");
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            log.debug("Fetching CA certificate located at: " + caPath);
            URL u = new URL(caPath);
            is = u.openStream();
            ca = (X509Certificate)cf.generateCertificate(is);
            is.close();
        }
        catch (CertificateException e) {
            log.error("Unable to read CA certficate from: " + caPath, e);
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        catch (Exception e) {
            DeveloperHelper.log("The OIOSAML library default configuration checks for the trusted CA certificate in the /temp/ folder - you can change this configuration with the oiosaml-sp.ocsp.ca property setting");
            log.error("Unexpected error while reading CA certficate from: " + caPath, e);
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOCSPUrl(Configuration conf, String entityId, X509Certificate certificate) {
        String url = conf.getString("oiosaml-sp.ocsp.responder");
        if (url != null) {
            return url;
        }
        log.debug("No OCSP configured for " + entityId + " attempting to extract OCSP location from certificate " + certificate.getSubjectDN());
        AuthorityInformationAccess authInfoAcc = null;
        ASN1InputStream aIn = null;
        try {
            byte[] bytes = certificate.getExtensionValue(AUTH_INFO_ACCESS);
            aIn = new ASN1InputStream(bytes);
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            aIn.close();
            aIn = new ASN1InputStream(octs.getOctets());
            ASN1Primitive auth_info_acc = aIn.readObject();
            aIn.close();
            if (auth_info_acc != null) {
                authInfoAcc = AuthorityInformationAccess.getInstance((Object)auth_info_acc);
            }
        }
        catch (Exception e) {
            log.debug("Cannot extract access location of OCSP responder.", e);
            String octs = null;
            return octs;
        }
        finally {
            if (aIn != null) {
                try {
                    aIn.close();
                }
                catch (IOException auth_info_acc) {}
            }
        }
        List<String> ocspUrls = CRLChecker.getOCSPUrls(authInfoAcc);
        Iterator<String> urlIt = ocspUrls.iterator();
        while (urlIt.hasNext()) {
            UntrustedUrlInput ocspUrl = new UntrustedUrlInput((Object)urlIt.next());
            url = ocspUrl.toString();
        }
        return url;
    }

    private static List<String> getOCSPUrls(AuthorityInformationAccess authInfoAccess) {
        ArrayList<String> urls = new ArrayList<String>();
        if (authInfoAccess != null) {
            AccessDescription[] ads = authInfoAccess.getAccessDescriptions();
            for (int i = 0; i < ads.length; ++i) {
                GeneralName name;
                if (!ads[i].getAccessMethod().equals((Object)AccessDescription.id_ad_ocsp) || (name = ads[i].getAccessLocation()).getTagNo() != 6) continue;
                String url = ((DERIA5String)name.getName()).getString();
                urls.add(url);
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doCRLCheck(Configuration conf, String entityId, IdpMetadata.Metadata md, X509Certificate certificate) throws IOException, CertificateException, CRLException, KeyStoreException, NoSuchAlgorithmException {
        boolean revoked = true;
        String url = CRLChecker.getCRLUrl(conf, entityId, certificate);
        if (url == null) {
            String message = "No CRL url could be found for " + entityId;
            log.debug(message);
            throw new RuntimeException(message);
        }
        InputStream is = null;
        try {
            URL u = new URL(url);
            is = u.openStream();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)cf.generateCRL(is);
            log.debug("CRL for " + url + ": " + crl);
            if (!CRLChecker.checkCRLSignature(crl, certificate, conf)) {
                String message = "CRL Signature could not be validated!!!";
                Audit.log(Operation.CRLCHECK, false, entityId, "CRL Signature could not be validated!!!");
                throw new RuntimeException("CRL Signature could not be validated!!!");
            }
            X509CRLEntry revokedCertificate = crl.getRevokedCertificate(certificate.getSerialNumber());
            if (revokedCertificate != null) {
                log.debug("Certificate found in revocation list " + certificate.getSubjectDN());
                revoked = true;
            } else {
                revoked = false;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!revoked) {
            Audit.log(Operation.CRLCHECK, false, entityId, "Revoked: NO");
        } else {
            Audit.log(Operation.CRLCHECK, false, entityId, "Revoked: YES");
        }
        return !revoked;
    }

    private static String getCRLUrl(Configuration conf, String entityId, X509Certificate certificate) {
        String url = conf.getString("oiosaml-sp.crl." + entityId);
        if (url != null) {
            return url;
        }
        log.debug("No CRL configured for " + entityId + " attempting to extract distribution point from certificate " + certificate.getSubjectDN());
        byte[] val = certificate.getExtensionValue("2.5.29.31");
        if (val != null) {
            try {
                CRLDistPoint point = CRLDistPoint.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])val));
                for (DistributionPoint dp : point.getDistributionPoints()) {
                    if (dp.getDistributionPoint() == null || !(dp.getDistributionPoint().getName() instanceof GeneralNames)) continue;
                    GeneralNames gn = (GeneralNames)dp.getDistributionPoint().getName();
                    for (GeneralName g : gn.getNames()) {
                        if (!(g.getName() instanceof DERIA5String)) continue;
                        url = ((DERIA5String)g.getName()).getString();
                    }
                }
            }
            catch (IOException e) {
                log.debug("Cannot extract distribution point for certificate.", e);
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    private static boolean checkCRLSignature(X509CRL crl, X509Certificate certificate, Configuration conf) throws WrappedException, NoSuchAlgorithmException, CertificateException, IllegalStateException, KeyStoreException, IOException {
        if (conf.getString("oiosaml-sp.crl.truststore", null) == null) {
            return true;
        }
        CredentialRepository cr = new CredentialRepository();
        cr.getCertificate(SAMLConfigurationFactory.getConfiguration().getKeystore(), conf.getString("oiosaml-sp.crl.truststore.password"), null);
        for (X509Credential x509Credential : cr.getCredentials()) {
            try {
                crl.verify(x509Credential.getPublicKey());
            }
            catch (Exception e) {
                log.debug("CRL not signed by " + x509Credential);
                return false;
            }
        }
        return true;
    }

    public void startChecker(long period, final IdpMetadata metadata, final Configuration conf) {
        if (this.timer != null) {
            return;
        }
        String proxyHost = conf.getString("oiosaml-sp.http.proxy.host");
        String proxyPort = conf.getString("oiosaml-sp.http.proxy.port");
        if (proxyHost != null && proxyPort != null) {
            log.debug("Enabling use of proxy " + proxyHost + " port " + proxyPort + " when checking revocation of certificates.");
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", proxyPort);
        }
        log.info("Starting CRL checker, running with " + period + " seconds interval. Checking " + metadata.getEntityIDs().size() + " certificates");
        this.timer = new Timer("CRLChecker");
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                log.debug("Running CRL checker task");
                try {
                    CRLChecker.this.checkCertificates(metadata, conf);
                }
                catch (Exception e) {
                    log.error("Unable to run CRL checker", e);
                }
            }
        }, 1000L, 1000L * period);
    }

    public void stopChecker() {
        if (this.timer != null) {
            log.info("Stopping CRL checker");
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void setAllCertificatesValid(IdpMetadata metadata) {
        for (String entityId : metadata.getEntityIDs()) {
            IdpMetadata.Metadata md = metadata.getMetadata(entityId);
            for (X509Certificate certificate : md.getAllCertificates()) {
                md.setCertificateValid(certificate, true);
            }
        }
    }
}

