/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model;

import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.model.AssuranceLevel;
import dk.itst.oiosaml.sp.model.OIOSamlObject;
import dk.itst.oiosaml.sp.model.validation.AssertionValidator;
import dk.itst.oiosaml.sp.model.validation.ValidationException;
import dk.itst.oiosaml.sp.util.AttributeUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.XMLObject;

public class OIOAssertion
extends OIOSamlObject {
    private static final Logger log = LoggerFactory.getLogger(OIOAssertion.class);
    private final Assertion assertion;

    public OIOAssertion(Assertion assertion) {
        super((XMLObject)assertion);
        this.assertion = assertion;
    }

    public static OIOAssertion fromResponse(Response response) {
        if (response.getAssertions().isEmpty()) {
            throw new RuntimeException("Didn't get an assertion in ArtifactResponse");
        }
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        return new OIOAssertion(assertion);
    }

    public String getSubjectNameIDValue() {
        String retVal = null;
        if (this.assertion.getSubject() != null && this.assertion.getSubject().getNameID() != null) {
            retVal = this.assertion.getSubject().getNameID().getValue();
        }
        return retVal;
    }

    public boolean checkRecipient(String assertionConsumerURL) {
        if (assertionConsumerURL == null) {
            return false;
        }
        if (this.assertion.getSubject() == null) {
            return false;
        }
        if (this.assertion.getSubject().getSubjectConfirmations() == null) {
            return false;
        }
        for (SubjectConfirmation subjectConfirmation : this.assertion.getSubject().getSubjectConfirmations()) {
            SubjectConfirmationData subjectConfirmationData;
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod()) || (subjectConfirmationData = subjectConfirmation.getSubjectConfirmationData()) == null || !assertionConsumerURL.equals(subjectConfirmationData.getRecipient())) continue;
            return true;
        }
        return false;
    }

    public DateTime getConfirmationTime() {
        if (this.assertion.getSubject() == null) {
            return null;
        }
        if (this.assertion.getSubject().getSubjectConfirmations() == null || this.assertion.getSubject().getSubjectConfirmations().isEmpty()) {
            return null;
        }
        for (SubjectConfirmation subjectConfirmation : this.assertion.getSubject().getSubjectConfirmations()) {
            SubjectConfirmationData data = subjectConfirmation.getSubjectConfirmationData();
            if (data == null || data.getNotOnOrAfter() == null) continue;
            return data.getNotOnOrAfter();
        }
        return null;
    }

    public String getSessionIndex() {
        String retVal = null;
        if (this.assertion != null && this.assertion.getAuthnStatements() != null && this.assertion.getAuthnStatements().size() > 0) {
            AuthnStatement authnStatement = (AuthnStatement)this.assertion.getAuthnStatements().get(0);
            retVal = authnStatement.getSessionIndex();
        }
        return retVal;
    }

    public boolean hasSessionExpired() {
        boolean retVal = false;
        if (this.assertion != null && this.assertion.getAuthnStatements() != null && this.assertion.getAuthnStatements().size() > 0) {
            AuthnStatement authnStatement = (AuthnStatement)this.assertion.getAuthnStatements().get(0);
            retVal = authnStatement.getSessionNotOnOrAfter() != null ? authnStatement.getSessionNotOnOrAfter().isBeforeNow() : false;
        }
        return retVal;
    }

    public String getAuthnContextClassRef() {
        AuthnContextClassRef authnContextClassRef;
        AuthnStatement authnStatement;
        AuthnContext authnContext;
        String retVal = null;
        if (this.assertion.getAuthnStatements() != null && this.assertion.getAuthnStatements().size() > 0 && (authnContext = (authnStatement = (AuthnStatement)this.assertion.getAuthnStatements().get(0)).getAuthnContext()) != null && (authnContextClassRef = authnContext.getAuthnContextClassRef()) != null) {
            retVal = authnContextClassRef.getAuthnContextClassRef();
        }
        return retVal;
    }

    public void validateAssertion(AssertionValidator validator, String spEntityID, String spAssertionConsumerURL) throws ValidationException {
        try {
            this.assertion.validate(false);
        }
        catch (org.opensaml.xml.validation.ValidationException e) {
            throw new ValidationException((Exception)((Object)e));
        }
        if (!SAMLVersion.VERSION_20.equals(this.assertion.getVersion())) {
            throw new ValidationException("The assertion must be version 2.0. Was " + this.assertion.getVersion());
        }
        if (this.assertion.getID() == null) {
            throw new ValidationException("The assertion must contain a ID");
        }
        log.debug("Using validator: " + validator);
        if (validator != null) {
            validator.validate(this, spEntityID, spAssertionConsumerURL);
        }
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public int getAssuranceLevel() {
        for (AttributeStatement attributeStatement : this.assertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                if (!"dk:gov:saml:attribute:AssuranceLevel".equals(attribute.getName())) continue;
                String value = AttributeUtil.extractAttributeValueValue(attribute);
                return new AssuranceLevel(value).getValue();
            }
        }
        return 0;
    }

    public String getID() {
        return this.assertion.getID();
    }

    public boolean isHolderOfKey() {
        if (this.assertion.getSubject() == null) {
            return false;
        }
        if (this.assertion.getSubject().getSubjectConfirmations().isEmpty()) {
            return false;
        }
        return "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(((SubjectConfirmation)this.assertion.getSubject().getSubjectConfirmations().get(0)).getMethod());
    }

    public Collection<String> getAudience() {
        ArrayList<String> audiences = new ArrayList<String>();
        if (this.assertion.getConditions() == null) {
            return audiences;
        }
        for (AudienceRestriction audienceRestriction : this.assertion.getConditions().getAudienceRestrictions()) {
            for (Audience audience : audienceRestriction.getAudiences()) {
                audiences.add(audience.getAudienceURI());
            }
        }
        return audiences;
    }

    public DateTime getConditionTime() {
        if (this.assertion.getConditions() == null) {
            return null;
        }
        DateTime notOnOrAfter = this.assertion.getConditions().getNotOnOrAfter();
        return notOnOrAfter;
    }

    public String getIssuer() {
        return this.assertion.getIssuer().getValue();
    }
}

